/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.regionreplication;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestRegionReplicationForSkipWAL {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicationForSkipWAL.class);
    private static final byte[] FAM1 = Bytes.toBytes((String)"family_test1");
    private static final byte[] QUAL1 = Bytes.toBytes((String)"qualifier_test1");
    private static final byte[] FAM2 = Bytes.toBytes((String)"family_test2");
    private static final byte[] QUAL2 = Bytes.toBytes((String)"qualifier_test2");
    private static final byte[] FAM3 = Bytes.toBytes((String)"family_test3");
    private static final byte[] QUAL3 = Bytes.toBytes((String)"qualifier_test3");
    private static final byte[] FAM4 = Bytes.toBytes((String)"family_test4");
    private static final byte[] QUAL4 = Bytes.toBytes((String)"qualifier_test4");
    private static final byte[] FAM5 = Bytes.toBytes((String)"family_test5");
    private static final byte[] QUAL5 = Bytes.toBytes((String)"qualifier_test5");
    private static final byte[] FAM6 = Bytes.toBytes((String)"family_test6");
    private static final byte[] QUAL6 = Bytes.toBytes((String)"qualifier_test6");
    private static final HBaseTestingUtil HTU = new HBaseTestingUtil();
    private static final int NB_SERVERS = 2;
    private static final String strTableName = "TestRegionReplicationForSkipWAL";

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = HTU.getConfiguration();
        conf.setBoolean("hbase.region.replica.replication.enabled", true);
        conf.setBoolean("hbase.region.replica.wait.for.primary.flush", false);
        HTU.startMiniCluster(StartTestingClusterOption.builder().numRegionServers(2).build());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        HTU.shutdownMiniCluster();
    }

    @Test
    public void testReplicateToReplicaWhenSkipWAL() throws Exception {
        HRegion[] skipWALRegions = this.createTable(true);
        byte[] rowKey1 = Bytes.toBytes((int)1);
        byte[] value1 = Bytes.toBytes((int)2);
        byte[] rowKey2 = Bytes.toBytes((int)2);
        byte[] value2 = Bytes.toBytes((int)4);
        skipWALRegions[0].batchMutate(new Mutation[]{new Put(rowKey1).addColumn(FAM1, QUAL1, value1), new Put(rowKey2).addColumn(FAM2, QUAL2, value2)});
        try (Table skipWALTable = HTU.getConnection().getTable(this.getTableName(true));){
            HTU.waitFor(30000L, () -> TestRegionReplicationForSkipWAL.checkReplica(skipWALTable, FAM1, QUAL1, rowKey1, value1) && TestRegionReplicationForSkipWAL.checkReplica(skipWALTable, FAM2, QUAL2, rowKey2, value2));
        }
        byte[] rowKey3 = Bytes.toBytes((int)3);
        byte[] value3 = Bytes.toBytes((int)6);
        byte[] rowKey4 = Bytes.toBytes((int)4);
        byte[] value4 = Bytes.toBytes((int)8);
        byte[] rowKey5 = Bytes.toBytes((int)5);
        byte[] value5 = Bytes.toBytes((int)10);
        byte[] rowKey6 = Bytes.toBytes((int)6);
        byte[] value6 = Bytes.toBytes((int)12);
        HRegion[] normalRegions = this.createTable(false);
        normalRegions[0].batchMutate(new Mutation[]{new Put(rowKey3).addColumn(FAM3, QUAL3, value3), new Put(rowKey4).addColumn(FAM4, QUAL4, value4).setDurability(Durability.SKIP_WAL), new Put(rowKey5).addColumn(FAM5, QUAL5, value5).setDurability(Durability.SKIP_WAL), new Put(rowKey6).addColumn(FAM6, QUAL6, value6)});
        try (Table normalTable = HTU.getConnection().getTable(this.getTableName(false));){
            HTU.waitFor(30000L, () -> TestRegionReplicationForSkipWAL.checkReplica(normalTable, FAM3, QUAL3, rowKey3, value3) && TestRegionReplicationForSkipWAL.checkReplica(normalTable, FAM4, QUAL4, rowKey4, value4) && TestRegionReplicationForSkipWAL.checkReplica(normalTable, FAM5, QUAL5, rowKey5, value5) && TestRegionReplicationForSkipWAL.checkReplica(normalTable, FAM6, QUAL6, rowKey6, value6));
        }
    }

    private static boolean checkReplica(Table table, byte[] fam, byte[] qual, byte[] rowKey, byte[] expectValue) throws IOException {
        Get get = new Get(rowKey).setConsistency(Consistency.TIMELINE).setReplicaId(1);
        Result result = table.get(get);
        byte[] value = result.getValue(fam, qual);
        return value != null && value.length > 0 && Arrays.equals(expectValue, value);
    }

    private TableName getTableName(boolean skipWAL) {
        return TableName.valueOf((String)(strTableName + (skipWAL ? "_skipWAL" : "")));
    }

    private HRegion[] createTable(boolean skipWAL) throws Exception {
        TableName tableName = this.getTableName(skipWAL);
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(2).setColumnFamilies(Arrays.asList(ColumnFamilyDescriptorBuilder.of((byte[])FAM1), ColumnFamilyDescriptorBuilder.of((byte[])FAM2), ColumnFamilyDescriptorBuilder.of((byte[])FAM3), ColumnFamilyDescriptorBuilder.of((byte[])FAM4), ColumnFamilyDescriptorBuilder.of((byte[])FAM5), ColumnFamilyDescriptorBuilder.of((byte[])FAM6)));
        if (skipWAL) {
            builder.setDurability(Durability.SKIP_WAL);
        }
        TableDescriptor tableDescriptor = builder.build();
        HTU.getAdmin().createTable(tableDescriptor);
        HRegion[] regions = new HRegion[2];
        for (int i = 0; i < 2; ++i) {
            HRegionServer rs = HTU.getMiniHBaseCluster().getRegionServer(i);
            List onlineRegions = rs.getRegions(tableName);
            for (HRegion region : onlineRegions) {
                int replicaId = region.getRegionInfo().getReplicaId();
                Assert.assertTrue((regions[replicaId] == null ? 1 : 0) != 0);
                regions[region.getRegionInfo().getReplicaId()] = region;
            }
        }
        for (HRegion region : regions) {
            Assert.assertNotNull((Object)region);
        }
        return regions;
    }
}

