/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.regionreplication;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.regionreplication.RegionReplicationBufferManager;
import org.apache.hadoop.hbase.regionserver.regionreplication.RegionReplicationSink;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionReplicationBufferManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicationBufferManager.class);
    private Configuration conf;
    private RegionServerServices rsServices;
    private RegionReplicationBufferManager manager;

    @Before
    public void setUp() {
        this.conf = HBaseConfiguration.create();
        this.rsServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        Mockito.when((Object)this.rsServices.getConfiguration()).thenReturn((Object)this.conf);
    }

    @After
    public void tearDown() {
        if (this.manager != null) {
            this.manager.stop();
        }
    }

    private HRegion mockRegion(RegionInfo regionInfo, long pendingSize) throws IOException {
        HRegion region = (HRegion)Mockito.mock(HRegion.class);
        Mockito.when((Object)region.getRegionInfo()).thenReturn((Object)regionInfo);
        if (pendingSize < 0L) {
            Mockito.when((Object)region.getRegionReplicationSink()).thenReturn(Optional.empty());
        } else {
            RegionReplicationSink sink = (RegionReplicationSink)Mockito.mock(RegionReplicationSink.class);
            Mockito.when((Object)sink.pendingSize()).thenReturn((Object)pendingSize);
            Mockito.when((Object)region.getRegionReplicationSink()).thenReturn(Optional.of(sink));
        }
        return region;
    }

    @Test
    public void testScheduleFlush() throws IOException, InterruptedException {
        this.conf.setLong("hbase.region.read-replica.sink.max-pending-size", 0x100000L);
        this.manager = new RegionReplicationBufferManager(this.rsServices);
        RegionInfo info1 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"info1")).build();
        RegionInfo info2 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"info2")).build();
        HRegion region1 = this.mockRegion(info1, 1000L);
        HRegion region2 = this.mockRegion(info2, 10000L);
        Mockito.when((Object)this.rsServices.getRegions()).thenReturn(Arrays.asList(region1, region2));
        CountDownLatch arrive = new CountDownLatch(1);
        CountDownLatch resume = new CountDownLatch(1);
        Mockito.when((Object)region2.flushcache(ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (FlushLifeCycleTracker)ArgumentMatchers.any())).then(i -> {
            arrive.countDown();
            resume.await();
            HRegion.FlushResultImpl result = (HRegion.FlushResultImpl)Mockito.mock(HRegion.FlushResultImpl.class);
            Mockito.when((Object)result.isFlushSucceeded()).thenReturn((Object)true);
            return result;
        });
        Assert.assertTrue((boolean)this.manager.increase(1024000L));
        arrive.await();
        ((RegionServerServices)Mockito.verify((Object)this.rsServices, (VerificationMode)Mockito.times((int)1))).getRegions();
        Assert.assertFalse((boolean)this.manager.increase(102400L));
        resume.countDown();
        Thread.sleep(2000L);
        ((RegionServerServices)Mockito.verify((Object)this.rsServices, (VerificationMode)Mockito.times((int)1))).getRegions();
    }
}

