/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.regionserver.InternalScan;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanFixture;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionBackedScanner;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestStoreScanner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStoreScanner.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestStoreScanner.class);
    @Rule
    public TestName name = new TestName();
    private static final String CF_STR = "cf";
    private static final byte[] CF = Bytes.toBytes((String)"cf");
    static Configuration CONF = HBaseConfiguration.create();
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private ScanInfo scanInfo = new ScanInfo(CONF, CF, 0, Integer.MAX_VALUE, Long.MAX_VALUE, KeepDeletedCells.FALSE, 65536L, 0L, CellComparator.getInstance(), false);
    private static final byte[] ZERO = new byte[]{48};
    private static final byte[] ZERO_POINT_ZERO = new byte[]{48, 46, 48};
    private static final byte[] ONE = new byte[]{49};
    private static final byte[] TWO = new byte[]{50};
    private static final byte[] TWO_POINT_TWO = new byte[]{50, 46, 50};
    private static final byte[] THREE = new byte[]{51};
    private static final byte[] FOUR = new byte[]{52};
    private static final byte[] FIVE = new byte[]{53};
    private static final byte[] VALUE = new byte[]{118};
    private static final int CELL_GRID_BLOCK2_BOUNDARY = 4;
    private static final int CELL_GRID_BLOCK3_BOUNDARY = 11;
    private static final int CELL_GRID_BLOCK4_BOUNDARY = 15;
    private static final int CELL_GRID_BLOCK5_BOUNDARY = 19;
    private static final Cell[] CELL_GRID = new Cell[]{ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(ONE).setFamily(CF).setQualifier(ONE).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(ONE).setFamily(CF).setQualifier(TWO).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(ONE).setFamily(CF).setQualifier(THREE).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(ONE).setFamily(CF).setQualifier(FOUR).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(TWO).setFamily(CF).setQualifier(ONE).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(TWO).setFamily(CF).setQualifier(TWO).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(TWO).setFamily(CF).setQualifier(THREE).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(TWO).setFamily(CF).setQualifier(FOUR).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(TWO_POINT_TWO).setFamily(CF).setQualifier(ZERO).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(TWO_POINT_TWO).setFamily(CF).setQualifier(ZERO_POINT_ZERO).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(TWO_POINT_TWO).setFamily(CF).setQualifier(FIVE).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(THREE).setFamily(CF).setQualifier(ONE).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(THREE).setFamily(CF).setQualifier(TWO).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(THREE).setFamily(CF).setQualifier(THREE).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(THREE).setFamily(CF).setQualifier(FOUR).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(FOUR).setFamily(CF).setQualifier(ONE).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(FOUR).setFamily(CF).setQualifier(TWO).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(FOUR).setFamily(CF).setQualifier(THREE).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(FOUR).setFamily(CF).setQualifier(FOUR).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(FOUR).setFamily(CF).setQualifier(FIVE).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(FIVE).setFamily(CF).setQualifier(ZERO).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build()};
    private static final int CELL_WITH_VERSIONS_BLOCK2_BOUNDARY = 4;
    private static final Cell[] CELL_WITH_VERSIONS = new Cell[]{ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(ONE).setFamily(CF).setQualifier(ONE).setTimestamp(2L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(ONE).setFamily(CF).setQualifier(ONE).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(ONE).setFamily(CF).setQualifier(TWO).setTimestamp(2L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(ONE).setFamily(CF).setQualifier(TWO).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(TWO).setFamily(CF).setQualifier(ONE).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build(), ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(TWO).setFamily(CF).setQualifier(TWO).setTimestamp(1L).setType(KeyValue.Type.Put.getCode()).setValue(VALUE).build()};
    private static final KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"a", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"b", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"c", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"d", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"e", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"f", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"g", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"h", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"i", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)"cf", (String)"a", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};

    @Test
    public void testWithColumnCountGetFilter() throws Exception {
        ArrayList results;
        Get get = new Get(ONE);
        get.readAllVersions();
        get.addFamily(CF);
        get.setFilter((Filter)new ColumnCountGetFilter(2));
        try (CellWithVersionsNoOptimizeStoreScanner scannerNoOptimize = new CellWithVersionsNoOptimizeStoreScanner(new Scan(get), this.scanInfo);){
            results = new ArrayList();
            while (scannerNoOptimize.next(results)) {
            }
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertTrue((boolean)CellUtil.matchingColumn((Cell)((Cell)results.get(0)), (Cell)CELL_WITH_VERSIONS[0]));
            Assert.assertTrue((boolean)CellUtil.matchingColumn((Cell)((Cell)results.get(1)), (Cell)CELL_WITH_VERSIONS[2]));
            Assert.assertTrue((String)"Optimize should do some optimizations", (scannerNoOptimize.optimization.get() == 0 ? 1 : 0) != 0);
        }
        get.setFilter((Filter)new ColumnCountGetFilter(2));
        var3_3 = null;
        try (CellWithVersionsStoreScanner scanner = new CellWithVersionsStoreScanner(new Scan(get), this.scanInfo);){
            results = new ArrayList();
            while (scanner.next(results)) {
            }
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertTrue((boolean)CellUtil.matchingColumn((Cell)((Cell)results.get(0)), (Cell)CELL_WITH_VERSIONS[0]));
            Assert.assertTrue((boolean)CellUtil.matchingColumn((Cell)((Cell)results.get(1)), (Cell)CELL_WITH_VERSIONS[2]));
            Assert.assertTrue((String)"Optimize should do some optimizations", (scanner.optimization.get() > 0 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    NavigableSet<byte[]> getCols(String ... strCols) {
        TreeSet<byte[]> cols = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (String col : strCols) {
            byte[] bytes = Bytes.toBytes((String)col);
            cols.add(bytes);
        }
        return cols;
    }

    @Test
    public void testFullRowGetDoesNotOverreadWhenRowInsideOneBlock() throws IOException {
        Get get = new Get(TWO);
        Scan scan = new Scan(get);
        try (CellGridStoreScanner scanner = new CellGridStoreScanner(scan, this.scanInfo);){
            ArrayList results = new ArrayList();
            while (scanner.next(results)) {
            }
            Assert.assertEquals((long)4L, (long)results.size());
            Assert.assertEquals((long)5L, (long)scanner.count.get());
            Assert.assertEquals((long)1L, (long)scanner.memstoreOnlyReads);
            Assert.assertEquals((long)0L, (long)scanner.optimization.get());
        }
    }

    @Test
    public void testFullRowSpansBlocks() throws IOException {
        Get get = new Get(FOUR);
        Scan scan = new Scan(get);
        try (CellGridStoreScanner scanner = new CellGridStoreScanner(scan, this.scanInfo);){
            ArrayList results = new ArrayList();
            while (scanner.next(results)) {
            }
            Assert.assertEquals((long)5L, (long)results.size());
            Assert.assertEquals((long)6L, (long)scanner.count.get());
            Assert.assertEquals((long)0L, (long)scanner.optimization.get());
        }
    }

    @Test
    public void testOptimize() throws IOException {
        Scan scan = new Scan();
        scan.addColumn(CF, ONE);
        try (CellGridStoreScanner scanner = new CellGridStoreScanner(scan, this.scanInfo);){
            ArrayList results = new ArrayList();
            while (scanner.next(results)) {
            }
            Assert.assertEquals((long)4L, (long)results.size());
            for (Cell cell : results) {
                Assert.assertTrue((boolean)Bytes.equals((byte[])ONE, (int)0, (int)ONE.length, (byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
            }
            Assert.assertTrue((String)"Optimize should do some optimizations", (scanner.optimization.get() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOptimizeAndGet() throws IOException {
        Get get = new Get(TWO);
        get.addColumn(CF, TWO);
        get.addColumn(CF, THREE);
        Scan scan = new Scan(get);
        try (CellGridStoreScanner scanner = new CellGridStoreScanner(scan, this.scanInfo);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)false, (Object)scanner.next(results));
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((String)"First qcode is SEEK_NEXT_COL and second INCLUDE_AND_SEEK_NEXT_ROW", (long)3L, (long)scanner.count.get());
            Assert.assertEquals((String)"Memstore Read count should be", (long)1L, (long)scanner.memstoreOnlyReads);
        }
    }

    @Test
    public void testOptimizeAndGetWithFakedNextBlockIndexStart() throws IOException {
        Get get = new Get(THREE);
        get.addColumn(CF, TWO);
        Scan scan = new Scan(get);
        try (CellGridStoreScanner scanner = new CellGridStoreScanner(scan, this.scanInfo);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)false, (Object)scanner.next(results));
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((String)"First qcode is SEEK_NEXT_COL and second INCLUDE_AND_SEEK_NEXT_ROW", (long)2L, (long)scanner.count.get());
        }
    }

    @Test
    public void testScanTimeRange() throws IOException {
        String r1 = "R1";
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)3L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)4L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)5L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = Arrays.asList(new KeyValueScanner[]{new KeyValueScanFixture(CellComparator.getInstance(), (Cell[])kvs)});
        Scan scanSpec = new Scan().withStartRow(Bytes.toBytes((String)r1));
        scanSpec.setTimeRange(0L, 6L);
        scanSpec.readAllVersions();
        ArrayList results = null;
        try (StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.getCols("a"), scanners);){
            results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)5L, (long)results.size());
            Assert.assertEquals((Object)kvs[kvs.length - 1], results.get(0));
        }
        scanSpec = new Scan().withStartRow(Bytes.toBytes((String)r1));
        scanSpec.setTimeRange(1L, 3L);
        scanSpec.readAllVersions();
        scan = new StoreScanner(scanSpec, this.scanInfo, this.getCols("a"), scanners);
        var7_7 = null;
        try {
            results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)2L, (long)results.size());
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (scan != null) {
                if (var7_7 != null) {
                    try {
                        scan.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    scan.close();
                }
            }
        }
        scanSpec = new Scan().withStartRow(Bytes.toBytes((String)r1));
        scanSpec.setTimeRange(5L, 10L);
        scanSpec.readAllVersions();
        scan = new StoreScanner(scanSpec, this.scanInfo, this.getCols("a"), scanners);
        var7_7 = null;
        try {
            results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)1L, (long)results.size());
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (scan != null) {
                if (var7_7 != null) {
                    try {
                        scan.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    scan.close();
                }
            }
        }
        scanSpec = new Scan().withStartRow(Bytes.toBytes((String)r1));
        scanSpec.setTimeRange(0L, 10L);
        scanSpec.readVersions(3);
        scan = new StoreScanner(scanSpec, this.scanInfo, this.getCols("a"), scanners);
        var7_7 = null;
        try {
            results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)3L, (long)results.size());
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (scan != null) {
                if (var7_7 != null) {
                    try {
                        scan.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    scan.close();
                }
            }
        }
    }

    @Test
    public void testScanSameTimestamp() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = Arrays.asList(new KeyValueScanner[]{new KeyValueScanFixture(CellComparator.getInstance(), (Cell[])kvs)});
        Scan scanSpec = new Scan().withStartRow(Bytes.toBytes((String)"R1"));
        try (StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, null, scanners);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)1L, (long)scan.memstoreOnlyReads);
            Assert.assertEquals((Object)kvs[0], results.get(0));
        }
    }

    @Test
    public void testNonUserScan() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = Arrays.asList(new KeyValueScanner[]{new KeyValueScanFixture(CellComparator.getInstance(), (Cell[])kvs)});
        Scan scanSpec = new Scan().withStartRow(Bytes.toBytes((String)"R1"));
        try (StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, null, scanners, ScanType.COMPACT_RETAIN_DELETES);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)0L, (long)scan.memstoreOnlyReads);
            Assert.assertEquals((Object)kvs[0], results.get(0));
        }
    }

    @Test
    public void testWontNextToNext() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan().withStartRow(Bytes.toBytes((String)"R1"));
        try (StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.getCols("a"), scanners);){
            ArrayList results = new ArrayList();
            scan.next(results);
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)kvs[0], results.get(0));
            results.clear();
            scan.next(results);
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)kvs[2], results.get(0));
            results.clear();
            scan.next(results);
            Assert.assertEquals((long)0L, (long)results.size());
        }
    }

    @Test
    public void testDeleteVersionSameTimestamp() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan().withStartRow(Bytes.toBytes((String)"R1"));
        try (StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.getCols("a"), scanners);){
            ArrayList results = new ArrayList();
            Assert.assertFalse((boolean)scan.next(results));
            Assert.assertEquals((long)0L, (long)results.size());
        }
    }

    @Test
    public void testDeletedRowThenGoodRow() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"a", (long)20L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan().withStartRow(Bytes.toBytes((String)"R1"));
        try (StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.getCols("a"), scanners);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)0L, (long)results.size());
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)kvs[2], results.get(0));
            Assert.assertEquals((Object)false, (Object)scan.next(results));
        }
    }

    @Test
    public void testDeleteVersionMaskingMultiplePuts() throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        KeyValue[] kvs1 = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care")};
        KeyValue[] kvs2 = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 500L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 100L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(kvs1, kvs2);
        try (StoreScanner scan = new StoreScanner(new Scan().withStartRow(Bytes.toBytes((String)"R1")), this.scanInfo, this.getCols("a"), scanners);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)kvs2[1], results.get(0));
        }
    }

    @Test
    public void testDeleteVersionsMixedAndMultipleVersionReturn() throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        KeyValue[] kvs1 = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care")};
        KeyValue[] kvs2 = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 500L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now + 500L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"z", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(kvs1, kvs2);
        Scan scanSpec = new Scan().withStartRow(Bytes.toBytes((String)"R1")).readVersions(2);
        try (StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.getCols("a"), scanners);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((Object)kvs2[1], results.get(0));
            Assert.assertEquals((Object)kvs2[0], results.get(1));
        }
    }

    @Test
    public void testWildCardOneVersionScan() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        try (StoreScanner scan = new StoreScanner(new Scan().withStartRow(Bytes.toBytes((String)"R1")), this.scanInfo, null, scanners);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((Object)kvs[0], results.get(0));
            Assert.assertEquals((Object)kvs[1], results.get(1));
        }
    }

    @Test
    public void testWildCardScannerUnderDeletes() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)10L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)10L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)9L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)10L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)9L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)8L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        try (StoreScanner scan = new StoreScanner(new Scan().readVersions(2), this.scanInfo, null, scanners);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)5L, (long)results.size());
            Assert.assertEquals((Object)kvs[0], results.get(0));
            Assert.assertEquals((Object)kvs[2], results.get(1));
            Assert.assertEquals((Object)kvs[3], results.get(2));
            Assert.assertEquals((Object)kvs[6], results.get(3));
            Assert.assertEquals((Object)kvs[7], results.get(4));
        }
    }

    @Test
    public void testDeleteFamily() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)100L, (KeyValue.Type)KeyValue.Type.DeleteFamily, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"e", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"e", (long)11L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"f", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"g", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"g", (long)11L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"h", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"i", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"a", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        try (StoreScanner scan = new StoreScanner(new Scan().readAllVersions(), this.scanInfo, null, scanners);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)0L, (long)results.size());
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)kvs[kvs.length - 1], results.get(0));
            Assert.assertEquals((Object)false, (Object)scan.next(results));
        }
    }

    @Test
    public void testDeleteColumn() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)10L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)9L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)8L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)5L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        try (StoreScanner scan = new StoreScanner(new Scan(), this.scanInfo, null, scanners);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)kvs[3], results.get(0));
        }
    }

    @Test
    public void testSkipColumn() throws IOException {
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        try (StoreScanner scan = new StoreScanner(new Scan(), this.scanInfo, this.getCols("a", "d"), scanners);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((Object)kvs[0], results.get(0));
            Assert.assertEquals((Object)kvs[3], results.get(1));
            results.clear();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)kvs[kvs.length - 1], results.get(0));
            results.clear();
            Assert.assertEquals((Object)false, (Object)scan.next(results));
        }
    }

    @Test
    public void testWildCardTtlScan() throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 1000L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)(now - 10L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)(now - 200L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)(now - 10000L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"b", (long)(now - 10L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"c", (long)(now - 200L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"c", (long)(now - 1000L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scan = new Scan();
        scan.readVersions(1);
        ScanInfo scanInfo = new ScanInfo(CONF, CF, 0, 1, 500L, KeepDeletedCells.FALSE, 65536L, 0L, CellComparator.getInstance(), false);
        try (StoreScanner scanner = new StoreScanner(scan, scanInfo, null, scanners);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scanner.next(results));
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((Object)kvs[1], results.get(0));
            Assert.assertEquals((Object)kvs[2], results.get(1));
            results.clear();
            Assert.assertEquals((Object)true, (Object)scanner.next(results));
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertEquals((Object)kvs[4], results.get(0));
            Assert.assertEquals((Object)kvs[5], results.get(1));
            Assert.assertEquals((Object)kvs[6], results.get(2));
            results.clear();
            Assert.assertEquals((Object)false, (Object)scanner.next(results));
        }
    }

    @Test
    public void testScannerReseekDoesntNPE() throws Exception {
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        try (StoreScanner scan = new StoreScanner(new Scan(), this.scanInfo, this.getCols("a", "d"), scanners);){
            scan.updateReaders(Collections.emptyList(), Collections.emptyList());
            scan.updateReaders(Collections.emptyList(), Collections.emptyList());
            scan.peek();
        }
    }

    @Test
    @Ignore(value="this fails, since we don't handle deletions, etc, in peek")
    public void testPeek() throws Exception {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan().withStartRow(Bytes.toBytes((String)"R1"));
        try (StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.getCols("a"), scanners);){
            Assert.assertNull((Object)scan.peek());
        }
    }

    @Test
    public void testExpiredDeleteFamily() throws Exception {
        long now = EnvironmentEdgeManager.currentTime();
        KeyValue[] kvs = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"R1"), Bytes.toBytes((String)CF_STR), null, now - 1000L, KeyValue.Type.DeleteFamily), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 10L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scan = new Scan();
        scan.readVersions(1);
        ScanInfo scanInfo = new ScanInfo(CONF, CF, 0, 1, 500L, KeepDeletedCells.FALSE, 65536L, 0L, CellComparator.getInstance(), false);
        try (StoreScanner scanner = new StoreScanner(scan, scanInfo, null, scanners);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scanner.next(results));
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)kvs[1], results.get(0));
            results.clear();
            Assert.assertEquals((Object)false, (Object)scanner.next(results));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteMarkerLongevity() throws Exception {
        try {
            final long now = EnvironmentEdgeManager.currentTime();
            EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new EnvironmentEdge(){

                public long currentTime() {
                    return now;
                }
            });
            KeyValue[] kvs = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"R1"), Bytes.toBytes((String)CF_STR), null, now - 100L, KeyValue.Type.DeleteFamily), new KeyValue(Bytes.toBytes((String)"R1"), Bytes.toBytes((String)CF_STR), null, now - 1000L, KeyValue.Type.DeleteFamily), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 50L), (KeyValue.Type)KeyValue.Type.Put, (String)"v3"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 55L), (KeyValue.Type)KeyValue.Type.Delete, (String)"dontcare"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 55L), (KeyValue.Type)KeyValue.Type.Put, (String)"deleted-version v2"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 60L), (KeyValue.Type)KeyValue.Type.Put, (String)"v1"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 65L), (KeyValue.Type)KeyValue.Type.Put, (String)"v0"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 100L), (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)(now - 600L), (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)(now - 70L), (KeyValue.Type)KeyValue.Type.Put, (String)"v2"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)(now - 750L), (KeyValue.Type)KeyValue.Type.Put, (String)"v1"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)(now - 500L), (KeyValue.Type)KeyValue.Type.Delete, (String)"dontcare"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)(now - 600L), (KeyValue.Type)KeyValue.Type.Put, (String)"v1"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)(now - 1000L), (KeyValue.Type)KeyValue.Type.Delete, (String)"dontcare"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)(now - 60L), (KeyValue.Type)KeyValue.Type.Put, (String)"expired put"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)(now - 100L), (KeyValue.Type)KeyValue.Type.Delete, (String)"not-expired delete")};
            List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
            ScanInfo scanInfo = new ScanInfo(CONF, Bytes.toBytes((String)CF_STR), 0, 2, 500L, KeepDeletedCells.FALSE, 65536L, 200L, CellComparator.getInstance(), false);
            try (StoreScanner scanner = new StoreScanner(scanInfo, 2, ScanType.COMPACT_DROP_DELETES, scanners);){
                ArrayList results = new ArrayList();
                results = new ArrayList();
                Assert.assertEquals((Object)true, (Object)scanner.next(results));
                Assert.assertEquals((Object)kvs[0], results.get(0));
                Assert.assertEquals((Object)kvs[2], results.get(1));
                Assert.assertEquals((Object)kvs[3], results.get(2));
                Assert.assertEquals((Object)kvs[5], results.get(3));
                Assert.assertEquals((Object)kvs[9], results.get(4));
                Assert.assertEquals((Object)kvs[14], results.get(5));
                Assert.assertEquals((Object)kvs[15], results.get(6));
                Assert.assertEquals((long)7L, (long)results.size());
            }
        }
        finally {
            EnvironmentEdgeManagerTestHelper.reset();
        }
    }

    @Test
    public void testPreadNotEnabledForCompactionStoreScanners() throws Exception {
        long now = EnvironmentEdgeManager.currentTime();
        KeyValue[] kvs = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"R1"), Bytes.toBytes((String)CF_STR), null, now - 1000L, KeyValue.Type.DeleteFamily), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 10L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        ScanInfo scanInfo = new ScanInfo(CONF, CF, 0, 1, 500L, KeepDeletedCells.FALSE, 65536L, 0L, CellComparator.getInstance(), false);
        try (StoreScanner storeScanner = new StoreScanner(scanInfo, -1, ScanType.COMPACT_RETAIN_DELETES, scanners);){
            Assert.assertFalse((boolean)storeScanner.isScanUsePread());
        }
    }

    @Test
    public void testReadVersionWithRawAndFilter() throws IOException {
        ScanInfo scanInfo = new ScanInfo(CONF, CF, 0, 1, Long.MAX_VALUE, KeepDeletedCells.FALSE, 65536L, 0L, CellComparator.getInstance(), false);
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)3L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = Arrays.asList(new KeyValueScanner[]{new KeyValueScanFixture(CellComparator.getInstance(), (Cell[])kvs)});
        BinaryComparator comp = new BinaryComparator(Bytes.toBytes((String)"a"));
        QualifierFilter filter = new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)comp);
        Scan scanSpec = new Scan().withStartRow(Bytes.toBytes((String)"R1")).readVersions(2).setRaw(true);
        scanSpec.setFilter((Filter)filter);
        try (StoreScanner scan = new StoreScanner(scanSpec, scanInfo, null, scanners);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)true, (Object)scan.next(results));
            Assert.assertEquals((long)2L, (long)results.size());
        }
    }

    @Test
    public void testScannersClosedWhenCheckingOnlyMemStore() throws IOException {
        ScanInfo scanInfo = new ScanInfo(CONF, CF, 0, 1, Long.MAX_VALUE, KeepDeletedCells.FALSE, 65536L, 0L, CellComparator.getInstance(), false);
        InternalScan scan = new InternalScan(new Scan());
        scan.checkOnlyMemStore();
        class MyCollectionBackedScanner
        extends CollectionBackedScanner {
            final boolean fileScanner;
            boolean closed;

            MyCollectionBackedScanner(boolean fileScanner) {
                super(Collections.emptySortedSet());
                this.fileScanner = fileScanner;
            }

            public boolean isFileScanner() {
                return this.fileScanner;
            }

            public void close() {
                super.close();
                this.closed = true;
            }
        }
        MyCollectionBackedScanner fileScanner = new MyCollectionBackedScanner(true);
        MyCollectionBackedScanner memStoreScanner = new MyCollectionBackedScanner(false);
        List<MyCollectionBackedScanner> allScanners = Arrays.asList(fileScanner, memStoreScanner);
        try (StoreScanner scanner = new StoreScanner((Scan)scan, scanInfo, null, allScanners);){
            List remaining = scanner.selectScannersFrom(null, allScanners);
            Assert.assertEquals((long)1L, (long)remaining.size());
            Assert.assertSame((Object)((Object)memStoreScanner), remaining.get(0));
            Assert.assertTrue((boolean)fileScanner.closed);
            Assert.assertFalse((boolean)memStoreScanner.closed);
        }
    }

    private static class CellWithVersionsNoOptimizeStoreScanner
    extends StoreScanner {
        final AtomicInteger optimization = new AtomicInteger(0);

        CellWithVersionsNoOptimizeStoreScanner(Scan scan, ScanInfo scanInfo) throws IOException {
            super(scan, scanInfo, (NavigableSet)scan.getFamilyMap().get(CF), Arrays.asList(new KeyValueScanner[]{new KeyValueScanFixture(CellComparator.getInstance(), CELL_WITH_VERSIONS)}));
        }

        protected boolean trySkipToNextColumn(Cell cell) throws IOException {
            boolean optimized = super.trySkipToNextColumn(cell);
            LOG.info("Cell=" + cell + ", nextIndex=" + CellUtil.toString((Cell)this.getNextIndexedKey(), (boolean)false) + ", optimized=" + optimized);
            if (optimized) {
                this.optimization.incrementAndGet();
            }
            return optimized;
        }

        public Cell getNextIndexedKey() {
            return null;
        }
    }

    private static class CellWithVersionsStoreScanner
    extends StoreScanner {
        final AtomicInteger optimization = new AtomicInteger(0);

        CellWithVersionsStoreScanner(Scan scan, ScanInfo scanInfo) throws IOException {
            super(scan, scanInfo, (NavigableSet)scan.getFamilyMap().get(CF), Arrays.asList(new KeyValueScanner[]{new KeyValueScanFixture(CellComparator.getInstance(), CELL_WITH_VERSIONS)}));
        }

        protected boolean trySkipToNextColumn(Cell cell) throws IOException {
            boolean optimized = super.trySkipToNextColumn(cell);
            LOG.info("Cell=" + cell + ", nextIndex=" + CellUtil.toString((Cell)this.getNextIndexedKey(), (boolean)false) + ", optimized=" + optimized);
            if (optimized) {
                this.optimization.incrementAndGet();
            }
            return optimized;
        }

        public Cell getNextIndexedKey() {
            return PrivateCellUtil.createFirstOnRow((Cell)CELL_WITH_VERSIONS[4]);
        }
    }

    private static class CellGridStoreScanner
    extends StoreScanner {
        AtomicInteger count;
        final AtomicInteger optimization = new AtomicInteger(0);

        CellGridStoreScanner(Scan scan, ScanInfo scanInfo) throws IOException {
            super(scan, scanInfo, (NavigableSet)scan.getFamilyMap().get(CF), Arrays.asList(new KeyValueScanner[]{new KeyValueScanFixture(CellComparator.getInstance(), CELL_GRID)}));
        }

        protected void resetKVHeap(List<? extends KeyValueScanner> scanners, CellComparator comparator) throws IOException {
            if (this.count == null) {
                this.count = new AtomicInteger(0);
            }
            this.heap = this.newKVHeap(scanners, comparator);
        }

        protected KeyValueHeap newKVHeap(List<? extends KeyValueScanner> scanners, CellComparator comparator) throws IOException {
            return new KeyValueHeapWithCount(scanners, comparator, this.count);
        }

        protected boolean trySkipToNextRow(Cell cell) throws IOException {
            boolean optimized = super.trySkipToNextRow(cell);
            LOG.info("Cell=" + cell + ", nextIndex=" + CellUtil.toString((Cell)this.getNextIndexedKey(), (boolean)false) + ", optimized=" + optimized);
            if (optimized) {
                this.optimization.incrementAndGet();
            }
            return optimized;
        }

        protected boolean trySkipToNextColumn(Cell cell) throws IOException {
            boolean optimized = super.trySkipToNextColumn(cell);
            LOG.info("Cell=" + cell + ", nextIndex=" + CellUtil.toString((Cell)this.getNextIndexedKey(), (boolean)false) + ", optimized=" + optimized);
            if (optimized) {
                this.optimization.incrementAndGet();
            }
            return optimized;
        }

        public Cell getNextIndexedKey() {
            return this.count.get() > 15 ? PrivateCellUtil.createFirstOnRow((Cell)CELL_GRID[19]) : (this.count.get() > 11 ? PrivateCellUtil.createFirstOnRow((Cell)CELL_GRID[15]) : (this.count.get() > 4 ? PrivateCellUtil.createFirstOnRow((Cell)CELL_GRID[11]) : PrivateCellUtil.createFirstOnRow((Cell)CELL_GRID[4])));
        }
    }

    private static class KeyValueHeapWithCount
    extends KeyValueHeap {
        final AtomicInteger count;

        public KeyValueHeapWithCount(List<? extends KeyValueScanner> scanners, CellComparator comparator, AtomicInteger count) throws IOException {
            super(scanners, comparator);
            this.count = count;
        }

        public Cell peek() {
            this.count.incrementAndGet();
            return super.peek();
        }
    }
}

