/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestStoreFileInfo {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStoreFileInfo.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();

    @Test
    public void testStoreFileNames() {
        String[] illegalHFileLink;
        String[] legalHFileLink;
        for (String name : legalHFileLink = new String[]{"MyTable_02=abc012-def345", "MyTable_02.300=abc012-def345", "MyTable_02-400=abc012-def345", "MyTable_02-400.200=abc012-def345", "MyTable_02=abc012-def345_SeqId_1_", "MyTable_02=abc012-def345_SeqId_20_"}) {
            TestCase.assertTrue((String)("should be a valid link: " + name), (boolean)HFileLink.isHFileLink((String)name));
            TestCase.assertTrue((String)("should be a valid StoreFile" + name), (boolean)StoreFileInfo.validateStoreFileName((String)name));
            Assert.assertFalse((String)("should not be a valid reference: " + name), (boolean)StoreFileInfo.isReference((String)name));
            String refName = name + ".6789";
            TestCase.assertTrue((String)("should be a valid link reference: " + refName), (boolean)StoreFileInfo.isReference((String)refName));
            TestCase.assertTrue((String)("should be a valid StoreFile" + refName), (boolean)StoreFileInfo.validateStoreFileName((String)refName));
        }
        for (String name : illegalHFileLink = new String[]{".MyTable_02=abc012-def345", "-MyTable_02.300=abc012-def345", "MyTable_02-400=abc0_12-def345", "MyTable_02-400.200=abc012-def345...."}) {
            Assert.assertFalse((String)("should not be a valid link: " + name), (boolean)HFileLink.isHFileLink((String)name));
        }
    }

    @Test
    public void testEqualsWithLink() throws IOException {
        Path origin = new Path("/origin");
        Path tmp = TEST_UTIL.getDataTestDir();
        Path mob = new Path("/mob");
        Path archive = new Path("/archive");
        HFileLink link1 = new HFileLink(new Path(origin, "f1"), new Path(tmp, "f1"), new Path(mob, "f1"), new Path(archive, "f1"));
        HFileLink link2 = new HFileLink(new Path(origin, "f1"), new Path(tmp, "f1"), new Path(mob, "f1"), new Path(archive, "f1"));
        StoreFileInfo info1 = new StoreFileInfo(TEST_UTIL.getConfiguration(), TEST_UTIL.getTestFileSystem(), null, link1);
        StoreFileInfo info2 = new StoreFileInfo(TEST_UTIL.getConfiguration(), TEST_UTIL.getTestFileSystem(), null, link2);
        Assert.assertEquals((Object)info1, (Object)info2);
        Assert.assertEquals((long)info1.hashCode(), (long)info2.hashCode());
    }

    @Test
    public void testOpenErrorMessageHFileLink() throws IOException, IllegalStateException {
        Path p = new Path("/hbase/test/0123/cf/testtb=4567-abcd");
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Throwable throwable = null;
        try {
            StoreFileInfo sfi = new StoreFileInfo(TEST_UTIL.getConfiguration(), fs, p, true);
            try {
                ReaderContext context = sfi.createReaderContext(false, 1000L, ReaderContext.ReaderType.PREAD);
                sfi.createReader(context, null);
                throw new IllegalStateException();
            }
            catch (FileNotFoundException fnfe) {
                TestCase.assertTrue((boolean)fnfe.getMessage().contains(HFileLink.class.getSimpleName()));
                if (fs != null) {
                    if (throwable != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        fs.close();
                    }
                }
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (fs != null) {
                    if (throwable != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        fs.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    @Test
    public void testOpenErrorMessageReference() throws IOException {
        Path p = new Path(TEST_UTIL.getDataTestDirOnTestFS(), "4567.abcd");
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        fs.mkdirs(p.getParent());
        Reference r = Reference.createBottomReference((byte[])HConstants.EMPTY_START_ROW);
        r.write(fs, p);
        StoreFileInfo sfi = new StoreFileInfo(TEST_UTIL.getConfiguration(), fs, p, true);
        try {
            ReaderContext context = sfi.createReaderContext(false, 1000L, ReaderContext.ReaderType.PREAD);
            sfi.createReader(context, null);
            throw new IllegalStateException();
        }
        catch (FileNotFoundException fnfe) {
            TestCase.assertTrue((boolean)fnfe.getMessage().contains("->"));
            return;
        }
    }
}

