/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PluggableBlockingQueue;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.TestPluggableQueueImpl;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerAbortedException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionServerRejectDuringAbort {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerRejectDuringAbort.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionServerRejectDuringAbort.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static TableName TABLE_NAME = TableName.valueOf((String)"RSRejectOnAbort");
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static final int REGIONS_NUM = 5;
    private static final AtomicReference<Exception> THROWN_EXCEPTION = new AtomicReference<Object>(null);
    private static volatile boolean shouldThrowTooBig = false;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().set("hbase.ipc.server.callqueue.type", "pluggable");
        UTIL.getConfiguration().setClass("hbase.ipc.server.callqueue.pluggable.queue.class.name", CallQueueTooBigThrowingQueue.class, PluggableBlockingQueue.class);
        StartTestingClusterOption option = StartTestingClusterOption.builder().numRegionServers(2).build();
        UTIL.startMiniCluster(option);
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setCoprocessor(SleepWhenCloseCoprocessor.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF).build()).build();
        UTIL.getAdmin().createTable(td, Bytes.toBytes((String)"0"), Bytes.toBytes((String)"9"), 5);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRejectRequestsOnAbort() throws Exception {
        HRegionServer serverWithoutMeta = null;
        for (JVMClusterUtil.RegionServerThread regionServerThread : UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            HRegionServer regionServer = regionServerThread.getRegionServer();
            if (!regionServer.getRegions(TableName.META_TABLE_NAME).isEmpty() || regionServer.getRegions(TABLE_NAME).isEmpty()) continue;
            serverWithoutMeta = regionServer;
            break;
        }
        Assert.assertNotNull((String)"couldn't find a server without meta, but with test table regions", serverWithoutMeta);
        Thread writer = new Thread(this.getWriterThreadRunnable(serverWithoutMeta.getServerName()));
        writer.setDaemon(true);
        writer.start();
        serverWithoutMeta.abort("Abort RS for test");
        UTIL.waitFor(60000L, () -> THROWN_EXCEPTION.get() != null);
        Assert.assertEquals(THROWN_EXCEPTION.get().getCause().getClass(), RegionServerAbortedException.class);
    }

    private Runnable getWriterThreadRunnable(ServerName loadServer) {
        return () -> this.lambda$getWriterThreadRunnable$1(loadServer);
    }

    private void submitRequestsToRegion(Table table, RegionInfo regionInfo) throws IOException {
        byte[] rowKey = this.getRowKeyWithin(regionInfo);
        int i = 0;
        while (true) {
            try {
                table.put(new Put(rowKey).addColumn(CF, Bytes.toBytes((int)(++i)), Bytes.toBytes((int)i)));
            }
            catch (IOException e) {
                if (!shouldThrowTooBig && e instanceof RetriesExhaustedException && e.getCause() instanceof RegionServerAbortedException) {
                    shouldThrowTooBig = true;
                }
                throw e;
            }
            Threads.sleep((long)10L);
        }
    }

    private byte[] getRowKeyWithin(RegionInfo regionInfo) {
        if (regionInfo.getStartKey().length == 0) {
            if (regionInfo.getEndKey().length == 0) {
                return Bytes.toBytes((int)1);
            }
            byte[] rowKey = Bytes.copy((byte[])regionInfo.getEndKey());
            int n = rowKey.length - 1;
            rowKey[n] = (byte)(rowKey[n] - 1);
            return rowKey;
        }
        return regionInfo.getStartKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void lambda$getWriterThreadRunnable$1(ServerName loadServer) {
        try {
            conf = TestRegionServerRejectDuringAbort.UTIL.getConfiguration();
            conf.setInt("hbase.client.retries.number", 5);
            conn = ConnectionFactory.createConnection((Configuration)conf);
            var4_6 = null;
            try {
                table = conn.getTableBuilder(TestRegionServerRejectDuringAbort.TABLE_NAME, null).setRequestAttribute("test", new byte[]{0}).build();
                var6_9 = null;
                var7_10 = table.getRegionLocator().getAllRegionLocations().iterator();
lbl11:
                // 2 sources

                while (true) {
                    if (var7_10.hasNext() == false) throw new RuntimeException("Failed to find any regions for loadServer " + loadServer);
                    regionLocation = (HRegionLocation)var7_10.next();
                    if (!regionLocation.getServerName().equals((Object)loadServer)) ** GOTO lbl42
                    this.submitRequestsToRegion(table, regionLocation.getRegion());
                    if (table == null) return;
                    if (var6_9 != null) {
                    }
                    ** GOTO lbl40
                    break;
                }
                {
                    catch (Throwable var7_11) {
                        var6_9 = var7_11;
                        throw var7_11;
                    }
                    catch (Throwable var10_15) {
                        if (table == null) throw var10_15;
                        if (var6_9 == null) {
                            table.close();
                            throw var10_15;
                        }
                        try {
                            table.close();
                            throw var10_15;
                        }
                        catch (Throwable var11_16) {
                            var6_9.addSuppressed(var11_16);
                            throw var10_15;
                        }
                    }
                    try {
                        table.close();
                        return;
                    }
                    catch (Throwable var9_13) {
                        var6_9.addSuppressed(var9_13);
                        return;
                    }
lbl40:
                    // 1 sources

                    table.close();
                    return;
lbl42:
                    // 1 sources

                    ** try [egrp 6[TRYBLOCK] [8 : 196->279)] { 
lbl-1000:
                    // 1 sources

                    {
                        ** continue;
                    }
                }
            }
lbl44:
            // 2 sources

            catch (Throwable var5_8) {
                var4_6 = var5_8;
                throw var5_8;
            }
            finally {
                if (conn != null) {
                    if (var4_6 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable var9_14) {
                            var4_6.addSuppressed(var9_14);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        catch (Exception e) {
            TestRegionServerRejectDuringAbort.LOG.warn("Failed to load data", (Throwable)e);
            var3_5 = TestRegionServerRejectDuringAbort.THROWN_EXCEPTION;
            synchronized (var3_5) {
                TestRegionServerRejectDuringAbort.THROWN_EXCEPTION.set(e);
                TestRegionServerRejectDuringAbort.THROWN_EXCEPTION.notifyAll();
                return;
            }
        }
    }

    public static class SleepWhenCloseCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) throws IOException {
            UTIL.waitFor(60000L, () -> THROWN_EXCEPTION.get() != null);
        }
    }

    public static final class CallQueueTooBigThrowingQueue
    extends TestPluggableQueueImpl {
        public CallQueueTooBigThrowingQueue(int maxQueueLength, PriorityFunction priority, Configuration conf) {
            super(maxQueueLength, priority, conf);
        }

        @Override
        public boolean offer(CallRunner callRunner) {
            if (shouldThrowTooBig && callRunner.getRpcCall().getRequestAttribute("test") != null) {
                return false;
            }
            return super.offer(callRunner);
        }
    }
}

