/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.io.FileLink;
import org.apache.hadoop.hbase.regionserver.InputStreamBlockDistribution;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestInputStreamBlockDistribution {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestInputStreamBlockDistribution.class);
    private Configuration conf;
    private FileSystem fs;
    private Path testPath;

    @Before
    public void setUp() throws Exception {
        HBaseTestingUtil testUtil = new HBaseTestingUtil();
        this.conf = testUtil.getConfiguration();
        this.conf.setInt("dfs.blocksize", 0x100000);
        this.conf.setInt("dfs.client.read.prefetch.size", 0x200000);
        testUtil.startMiniDFSCluster(1);
        MiniDFSCluster cluster = testUtil.getDFSCluster();
        this.fs = cluster.getFileSystem();
        this.testPath = new Path(testUtil.getDefaultRootDirPath(), "test.file");
        this.writeSomeData(this.fs, this.testPath, 0x10000000L, (byte)2);
    }

    @After
    public void tearDown() throws Exception {
        this.fs.delete(this.testPath, false);
        this.fs.close();
    }

    @Test
    public void itDerivesLocalityFromHFileInputStream() throws Exception {
        try (FSDataInputStream stream = this.fs.open(this.testPath);){
            HDFSBlocksDistribution initial = new HDFSBlocksDistribution();
            InputStreamBlockDistribution test = new InputStreamBlockDistribution(stream, this.getMockedStoreFileInfo(initial, false));
            Assert.assertSame((Object)initial, (Object)test.getHDFSBlockDistribution());
            test.setLastCachedAt(test.getCachePeriodMs() + 1L);
            Assert.assertNotSame((Object)initial, (Object)test.getHDFSBlockDistribution());
        }
    }

    @Test
    public void itDerivesLocalityFromFileLinkInputStream() throws Exception {
        ArrayList<Path> files = new ArrayList<Path>();
        files.add(this.testPath);
        FileLink link = new FileLink(files);
        try (FSDataInputStream stream = link.open(this.fs);){
            HDFSBlocksDistribution initial = new HDFSBlocksDistribution();
            InputStreamBlockDistribution test = new InputStreamBlockDistribution(stream, this.getMockedStoreFileInfo(initial, true));
            Assert.assertSame((Object)initial, (Object)test.getHDFSBlockDistribution());
            test.setLastCachedAt(test.getCachePeriodMs() + 1L);
            Assert.assertNotSame((Object)initial, (Object)test.getHDFSBlockDistribution());
        }
    }

    @Test
    public void itFallsBackOnLastKnownValueWhenUnsupported() {
        FSDataInputStream fakeStream = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        HDFSBlocksDistribution initial = new HDFSBlocksDistribution();
        InputStreamBlockDistribution test = new InputStreamBlockDistribution(fakeStream, this.getMockedStoreFileInfo(initial, false));
        Assert.assertSame((Object)initial, (Object)test.getHDFSBlockDistribution());
        test.setLastCachedAt(test.getCachePeriodMs() + 1L);
        Assert.assertSame((Object)initial, (Object)test.getHDFSBlockDistribution());
        Assert.assertTrue((boolean)test.isStreamUnsupported());
    }

    @Test
    public void itFallsBackOnLastKnownValueOnException() throws IOException {
        HdfsDataInputStream fakeStream = (HdfsDataInputStream)Mockito.mock(HdfsDataInputStream.class);
        Mockito.when((Object)fakeStream.getAllBlocks()).thenThrow(new Throwable[]{new IOException("test")});
        HDFSBlocksDistribution initial = new HDFSBlocksDistribution();
        InputStreamBlockDistribution test = new InputStreamBlockDistribution((FSDataInputStream)fakeStream, this.getMockedStoreFileInfo(initial, false));
        Assert.assertSame((Object)initial, (Object)test.getHDFSBlockDistribution());
        test.setLastCachedAt(test.getCachePeriodMs() + 1L);
        Assert.assertSame((Object)initial, (Object)test.getHDFSBlockDistribution());
        Assert.assertFalse((boolean)test.isStreamUnsupported());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSomeData(FileSystem fs, Path path, long size, byte v) throws IOException {
        byte[] data = new byte[4096];
        for (int i = 0; i < data.length; ++i) {
            data[i] = v;
        }
        try (FSDataOutputStream stream = fs.create(path);){
            for (long written = 0L; written < size; written += (long)data.length) {
                stream.write(data, 0, data.length);
            }
        }
    }

    private StoreFileInfo getMockedStoreFileInfo(HDFSBlocksDistribution distribution, boolean isFileLink) {
        StoreFileInfo mock = (StoreFileInfo)Mockito.mock(StoreFileInfo.class);
        Mockito.when((Object)mock.getHDFSBlockDistribution()).thenReturn((Object)distribution);
        Mockito.when((Object)mock.getConf()).thenReturn((Object)this.conf);
        Mockito.when((Object)mock.isLink()).thenReturn((Object)isFileLink);
        return mock;
    }
}

