/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.Service;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;

public class RegionAsTable
implements Table {
    private final Region region;

    public RegionAsTable(Region region) {
        this.region = region;
    }

    public TableName getName() {
        return this.region.getTableDescriptor().getTableName();
    }

    public Configuration getConfiguration() {
        throw new UnsupportedOperationException();
    }

    public TableDescriptor getDescriptor() throws IOException {
        return this.region.getTableDescriptor();
    }

    public boolean exists(Get get) throws IOException {
        if (!get.isCheckExistenceOnly()) {
            throw new IllegalArgumentException();
        }
        return this.get(get) != null;
    }

    public boolean[] exists(List<Get> gets) throws IOException {
        boolean[] results = new boolean[gets.size()];
        int index = 0;
        for (Get get : gets) {
            results[index++] = this.exists(get);
        }
        return results;
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public Result get(Get get) throws IOException {
        return this.region.get(get);
    }

    public Result[] get(List<Get> gets) throws IOException {
        Result[] results = new Result[gets.size()];
        int index = 0;
        for (Get get : gets) {
            results[index++] = this.get(get);
        }
        return results;
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        return new RegionScannerToResultScannerAdaptor(this.region.getScanner(scan));
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        return this.getScanner(new Scan().addFamily(family));
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        return this.getScanner(new Scan().addColumn(family, qualifier));
    }

    public void put(Put put) throws IOException {
        this.region.put(put);
    }

    public void put(List<Put> puts) throws IOException {
        for (Put put : puts) {
            this.put(put);
        }
    }

    public void delete(Delete delete) throws IOException {
        this.region.delete(delete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        for (Delete delete : deletes) {
            this.delete(delete);
        }
    }

    public Table.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        throw new UnsupportedOperationException();
    }

    public Table.CheckAndMutateWithFilterBuilder checkAndMutate(byte[] row, Filter filter) {
        throw new UnsupportedOperationException();
    }

    public Result mutateRow(RowMutations rm) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Result append(Append append) throws IOException {
        return this.region.append(append);
    }

    public Result increment(Increment increment) throws IOException {
        return this.region.increment(increment);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        throw new UnsupportedOperationException();
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        throw new UnsupportedOperationException();
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new UnsupportedOperationException();
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        throw new UnsupportedOperationException();
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new UnsupportedOperationException();
    }

    public long getReadRpcTimeout(TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public long getOperationTimeout(TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public long getWriteRpcTimeout(TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public long getRpcTimeout(TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public RegionLocator getRegionLocator() throws IOException {
        throw new UnsupportedOperationException();
    }

    static class RegionScannerToResultScannerAdaptor
    implements ResultScanner {
        private final RegionScanner scanner;
        private boolean moreRows = true;
        private final List<Cell> cells = new ArrayList<Cell>();

        RegionScannerToResultScannerAdaptor(RegionScanner scanner) {
            this.scanner = scanner;
        }

        public Result next() throws IOException {
            block2: {
                if (!this.moreRows) {
                    return null;
                }
                do {
                    this.moreRows = this.scanner.next(this.cells);
                    if (!this.cells.isEmpty()) break block2;
                } while (this.moreRows);
                return null;
            }
            Result result = Result.create(this.cells);
            this.cells.clear();
            return result;
        }

        public void close() {
            try {
                this.scanner.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean renewLease() {
            throw new UnsupportedOperationException();
        }

        public ScanMetrics getScanMetrics() {
            return null;
        }
    }
}

