/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MockHStoreFile
extends HStoreFile {
    long length = 0L;
    boolean isRef = false;
    long ageInDisk;
    long sequenceid;
    private Map<byte[], byte[]> metadata = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
    byte[] splitPoint = null;
    TimeRangeTracker timeRangeTracker;
    long entryCount;
    boolean isMajor;
    HDFSBlocksDistribution hdfsBlocksDistribution;
    long modificationTime;
    boolean compactedAway;

    MockHStoreFile(HBaseTestingUtil testUtil, Path testPath, long length, long ageInDisk, boolean isRef, long sequenceid) throws IOException {
        super(testUtil.getTestFileSystem(), testPath, testUtil.getConfiguration(), new CacheConfig(testUtil.getConfiguration()), BloomType.NONE, true);
        this.length = length;
        this.isRef = isRef;
        this.ageInDisk = ageInDisk;
        this.sequenceid = sequenceid;
        this.isMajor = false;
        this.hdfsBlocksDistribution = new HDFSBlocksDistribution();
        this.hdfsBlocksDistribution.addHostsAndBlockWeight(new String[]{DNS.getHostname((Configuration)testUtil.getConfiguration(), (DNS.ServerType)DNS.ServerType.REGIONSERVER)}, 1L);
        this.modificationTime = EnvironmentEdgeManager.currentTime();
    }

    void setLength(long newLen) {
        this.length = newLen;
    }

    public long getMaxSequenceId() {
        return this.sequenceid;
    }

    public boolean isMajorCompactionResult() {
        return this.isMajor;
    }

    public void setIsMajor(boolean isMajor) {
        this.isMajor = isMajor;
    }

    public boolean isReference() {
        return this.isRef;
    }

    public boolean isBulkLoadResult() {
        return false;
    }

    public byte[] getMetadataValue(byte[] key) {
        return this.metadata.get(key);
    }

    public void setMetadataValue(byte[] key, byte[] value) {
        this.metadata.put(key, value);
    }

    void setTimeRangeTracker(TimeRangeTracker timeRangeTracker) {
        this.timeRangeTracker = timeRangeTracker;
    }

    void setEntries(long entryCount) {
        this.entryCount = entryCount;
    }

    public OptionalLong getMinimumTimestamp() {
        return this.timeRangeTracker == null ? OptionalLong.empty() : OptionalLong.of(this.timeRangeTracker.getMin());
    }

    public OptionalLong getMaximumTimestamp() {
        return this.timeRangeTracker == null ? OptionalLong.empty() : OptionalLong.of(this.timeRangeTracker.getMax());
    }

    public void markCompactedAway() {
        this.compactedAway = true;
    }

    public boolean isCompactedAway() {
        return this.compactedAway;
    }

    public long getModificationTimestamp() {
        return this.modificationTime;
    }

    public HDFSBlocksDistribution getHDFSBlockDistribution() {
        return this.hdfsBlocksDistribution;
    }

    public void initReader() throws IOException {
    }

    public StoreFileScanner getPreadScanner(boolean cacheBlocks, long readPt, long scannerOrder, boolean canOptimizeForNonNullColumn) {
        return this.getReader().getStoreFileScanner(cacheBlocks, true, false, readPt, scannerOrder, canOptimizeForNonNullColumn);
    }

    public StoreFileScanner getStreamScanner(boolean canUseDropBehind, boolean cacheBlocks, boolean isCompaction, long readPt, long scannerOrder, boolean canOptimizeForNonNullColumn) throws IOException {
        return this.getReader().getStoreFileScanner(cacheBlocks, false, isCompaction, readPt, scannerOrder, canOptimizeForNonNullColumn);
    }

    public StoreFileReader getReader() {
        final long len = this.length;
        final TimeRangeTracker timeRangeTracker = this.timeRangeTracker;
        final long entries = this.entryCount;
        return new StoreFileReader(){

            public long length() {
                return len;
            }

            public long getMaxTimestamp() {
                return this.timeRange == null ? Long.MAX_VALUE : timeRangeTracker.getMax();
            }

            public long getEntries() {
                return entries;
            }

            public void close(boolean evictOnClose) throws IOException {
            }

            public Optional<Cell> getLastKey() {
                if (MockHStoreFile.this.splitPoint != null) {
                    return Optional.of(CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setType(Cell.Type.Put).setRow(Arrays.copyOf(MockHStoreFile.this.splitPoint, MockHStoreFile.this.splitPoint.length + 1)).build());
                }
                return Optional.empty();
            }

            public Optional<Cell> midKey() throws IOException {
                if (MockHStoreFile.this.splitPoint != null) {
                    return Optional.of(CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setType(Cell.Type.Put).setRow(MockHStoreFile.this.splitPoint).build());
                }
                return Optional.empty();
            }

            public Optional<Cell> getFirstKey() {
                if (MockHStoreFile.this.splitPoint != null) {
                    return Optional.of(CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setType(Cell.Type.Put).setRow(MockHStoreFile.this.splitPoint, 0, MockHStoreFile.this.splitPoint.length - 1).build());
                }
                return Optional.empty();
            }
        };
    }

    public OptionalLong getBulkLoadTimestamp() {
        return OptionalLong.empty();
    }
}

