/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaCache;
import org.apache.hadoop.hbase.quotas.RegionServerRpcQuotaManager;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ThrottleQuotaTestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ThrottleQuotaTestUtil.class);
    private static ManualEnvironmentEdge envEdge = new ManualEnvironmentEdge();
    private static final int REFRESH_TIME = 1800000;

    private ThrottleQuotaTestUtil() {
        LOG.debug("Call constructor of ThrottleQuotaTestUtil");
    }

    static int doPuts(int maxOps, byte[] family, byte[] qualifier, Table ... tables) {
        return ThrottleQuotaTestUtil.doPuts(maxOps, -1, family, qualifier, tables);
    }

    static int doPuts(int maxOps, int valueSize, byte[] family, byte[] qualifier, Table ... tables) {
        int count;
        try {
            for (count = 0; count < maxOps; count += tables.length) {
                Put put = new Put(Bytes.toBytes((String)("row-" + count)));
                byte[] value = valueSize < 0 ? Bytes.toBytes((String)("data-" + count)) : ThrottleQuotaTestUtil.generateValue(valueSize);
                put.addColumn(family, qualifier, value);
                for (Table table : tables) {
                    table.put(put);
                }
            }
        }
        catch (IOException e) {
            LOG.error("put failed after nRetries=" + count, (Throwable)e);
        }
        return count;
    }

    private static byte[] generateValue(int valueSize) {
        byte[] bytes = new byte[valueSize];
        for (int i = 0; i < valueSize; ++i) {
            bytes[i] = 97;
        }
        return bytes;
    }

    static long doGets(int maxOps, Table ... tables) {
        int count;
        try {
            for (count = 0; count < maxOps; count += tables.length) {
                Get get = new Get(Bytes.toBytes((String)("row-" + count)));
                for (Table table : tables) {
                    table.get(get);
                }
            }
        }
        catch (IOException e) {
            LOG.error("get failed after nRetries=" + count, (Throwable)e);
        }
        return count;
    }

    static void triggerUserCacheRefresh(HBaseTestingUtil testUtil, boolean bypass, TableName ... tables) throws Exception {
        ThrottleQuotaTestUtil.triggerCacheRefresh(testUtil, bypass, true, false, false, false, false, tables);
    }

    static void triggerTableCacheRefresh(HBaseTestingUtil testUtil, boolean bypass, TableName ... tables) throws Exception {
        ThrottleQuotaTestUtil.triggerCacheRefresh(testUtil, bypass, false, true, false, false, false, tables);
    }

    static void triggerNamespaceCacheRefresh(HBaseTestingUtil testUtil, boolean bypass, TableName ... tables) throws Exception {
        ThrottleQuotaTestUtil.triggerCacheRefresh(testUtil, bypass, false, false, true, false, false, tables);
    }

    static void triggerRegionServerCacheRefresh(HBaseTestingUtil testUtil, boolean bypass) throws Exception {
        ThrottleQuotaTestUtil.triggerCacheRefresh(testUtil, bypass, false, false, false, true, false, new TableName[0]);
    }

    static void triggerExceedThrottleQuotaCacheRefresh(HBaseTestingUtil testUtil, boolean exceedEnabled) throws Exception {
        ThrottleQuotaTestUtil.triggerCacheRefresh(testUtil, exceedEnabled, false, false, false, false, true, new TableName[0]);
    }

    private static void triggerCacheRefresh(HBaseTestingUtil testUtil, final boolean bypass, final boolean userLimiter, final boolean tableLimiter, final boolean nsLimiter, final boolean rsLimiter, final boolean exceedThrottleQuota, final TableName ... tables) throws Exception {
        envEdge.incValue(3600000L);
        for (JVMClusterUtil.RegionServerThread rst : testUtil.getMiniHBaseCluster().getRegionServerThreads()) {
            RegionServerRpcQuotaManager quotaManager = rst.getRegionServer().getRegionServerRpcQuotaManager();
            final QuotaCache quotaCache = quotaManager.getQuotaCache();
            quotaCache.triggerCacheRefresh();
            Thread.sleep(250L);
            testUtil.waitFor(60000L, 250L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

                public boolean evaluate() throws Exception {
                    boolean rsIsBypass;
                    boolean isUpdated = true;
                    for (TableName table : tables) {
                        boolean isNsBypass;
                        boolean isTableBypass;
                        boolean isUserBypass;
                        if (userLimiter && (isUserBypass = quotaCache.getUserLimiter(User.getCurrent().getUGI(), table).isBypass()) != bypass) {
                            LOG.info("User limiter for user={}, table={} not refreshed, bypass expected {}, actual {}", new Object[]{User.getCurrent(), table, bypass, isUserBypass});
                            envEdge.incValue(100L);
                            isUpdated = false;
                            break;
                        }
                        if (tableLimiter && (isTableBypass = quotaCache.getTableLimiter(table).isBypass()) != bypass) {
                            LOG.info("Table limiter for table={} not refreshed, bypass expected {}, actual {}", new Object[]{table, bypass, isTableBypass});
                            envEdge.incValue(100L);
                            isUpdated = false;
                            break;
                        }
                        if (!nsLimiter || (isNsBypass = quotaCache.getNamespaceLimiter(table.getNamespaceAsString()).isBypass()) == bypass) continue;
                        LOG.info("Namespace limiter for namespace={} not refreshed, bypass expected {}, actual {}", new Object[]{table.getNamespaceAsString(), bypass, isNsBypass});
                        envEdge.incValue(100L);
                        isUpdated = false;
                        break;
                    }
                    if (rsLimiter && (rsIsBypass = quotaCache.getRegionServerQuotaLimiter("all").isBypass()) != bypass) {
                        LOG.info("RegionServer limiter not refreshed, bypass expected {}, actual {}", (Object)bypass, (Object)rsIsBypass);
                        envEdge.incValue(100L);
                        isUpdated = false;
                    }
                    if (exceedThrottleQuota && quotaCache.isExceedThrottleQuotaEnabled() != bypass) {
                        LOG.info("ExceedThrottleQuotaEnabled not refreshed, bypass expected {}, actual {}", (Object)bypass, (Object)quotaCache.isExceedThrottleQuotaEnabled());
                        envEdge.incValue(100L);
                        isUpdated = false;
                    }
                    if (isUpdated) {
                        return true;
                    }
                    quotaCache.triggerCacheRefresh();
                    return false;
                }

                public String explainFailure() throws Exception {
                    return "Quota cache is still not refreshed";
                }
            });
            LOG.debug("QuotaCache");
            LOG.debug(Objects.toString(quotaCache.getNamespaceQuotaCache()));
            LOG.debug(Objects.toString(quotaCache.getTableQuotaCache()));
            LOG.debug(Objects.toString(quotaCache.getUserQuotaCache()));
            LOG.debug(Objects.toString(quotaCache.getRegionServerQuotaCache()));
        }
    }

    static void waitMinuteQuota() {
        envEdge.incValue(70000L);
    }

    static void clearQuotaCache(HBaseTestingUtil testUtil) {
        for (JVMClusterUtil.RegionServerThread rst : testUtil.getMiniHBaseCluster().getRegionServerThreads()) {
            RegionServerRpcQuotaManager quotaManager = rst.getRegionServer().getRegionServerRpcQuotaManager();
            QuotaCache quotaCache = quotaManager.getQuotaCache();
            quotaCache.getNamespaceQuotaCache().clear();
            quotaCache.getTableQuotaCache().clear();
            quotaCache.getUserQuotaCache().clear();
            quotaCache.getRegionServerQuotaCache().clear();
        }
    }

    static {
        envEdge.setValue(EnvironmentEdgeManager.currentTime());
        EnvironmentEdgeManagerTestHelper.injectEdgeForPackage((EnvironmentEdge)envEdge, (String)ThrottleQuotaTestUtil.class.getPackage().getName());
    }
}

