/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.quotas.FileArchiverNotifierImpl;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestFileArchiverNotifierImpl {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFileArchiverNotifierImpl.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final AtomicLong COUNTER = new AtomicLong();
    @Rule
    public TestName testName = new TestName();
    private Connection conn;
    private Admin admin;
    private SpaceQuotaHelperForTests helper;
    private FileSystem fs;
    private Configuration conf;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        conf.setInt("hbase.hfile.compaction.discharger.interval", 15000);
        conf.setInt("hbase.master.quotas.snapshot.chore.delay", 3600000);
        conf.setInt("hbase.master.quotas.snapshot.chore.period", 3600000);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        this.conn = TEST_UTIL.getConnection();
        this.admin = TEST_UTIL.getAdmin();
        this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, COUNTER);
        this.helper.removeAllQuotas(this.conn);
        this.fs = TEST_UTIL.getTestFileSystem();
        this.conf = TEST_UTIL.getConfiguration();
    }

    @Test
    public void testSnapshotSizePersistence() throws IOException {
        TableName tn;
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.tableExists(tn = TableName.valueOf((String)this.testName.getMethodName()))) {
            admin.disableTable(tn);
            admin.deleteTable(tn);
        }
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])QuotaTableUtil.QUOTA_FAMILY_USAGE)).build();
        admin.createTable(desc);
        FileArchiverNotifierImpl notifier = new FileArchiverNotifierImpl(this.conn, this.conf, this.fs, tn);
        ArrayList snapshotsWithSizes = new ArrayList();
        try (Table table = this.conn.getTable(tn);){
            this.verify(table, () -> {
                notifier.persistSnapshotSizes(table, snapshotsWithSizes);
                Assert.assertEquals((long)0L, (long)this.count(table));
            });
            this.verify(table, () -> {
                snapshotsWithSizes.add(new FileArchiverNotifierImpl.SnapshotWithSize("ss1", 1024L));
                snapshotsWithSizes.add(new FileArchiverNotifierImpl.SnapshotWithSize("ss2", 4096L));
                notifier.persistSnapshotSizes(table, snapshotsWithSizes);
                Assert.assertEquals((long)2L, (long)this.count(table));
                Assert.assertEquals((long)1024L, (long)this.extractSnapshotSize(table, tn, "ss1"));
                Assert.assertEquals((long)4096L, (long)this.extractSnapshotSize(table, tn, "ss2"));
            });
        }
    }

    @Test
    public void testIncrementalFileArchiving() throws Exception {
        TableName tn;
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.tableExists(tn = TableName.valueOf((String)this.testName.getMethodName()))) {
            admin.disableTable(tn);
            admin.deleteTable(tn);
        }
        Table quotaTable = this.conn.getTable(QuotaUtil.QUOTA_TABLE_NAME);
        TableName tn1 = this.helper.createTableWithRegions(1);
        admin.setQuota(QuotaSettingsFactory.limitTableSpace((TableName)tn1, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS));
        this.helper.writeData(tn1, 262144L);
        admin.flush(tn1);
        String snapshotName1 = tn1 + "snapshot1";
        admin.snapshot(new SnapshotDescription(snapshotName1, tn1, SnapshotType.SKIPFLUSH));
        FileArchiverNotifierImpl notifier = new FileArchiverNotifierImpl(this.conn, this.conf, this.fs, tn);
        long t1 = notifier.getLastFullCompute();
        long snapshotSize = notifier.computeAndStoreSnapshotSizes(Arrays.asList(snapshotName1));
        Assert.assertEquals((String)"The size of the snapshots should be zero", (long)0L, (long)snapshotSize);
        Assert.assertTrue((String)"Last compute time was not less than current compute time", (t1 < notifier.getLastFullCompute() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.extractSnapshotSize(quotaTable, tn, snapshotName1));
        notifier.addArchivedFiles(Collections.emptySet());
        Assert.assertEquals((long)0L, (long)this.extractSnapshotSize(quotaTable, tn, snapshotName1));
        notifier.addArchivedFiles((Set)ImmutableSet.of(this.entry("a", 1024L), this.entry("b", 1024L)));
        Assert.assertEquals((long)0L, (long)this.extractSnapshotSize(quotaTable, tn, snapshotName1));
        Set<String> referencedFiles = this.getFilesReferencedBySnapshot(snapshotName1);
        Assert.assertTrue((String)("Found snapshot referenced files: " + referencedFiles), (referencedFiles.size() >= 1 ? 1 : 0) != 0);
        String referencedFile = (String)Iterables.getFirst(referencedFiles, null);
        Assert.assertNotNull((Object)referencedFile);
        long fakeFileSize = 2048L;
        notifier.addArchivedFiles((Set)ImmutableSet.of(this.entry(referencedFile, 2048L)));
        Assert.assertEquals((long)2048L, (long)this.extractSnapshotSize(quotaTable, tn, snapshotName1));
        long t2 = notifier.getLastFullCompute();
        snapshotSize = notifier.computeAndStoreSnapshotSizes(Arrays.asList(snapshotName1));
        Assert.assertEquals((long)0L, (long)snapshotSize);
        Assert.assertEquals((long)0L, (long)this.extractSnapshotSize(quotaTable, tn, snapshotName1));
        Assert.assertTrue((String)"Last compute time was not less than current compute time", (t2 < notifier.getLastFullCompute() ? 1 : 0) != 0);
    }

    @Test
    public void testParseOldNamespaceSnapshotSize() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        TableName fakeQuotaTableName = TableName.valueOf((String)this.testName.getMethodName());
        TableName tn = TableName.valueOf((String)(this.testName.getMethodName() + "1"));
        if (admin.tableExists(fakeQuotaTableName)) {
            admin.disableTable(fakeQuotaTableName);
            admin.deleteTable(fakeQuotaTableName);
        }
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)fakeQuotaTableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])QuotaTableUtil.QUOTA_FAMILY_USAGE)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])QuotaUtil.QUOTA_FAMILY_INFO)).build();
        admin.createTable(desc);
        String ns = "";
        try (Table fakeQuotaTable = this.conn.getTable(fakeQuotaTableName);){
            FileArchiverNotifierImpl notifier = new FileArchiverNotifierImpl(this.conn, this.conf, this.fs, tn);
            Assert.assertEquals((long)0L, (long)notifier.getPreviousNamespaceSnapshotSize(fakeQuotaTable, ""));
            fakeQuotaTable.put(QuotaTableUtil.createPutForNamespaceSnapshotSize((String)"", (long)0L));
            Assert.assertEquals((long)0L, (long)notifier.getPreviousNamespaceSnapshotSize(fakeQuotaTable, ""));
            fakeQuotaTable.put(QuotaTableUtil.createPutForNamespaceSnapshotSize((String)"", (long)1024L));
            Assert.assertEquals((long)1024L, (long)notifier.getPreviousNamespaceSnapshotSize(fakeQuotaTable, ""));
        }
    }

    private long count(Table t) throws IOException {
        try (ResultScanner rs = t.getScanner(new Scan());){
            long sum = 0L;
            for (Result r : rs) {
                while (r.advance()) {
                    ++sum;
                }
            }
            long l = sum;
            return l;
        }
    }

    private long extractSnapshotSize(Table quotaTable, TableName tn, String snapshot) throws IOException {
        Get g = QuotaTableUtil.makeGetForSnapshotSize((TableName)tn, (String)snapshot);
        Result r = quotaTable.get(g);
        Assert.assertNotNull((Object)r);
        CellScanner cs = r.cellScanner();
        Assert.assertTrue((boolean)cs.advance());
        Cell c = cs.current();
        Assert.assertNotNull((Object)c);
        return QuotaTableUtil.extractSnapshotSize((byte[])c.getValueArray(), (int)c.getValueOffset(), (int)c.getValueLength());
    }

    private void verify(Table t, IOThrowingRunnable test) throws IOException {
        this.admin.disableTable(t.getName());
        this.admin.truncateTable(t.getName(), false);
        test.run();
    }

    private Set<String> getFilesReferencedBySnapshot(String snapshotName) throws IOException {
        HashSet<String> files = new HashSet<String>();
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)CommonFSUtils.getRootDir((Configuration)this.conf));
        SnapshotProtos.SnapshotDescription sd = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)this.fs, (Path)snapshotDir);
        SnapshotManifest manifest = SnapshotManifest.open((Configuration)this.conf, (FileSystem)this.fs, (Path)snapshotDir, (SnapshotProtos.SnapshotDescription)sd);
        for (SnapshotProtos.SnapshotRegionManifest rm : manifest.getRegionManifests()) {
            for (SnapshotProtos.SnapshotRegionManifest.FamilyFiles ff : rm.getFamilyFilesList()) {
                for (SnapshotProtos.SnapshotRegionManifest.StoreFile sf : ff.getStoreFilesList()) {
                    files.add(sf.getName());
                }
            }
        }
        return files;
    }

    private <K, V> Map.Entry<K, V> entry(K k, V v) {
        return Maps.immutableEntry(k, v);
    }

    @FunctionalInterface
    private static interface IOThrowingRunnable {
        public void run() throws IOException;
    }
}

