/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.region;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.master.region.MasterRegionFactory;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.store.LeaseRecovery;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.region.RegionProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.region.RegionProcedureStoreTestHelper;
import org.apache.hadoop.hbase.procedure2.store.region.RegionProcedureStoreTestProcedure;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestRegionProcedureStoreMigration {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionProcedureStoreMigration.class);
    private HBaseCommonTestingUtil htu;
    private Server server;
    private MasterRegion region;
    private RegionProcedureStore store;
    private WALProcedureStore walStore;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtil();
        Configuration conf = this.htu.getConfiguration();
        conf.setBoolean("hbase.hregion.memstore.mslab.enabled", false);
        conf.setBoolean("hbase.unsafe.stream.capability.enforce", false);
        Path testDir = this.htu.getDataTestDir();
        CommonFSUtils.setRootDir((Configuration)conf, (Path)testDir);
        this.walStore = new WALProcedureStore(conf, new LeaseRecovery(){

            public void recoverFileLease(FileSystem fs, Path path) throws IOException {
            }
        });
        this.walStore.start(1);
        this.walStore.recoverLease();
        this.walStore.load((ProcedureStore.ProcedureLoader)new ProcedureTestingUtility.LoadCounter());
        this.server = RegionProcedureStoreTestHelper.mockServer(conf);
        this.region = MasterRegionFactory.create((Server)this.server);
    }

    @After
    public void tearDown() throws IOException {
        if (this.store != null) {
            this.store.stop(true);
        }
        this.region.close(true);
        this.walStore.stop(true);
        this.htu.cleanupTestDir();
    }

    @Test
    public void test() throws IOException {
        int i;
        ArrayList<RegionProcedureStoreTestProcedure> procs = new ArrayList<RegionProcedureStoreTestProcedure>();
        for (i = 0; i < 10; ++i) {
            RegionProcedureStoreTestProcedure proc = new RegionProcedureStoreTestProcedure();
            this.walStore.insert((Procedure)proc, null);
            procs.add(proc);
        }
        for (i = 5; i < 10; ++i) {
            this.walStore.delete(((RegionProcedureStoreTestProcedure)((Object)procs.get(i))).getProcId());
        }
        this.walStore.stop(true);
        final TreeSet loadedProcs = new TreeSet((p1, p2) -> Long.compare(p1.getProcId(), p2.getProcId()));
        final MutableLong maxProcIdSet = new MutableLong(0L);
        this.store = RegionProcedureStoreTestHelper.createStore(this.server, this.region, new ProcedureStore.ProcedureLoader(){

            public void setMaxProcId(long maxProcId) {
                maxProcIdSet.setValue(maxProcId);
            }

            public void load(ProcedureStore.ProcedureIterator procIter) throws IOException {
                while (procIter.hasNext()) {
                    RegionProcedureStoreTestProcedure proc = (RegionProcedureStoreTestProcedure)procIter.next();
                    loadedProcs.add(proc);
                }
            }

            public void handleCorrupted(ProcedureStore.ProcedureIterator procIter) throws IOException {
                if (procIter.hasNext()) {
                    Assert.fail((String)"Found corrupted procedures");
                }
            }
        });
        Assert.assertEquals((long)10L, (long)maxProcIdSet.longValue());
        Assert.assertEquals((long)5L, (long)loadedProcs.size());
        int procId = 1;
        for (RegionProcedureStoreTestProcedure proc : loadedProcs) {
            Assert.assertEquals((long)procId, (long)proc.getProcId());
            ++procId;
        }
        Path testDir = this.htu.getDataTestDir();
        FileSystem fs = testDir.getFileSystem(this.htu.getConfiguration());
        Path oldProcWALDir = new Path(testDir, "MasterProcWALs");
        Assert.assertFalse((boolean)fs.exists(oldProcWALDir));
    }

    @Test
    public void testMigrateWithUnsupportedProcedures() throws IOException {
        AssignProcedure assignProc = new AssignProcedure();
        assignProc.setProcId(1L);
        assignProc.setRegionInfo(RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"table")).build());
        this.walStore.insert((Procedure)assignProc, null);
        this.walStore.stop(true);
        try {
            this.store = RegionProcedureStoreTestHelper.createStore(this.server, this.region, (ProcedureStore.ProcedureLoader)new ProcedureTestingUtility.LoadCounter());
            Assert.fail((String)"Should fail since AssignProcedure is not supported");
        }
        catch (HBaseIOException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Unsupported"));
        }
    }
}

