/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.mob.DefaultMobStoreCompactor;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.TestMobUtils;
import org.apache.hadoop.hbase.regionserver.CellSink;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionAsTable;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestMobCompactionWithException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobCompactionWithException.class);
    @Rule
    public TestName name = new TestName();
    static final Logger LOG = LoggerFactory.getLogger((String)TestMobCompactionWithException.class.getName());
    private static final HBaseTestingUtil HTU = new HBaseTestingUtil();
    private static Configuration conf = null;
    private HRegion region = null;
    private TableDescriptor tableDescriptor;
    private ColumnFamilyDescriptor columnFamilyDescriptor;
    private FileSystem fs;
    private static final byte[] COLUMN_FAMILY = HBaseTestingUtil.fam1;
    private final byte[] STARTROW = Bytes.toBytes((String)HBaseTestingUtil.START_KEY);
    private static volatile boolean testException = false;
    private static int rowCount = 100;
    private Table table;

    @BeforeClass
    public static void setUp() throws Exception {
        conf = HTU.getConfiguration();
        conf.set("hbase.mob.compaction.type", "optimized");
        conf.set("hbase.hstore.mobengine.compactor.class", MyMobStoreCompactor.class.getName());
    }

    @After
    public void tearDown() throws Exception {
        this.region.close();
        this.table.close();
        this.fs.delete(HTU.getDataTestDir(), true);
    }

    private void createTable(long mobThreshold) throws IOException {
        this.columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])COLUMN_FAMILY).setMobEnabled(true).setMobThreshold(mobThreshold).setMaxVersions(1).setBlocksize(500).build();
        this.tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)TestMobUtils.getTableName(this.name))).setColumnFamily(this.columnFamilyDescriptor).build();
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)this.tableDescriptor.getTableName()).build();
        this.region = HBaseTestingUtil.createRegionAndWAL(regionInfo, HTU.getDataTestDir(), conf, this.tableDescriptor, new MobFileCache(conf));
        this.table = new RegionAsTable((Region)this.region);
        this.fs = FileSystem.get((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMobStoreFileDeletedWhenCompactException() throws Exception {
        this.createTable(200L);
        byte[] dummyData = this.makeDummyData(1000);
        for (int i = 0; i < rowCount; ++i) {
            Put p = this.createPut(i, dummyData);
            this.table.put(p);
            this.region.flush(true);
        }
        int storeFileCountBeforeCompact = this.countStoreFiles();
        int mobFileCountBeforeCompact = this.countMobFiles();
        long mobFileByteSize = this.getMobFileByteSize();
        List stores = this.region.getStores();
        Assert.assertTrue((stores.size() == 1 ? 1 : 0) != 0);
        HMobStore mobStore = (HMobStore)stores.get(0);
        Compactor compactor = mobStore.getStoreEngine().getCompactor();
        MyMobStoreCompactor myMobStoreCompactor = (MyMobStoreCompactor)compactor;
        myMobStoreCompactor.setMobFileMaxByteSize(mobFileByteSize + 100L);
        testException = true;
        try {
            try {
                mobStore.triggerMajorCompaction();
                Optional context = mobStore.requestCompaction(1, CompactionLifeCycleTracker.DUMMY, User.getCurrent());
                Assert.assertTrue((boolean)context.isPresent());
                this.region.compact((CompactionContext)context.get(), (HStore)mobStore, (ThroughputController)NoLimitThroughputController.INSTANCE, User.getCurrent());
                Assert.fail();
            }
            catch (IOException e) {
                Assert.assertTrue((e != null ? 1 : 0) != 0);
            }
        }
        finally {
            testException = false;
        }
        Assert.assertEquals((String)"After compaction: store files", (long)storeFileCountBeforeCompact, (long)this.countStoreFiles());
        Assert.assertEquals((String)"After compaction: mob file count", (long)mobFileCountBeforeCompact, (long)this.countMobFiles());
    }

    private int countStoreFiles() throws IOException {
        HStore store = this.region.getStore(COLUMN_FAMILY);
        return store.getStorefilesCount();
    }

    private int countMobFiles() throws IOException {
        Path mobDirPath = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)this.tableDescriptor.getTableName(), (String)this.columnFamilyDescriptor.getNameAsString());
        if (this.fs.exists(mobDirPath)) {
            FileStatus[] files = HTU.getTestFileSystem().listStatus(mobDirPath);
            return files.length;
        }
        return 0;
    }

    private long getMobFileByteSize() throws IOException {
        FileStatus[] files;
        Path mobDirPath = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)this.tableDescriptor.getTableName(), (String)this.columnFamilyDescriptor.getNameAsString());
        if (this.fs.exists(mobDirPath) && (files = HTU.getTestFileSystem().listStatus(mobDirPath)).length > 0) {
            return files[0].getLen();
        }
        return 0L;
    }

    private Put createPut(int rowIdx, byte[] dummyData) throws IOException {
        Put p = new Put(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)rowIdx)));
        p.setDurability(Durability.SKIP_WAL);
        p.addColumn(COLUMN_FAMILY, Bytes.toBytes((String)"colX"), dummyData);
        return p;
    }

    private byte[] makeDummyData(int size) {
        byte[] dummyData = new byte[size];
        Bytes.random((byte[])dummyData);
        return dummyData;
    }

    public static class MyMobStoreCompactor
    extends DefaultMobStoreCompactor {
        public MyMobStoreCompactor(Configuration conf, HStore store) {
            super(conf, store);
        }

        public void setMobFileMaxByteSize(long maxByteSize) {
            this.conf.setLong("hbase.mob.compactions.max.file.size", maxByteSize);
        }

        protected boolean performCompaction(Compactor.FileDetails fd, final InternalScanner scanner, CellSink writer, long smallestReadPoint, boolean cleanSeqId, ThroughputController throughputController, CompactionRequestImpl request, CompactionProgress progress) throws IOException {
            InternalScanner wrappedScanner = new InternalScanner(){
                private int count = -1;

                public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
                    ++this.count;
                    if (this.count == rowCount - 1 && testException) {
                        this.count = 0;
                        throw new IOException("Inject Error");
                    }
                    return scanner.next(result, scannerContext);
                }

                public void close() throws IOException {
                    scanner.close();
                }
            };
            return super.performCompaction(fd, wrappedScanner, writer, smallestReadPoint, cleanSeqId, throughputController, request, progress);
        }
    }
}

