/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ProcedureTestUtil;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.replication.TransitPeerSyncReplicationStateProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestTransitPeerSyncReplicationStateProcedureBackoff {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTransitPeerSyncReplicationStateProcedureBackoff.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static boolean FAIL = true;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertBackoffIncrease() throws IOException, InterruptedException {
        ProcedureTestUtil.waitUntilProcedureWaitingTimeout(UTIL, TestTransitPeerSyncReplicationStateProcedure.class, 30000L);
        ProcedureTestUtil.waitUntilProcedureTimeoutIncrease(UTIL, TestTransitPeerSyncReplicationStateProcedure.class, 2);
        Class<TestTransitPeerSyncReplicationStateProcedure> clazz = TestTransitPeerSyncReplicationStateProcedure.class;
        synchronized (TestTransitPeerSyncReplicationStateProcedure.class) {
            FAIL = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            UTIL.waitFor(30000L, () -> FAIL);
            return;
        }
    }

    @Test
    public void testDowngradeActiveToActive() throws IOException, InterruptedException {
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        long procId = procExec.submitProcedure((Procedure)new TestTransitPeerSyncReplicationStateProcedure("1", SyncReplicationState.ACTIVE));
        this.assertBackoffIncrease();
        this.assertBackoffIncrease();
        UTIL.waitFor(30000L, () -> procExec.isFinished(procId));
    }

    @Test
    public void testDowngradeActiveToStandby() throws IOException, InterruptedException {
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        long procId = procExec.submitProcedure((Procedure)new TestTransitPeerSyncReplicationStateProcedure("2", SyncReplicationState.STANDBY));
        this.assertBackoffIncrease();
        this.assertBackoffIncrease();
        this.assertBackoffIncrease();
        this.assertBackoffIncrease();
        UTIL.waitFor(30000L, () -> procExec.isFinished(procId));
    }

    public static class TestTransitPeerSyncReplicationStateProcedure
    extends TransitPeerSyncReplicationStateProcedure {
        public TestTransitPeerSyncReplicationStateProcedure() {
        }

        public TestTransitPeerSyncReplicationStateProcedure(String peerId, SyncReplicationState state) {
            super(peerId, state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryFail() throws ReplicationException {
            Class<TestTransitPeerSyncReplicationStateProcedureBackoff> clazz = TestTransitPeerSyncReplicationStateProcedureBackoff.class;
            synchronized (TestTransitPeerSyncReplicationStateProcedureBackoff.class) {
                if (FAIL) {
                    throw new ReplicationException("Inject error");
                }
                FAIL = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        protected <T extends Procedure<MasterProcedureEnv>> void addChildProcedure(T ... subProcedure) {
        }

        protected void preTransit(MasterProcedureEnv env) throws IOException {
            this.fromState = SyncReplicationState.DOWNGRADE_ACTIVE;
        }

        protected void setPeerNewSyncReplicationState(MasterProcedureEnv env) throws ReplicationException {
            this.tryFail();
        }

        protected void removeAllReplicationQueues(MasterProcedureEnv env) throws ReplicationException {
            this.tryFail();
        }

        protected void reopenRegions(MasterProcedureEnv env) {
        }

        protected void transitPeerSyncReplicationState(MasterProcedureEnv env) throws ReplicationException {
            this.tryFail();
        }

        protected void createDirForRemoteWAL(MasterProcedureEnv env) throws IOException {
            try {
                this.tryFail();
            }
            catch (ReplicationException e) {
                throw new IOException(e);
            }
        }
    }
}

