/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.replication.SyncReplicationReplayWALManager;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={MasterTests.class, SmallTests.class})
public class TestSyncReplicationReplayWALManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSyncReplicationReplayWALManager.class);
    private static HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private SyncReplicationReplayWALManager manager;
    private MasterProcedureScheduler scheduler;
    private Set<ServerName> onlineServers;
    private List<ServerListener> listeners;
    private Queue<Procedure<?>> wokenProcedures;

    @Before
    public void setUp() throws IOException, ReplicationException {
        this.wokenProcedures = new ArrayDeque();
        this.onlineServers = new HashSet<ServerName>();
        this.listeners = new ArrayList<ServerListener>();
        ServerManager serverManager = (ServerManager)Mockito.mock(ServerManager.class);
        ((ServerManager)Mockito.doAnswer(inv -> this.listeners.add((ServerListener)inv.getArgument(0))).when((Object)serverManager)).registerListener((ServerListener)ArgumentMatchers.any(ServerListener.class));
        ServerMetrics serverMetrics = (ServerMetrics)Mockito.mock(ServerMetrics.class);
        ((ServerManager)Mockito.doAnswer(inv -> this.onlineServers.stream().collect(Collectors.toMap(Function.identity(), k -> serverMetrics))).when((Object)serverManager)).getOnlineServers();
        MasterFileSystem mfs = (MasterFileSystem)Mockito.mock(MasterFileSystem.class);
        Mockito.when((Object)mfs.getFileSystem()).thenReturn((Object)UTIL.getTestFileSystem());
        Mockito.when((Object)mfs.getWALRootDir()).thenReturn((Object)new Path("/"));
        this.scheduler = (MasterProcedureScheduler)Mockito.mock(MasterProcedureScheduler.class);
        ((MasterProcedureScheduler)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ProcedureEvent event = ((ProcedureEvent[])invocation.getArgument(0))[0];
                event.wakeInternal((AbstractProcedureScheduler)new MasterProcedureScheduler(pid -> null){

                    public void addFront(Iterator<Procedure> procedureIterator) {
                        procedureIterator.forEachRemaining(TestSyncReplicationReplayWALManager.this.wokenProcedures::add);
                    }
                });
                return null;
            }
        }).when((Object)this.scheduler)).wakeEvents((ProcedureEvent[])ArgumentMatchers.any(ProcedureEvent[].class));
        MasterProcedureEnv env = (MasterProcedureEnv)Mockito.mock(MasterProcedureEnv.class);
        Mockito.when((Object)env.getProcedureScheduler()).thenReturn((Object)this.scheduler);
        ProcedureExecutor procExec = (ProcedureExecutor)Mockito.mock(ProcedureExecutor.class);
        Mockito.when((Object)procExec.getEnvironment()).thenReturn((Object)env);
        MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)services.getServerManager()).thenReturn((Object)serverManager);
        Mockito.when((Object)services.getMasterFileSystem()).thenReturn((Object)mfs);
        Mockito.when((Object)services.getMasterProcedureExecutor()).thenReturn((Object)procExec);
        this.manager = new SyncReplicationReplayWALManager(services);
        Assert.assertEquals((long)1L, (long)this.listeners.size());
    }

    @Test
    public void testUsedWorkers() throws ProcedureSuspendedException {
        String peerId1 = "1";
        String peerId2 = "2";
        ServerName sn1 = ServerName.valueOf((String)"host1", (int)123, (long)12345L);
        ServerName sn2 = ServerName.valueOf((String)"host2", (int)234, (long)23456L);
        ServerName sn3 = ServerName.valueOf((String)"host3", (int)345, (long)34567L);
        this.onlineServers.add(sn1);
        this.manager.registerPeer(peerId1);
        this.manager.registerPeer(peerId2);
        Assert.assertEquals((Object)sn1, (Object)this.manager.acquirePeerWorker(peerId1, (Procedure)new ProcedureTestingUtility.NoopProcedure()));
        Assert.assertEquals((Object)sn1, (Object)this.manager.acquirePeerWorker(peerId2, (Procedure)new ProcedureTestingUtility.NoopProcedure()));
        this.onlineServers.add(sn2);
        Assert.assertEquals((Object)sn2, (Object)this.manager.acquirePeerWorker(peerId1, (Procedure)new ProcedureTestingUtility.NoopProcedure()));
        Assert.assertEquals((Object)sn2, (Object)this.manager.acquirePeerWorker(peerId2, (Procedure)new ProcedureTestingUtility.NoopProcedure()));
        ProcedureTestingUtility.NoopProcedure proc = new ProcedureTestingUtility.NoopProcedure();
        try {
            this.manager.acquirePeerWorker(peerId1, (Procedure)proc);
            Assert.fail((String)"Should suspend");
        }
        catch (ProcedureSuspendedException procedureSuspendedException) {
            // empty catch block
        }
        this.manager.releasePeerWorker(peerId1, sn1, this.scheduler);
        Assert.assertEquals((long)1L, (long)this.wokenProcedures.size());
        Assert.assertSame((Object)proc, this.wokenProcedures.poll());
        Assert.assertEquals((Object)sn1, (Object)this.manager.acquirePeerWorker(peerId1, (Procedure)new ProcedureTestingUtility.NoopProcedure()));
        ProcedureTestingUtility.NoopProcedure proc1 = new ProcedureTestingUtility.NoopProcedure();
        ProcedureTestingUtility.NoopProcedure proc2 = new ProcedureTestingUtility.NoopProcedure();
        try {
            this.manager.acquirePeerWorker(peerId1, (Procedure)proc1);
            Assert.fail((String)"Should suspend");
        }
        catch (ProcedureSuspendedException procedureSuspendedException) {
            // empty catch block
        }
        try {
            this.manager.acquirePeerWorker(peerId1, (Procedure)proc2);
            Assert.fail((String)"Should suspend");
        }
        catch (ProcedureSuspendedException procedureSuspendedException) {
            // empty catch block
        }
        this.listeners.get(0).serverAdded(sn3);
        Assert.assertEquals((long)2L, (long)this.wokenProcedures.size());
        Assert.assertSame((Object)proc2, this.wokenProcedures.poll());
        Assert.assertSame((Object)proc1, this.wokenProcedures.poll());
    }
}

