/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.replication.MigrateReplicationQueueFromZkToTableProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMigrateReplicationQueueFromZkToTableProcedureRecovery {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMigrateReplicationQueueFromZkToTableProcedureRecovery.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void setupCluster() throws Exception {
        UTIL.getConfiguration().setInt("hbase.master.procedure.threads", 1);
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    @Before
    public void setup() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
    }

    private String getHFileRefsZNode() throws IOException {
        Configuration conf = UTIL.getConfiguration();
        ZKWatcher zk = UTIL.getZooKeeperWatcher();
        String replicationZNode = ZNodePaths.joinZNode((String)zk.getZNodePaths().baseZNode, (String[])new String[]{conf.get("zookeeper.znode.replication", "replication")});
        return ZNodePaths.joinZNode((String)replicationZNode, (String[])new String[]{conf.get("zookeeper.znode.replication.hfile.refs", "hfile-refs")});
    }

    @Test
    public void testRecoveryAndDoubleExecution() throws Exception {
        String peerId = "2";
        ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(UTIL.getZkCluster().getAddress().toString() + ":/testhbase").setReplicateAllUserTables(true).build();
        UTIL.getAdmin().addReplicationPeer(peerId, rpc);
        String hfileRefsZNode = this.getHFileRefsZNode();
        String hfile = "hfile";
        String hfileZNode = ZNodePaths.joinZNode((String)hfileRefsZNode, (String[])new String[]{peerId, hfile});
        ZKUtil.createWithParents((ZKWatcher)UTIL.getZooKeeperWatcher(), (String)hfileZNode);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new MigrateReplicationQueueFromZkToTableProcedure());
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        ReplicationQueueStorage queueStorage = UTIL.getMiniHBaseCluster().getMaster().getReplicationPeerManager().getQueueStorage();
        List hfiles = queueStorage.getReplicableHFiles(peerId);
        MatcherAssert.assertThat((Object)hfiles, (Matcher)Matchers.both((Matcher)Matchers.hasItem((Object)hfile)).and(Matchers.hasSize((int)1)));
    }
}

