/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.master.replication.AddPeerProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.replication.DummyReplicationEndpoint;
import org.apache.hadoop.hbase.replication.FSReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MasterTests.class, LargeTests.class})
public class TestDisablePeerModification {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDisablePeerModification.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static volatile CountDownLatch ARRIVE;
    private static volatile CountDownLatch RESUME;
    @Parameterized.Parameter
    public boolean async;

    @Parameterized.Parameters(name="{index}: async={0}")
    public static List<Object[]> params() {
        return Arrays.asList({true}, {false});
    }

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setClass("hbase.replication.peer.storage.impl", MockPeerStorage.class, ReplicationPeerStorage.class);
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUpBeforeTest() throws IOException {
        UTIL.getAdmin().replicationPeerModificationSwitch(true, true);
    }

    @Test
    public void testDrainProcs() throws Exception {
        CompletableFuture switchFuture;
        ARRIVE = new CountDownLatch(1);
        RESUME = new CountDownLatch(1);
        AsyncAdmin admin = UTIL.getAsyncConnection().getAdmin();
        ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(UTIL.getClusterKey() + "-test").setReplicationEndpointImpl(DummyReplicationEndpoint.class.getName()).build();
        CompletableFuture addFuture = admin.addReplicationPeer("test_peer_" + this.async, rpc);
        ARRIVE.await();
        if (this.async) {
            switchFuture = admin.replicationPeerModificationSwitch(false, true);
        } else {
            switchFuture = new CompletableFuture();
            ForkJoinPool.commonPool().submit(() -> {
                try {
                    switchFuture.complete(UTIL.getAdmin().replicationPeerModificationSwitch(false, true));
                }
                catch (IOException e) {
                    switchFuture.completeExceptionally(e);
                }
            });
        }
        Thread.sleep(5000L);
        Assert.assertFalse((boolean)switchFuture.isDone());
        AddPeerProcedure proc = new AddPeerProcedure("failure", rpc, true);
        UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().submitProcedure((Procedure)proc);
        UTIL.waitFor(15000L, () -> proc.isFinished());
        Assert.assertTrue((boolean)proc.isFailed());
        MatcherAssert.assertThat((Object)proc.getException().getCause().getMessage(), (Matcher)Matchers.containsString((String)"Replication peer modification disabled"));
        Thread.sleep(5000L);
        Assert.assertFalse((boolean)switchFuture.isDone());
        RESUME.countDown();
        addFuture.get();
        Assert.assertTrue((boolean)((Boolean)switchFuture.get()));
    }

    public static final class MockPeerStorage
    extends FSReplicationPeerStorage {
        public MockPeerStorage(FileSystem fs, Configuration conf) throws IOException {
            super(fs, conf);
        }

        public void addPeer(String peerId, ReplicationPeerConfig peerConfig, boolean enabled, SyncReplicationState syncReplicationState) throws ReplicationException {
            ARRIVE.countDown();
            try {
                RESUME.await();
            }
            catch (InterruptedException e) {
                throw new ReplicationException((Throwable)e);
            }
            super.addPeer(peerId, peerConfig, enabled, syncReplicationState);
        }
    }
}

