/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.migrate;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, MasterTests.class})
public class TestInitializeStoreFileTracker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestInitializeStoreFileTracker.class);
    private static final String[] tables = new String[]{"t1", "t2", "t3", "t4", "t5", "t6"};
    private static final String famStr = "f1";
    private static final byte[] fam = Bytes.toBytes((String)"f1");
    private HBaseTestingUtil HTU;
    private Configuration conf;
    private TableDescriptor tableDescriptor;

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create();
        this.conf.setInt("hbase.master.rolling.upgrade.chore.period.secs", 1);
        this.conf.setLong("hbase.master.rolling.upgrade.chore.delay.secs", 1L);
        this.conf.set("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.FILE.name());
        this.HTU = new HBaseTestingUtil(this.conf);
        this.HTU.startMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        this.HTU.shutdownMiniCluster();
    }

    @Test
    public void testMigrateStoreFileTracker() throws IOException, InterruptedException {
        for (int i = 0; i < tables.length; ++i) {
            this.tableDescriptor = this.HTU.createModifyableTableDescriptor(tables[i]).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])fam).build()).build();
            this.HTU.createTable(this.tableDescriptor, (byte[][])null);
        }
        TableDescriptors tableDescriptors = this.HTU.getMiniHBaseCluster().getMaster().getTableDescriptors();
        for (int i = 0; i < tables.length; ++i) {
            TableDescriptor tdAfterCreated = tableDescriptors.get(TableName.valueOf((String)tables[i]));
            Assert.assertNotNull((Object)tdAfterCreated.getValue("hbase.store.file-tracker.impl"));
            TableDescriptor tdRemovedSFT = TableDescriptorBuilder.newBuilder((TableDescriptor)tdAfterCreated).removeValue("hbase.store.file-tracker.impl").build();
            tableDescriptors.update(tdRemovedSFT);
        }
        this.HTU.getMiniHBaseCluster().stopMaster(0).join();
        this.HTU.getMiniHBaseCluster().startMaster();
        this.HTU.getMiniHBaseCluster().waitForActiveAndReadyMaster(30000L);
        TableDescriptors tds = this.HTU.getMiniHBaseCluster().getMaster().getTableDescriptors();
        this.HTU.waitFor(30000L, () -> {
            try {
                for (int i = 0; i < tables.length; ++i) {
                    TableDescriptor td = tds.get(TableName.valueOf((String)tables[i]));
                    if (!StringUtils.isEmpty((CharSequence)td.getValue("hbase.store.file-tracker.impl"))) continue;
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                return false;
            }
        });
        for (String table : tables) {
            TableDescriptor td = tds.get(TableName.valueOf((String)table));
            Assert.assertEquals((Object)StoreFileTrackerFactory.Trackers.DEFAULT.name(), (Object)td.getValue("hbase.store.file-tracker.impl"));
        }
    }
}

