/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.janitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaMockingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.MockMasterServices;
import org.apache.hadoop.hbase.master.janitor.CatalogJanitor;
import org.apache.hadoop.hbase.master.janitor.CatalogJanitorReport;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.HFileArchiveTestingUtil;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestCatalogJanitor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCatalogJanitor.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCatalogJanitor.class);
    private static final HBaseTestingUtil HTU = new HBaseTestingUtil();
    @Rule
    public final TestName name = new TestName();
    private MockMasterServices masterServices;
    private CatalogJanitor janitor;

    @BeforeClass
    public static void beforeClass() throws Exception {
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
    }

    @Before
    public void setup() throws Exception {
        this.setRootDirAndCleanIt(HTU, this.name.getMethodName());
        this.masterServices = new MockMasterServices(HTU.getConfiguration());
        this.masterServices.start(10, null);
        this.janitor = new CatalogJanitor((MasterServices)this.masterServices);
    }

    @After
    public void teardown() {
        this.janitor.shutdown(true);
        this.masterServices.stop("DONE");
    }

    private RegionInfo createRegionInfo(TableName tableName, byte[] startKey, byte[] endKey) {
        return this.createRegionInfo(tableName, startKey, endKey, false);
    }

    private RegionInfo createRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split) {
        return RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(startKey).setEndKey(endKey).setSplit(split).build();
    }

    @Test
    public void testCleanMerge() throws IOException {
        TableDescriptor td = this.createTableDescriptorForCurrentMethod();
        RegionInfo merged = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
        RegionInfo parenta = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        RegionInfo parentb = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
        ArrayList<RegionInfo> parents = new ArrayList<RegionInfo>();
        parents.add(parenta);
        parents.add(parentb);
        Path rootdir = this.masterServices.getMasterFileSystem().getRootDir();
        Path tabledir = CommonFSUtils.getTableDir((Path)rootdir, (TableName)td.getTableName());
        Path storedir = HRegionFileSystem.getStoreHomedir((Path)tabledir, (RegionInfo)merged, (byte[])td.getColumnFamilies()[0].getName());
        Path parentaRef = this.createMergeReferenceFile(storedir, merged, parenta);
        Path parentbRef = this.createMergeReferenceFile(storedir, merged, parentb);
        Assert.assertFalse((boolean)CatalogJanitor.cleanMergeRegion((MasterServices)this.masterServices, (RegionInfo)merged, parents));
        this.masterServices.getMasterFileSystem().getFileSystem().delete(parentaRef, false);
        Assert.assertFalse((boolean)CatalogJanitor.cleanMergeRegion((MasterServices)this.masterServices, (RegionInfo)merged, parents));
        this.masterServices.getMasterFileSystem().getFileSystem().delete(parentbRef, false);
        Assert.assertTrue((boolean)CatalogJanitor.cleanMergeRegion((MasterServices)this.masterServices, (RegionInfo)merged, parents));
    }

    @Test
    public void testDontCleanMergeIfFileSystemException() throws IOException {
        TableDescriptor td = this.createTableDescriptorForCurrentMethod();
        RegionInfo merged = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
        RegionInfo parenta = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        RegionInfo parentb = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
        ArrayList<RegionInfo> parents = new ArrayList<RegionInfo>();
        parents.add(parenta);
        parents.add(parentb);
        Path rootdir = this.masterServices.getMasterFileSystem().getRootDir();
        Path tabledir = CommonFSUtils.getTableDir((Path)rootdir, (TableName)td.getTableName());
        Path storedir = HRegionFileSystem.getStoreHomedir((Path)tabledir, (RegionInfo)merged, (byte[])td.getColumnFamilies()[0].getName());
        this.createMergeReferenceFile(storedir, merged, parenta);
        MasterServices mockedMasterServices = (MasterServices)Mockito.spy((Object)this.masterServices);
        MasterFileSystem mockedMasterFileSystem = (MasterFileSystem)Mockito.spy((Object)this.masterServices.getMasterFileSystem());
        FileSystem mockedFileSystem = (FileSystem)Mockito.spy((Object)this.masterServices.getMasterFileSystem().getFileSystem());
        Mockito.when((Object)mockedMasterServices.getMasterFileSystem()).thenReturn((Object)mockedMasterFileSystem);
        Mockito.when((Object)mockedMasterFileSystem.getFileSystem()).thenReturn((Object)mockedFileSystem);
        ((FileSystem)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Some exception")}).when((Object)mockedFileSystem)).exists((Path)ArgumentMatchers.any());
        Assert.assertFalse((boolean)CatalogJanitor.cleanMergeRegion((MasterServices)mockedMasterServices, (RegionInfo)merged, parents));
        AtomicBoolean returned = new AtomicBoolean(false);
        ((FileSystem)Mockito.doAnswer(invocationOnMock -> {
            if (!returned.get()) {
                returned.set(true);
                return this.masterServices.getMasterFileSystem().getFileSystem().exists((Path)invocationOnMock.getArgument(0));
            }
            throw new IOException("Some exception");
        }).when((Object)mockedFileSystem)).exists((Path)ArgumentMatchers.any());
        Assert.assertFalse((boolean)CatalogJanitor.cleanMergeRegion((MasterServices)mockedMasterServices, (RegionInfo)merged, parents));
    }

    private Path createMergeReferenceFile(Path storeDir, RegionInfo mergedRegion, RegionInfo parentRegion) throws IOException {
        Reference ref = Reference.createTopReference((byte[])mergedRegion.getStartKey());
        long now = EnvironmentEdgeManager.currentTime();
        Path p = new Path(storeDir, Long.toString(now) + "." + parentRegion.getEncodedName());
        FileSystem fs = this.masterServices.getMasterFileSystem().getFileSystem();
        return ref.write(fs, p);
    }

    @Test
    public void testCleanParent() throws IOException, InterruptedException {
        TableDescriptor td = this.createTableDescriptorForCurrentMethod();
        RegionInfo parent = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
        RegionInfo splita = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        RegionInfo splitb = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
        Result r = this.createResult(parent, splita, splitb);
        Path rootdir = this.masterServices.getMasterFileSystem().getRootDir();
        Path tabledir = CommonFSUtils.getTableDir((Path)rootdir, (TableName)td.getTableName());
        Path parentdir = new Path(tabledir, parent.getEncodedName());
        Path storedir = HRegionFileSystem.getStoreHomedir((Path)tabledir, (RegionInfo)splita, (byte[])td.getColumnFamilies()[0].getName());
        Reference ref = Reference.createTopReference((byte[])Bytes.toBytes((String)"ccc"));
        long now = EnvironmentEdgeManager.currentTime();
        Path p = new Path(storedir, Long.toString(now) + "." + parent.getEncodedName());
        FileSystem fs = this.masterServices.getMasterFileSystem().getFileSystem();
        Path path = ref.write(fs, p);
        Assert.assertTrue((boolean)fs.exists(path));
        LOG.info("Created reference " + path);
        fs.mkdirs(parentdir);
        Assert.assertFalse((boolean)CatalogJanitor.cleanParent((MasterServices)this.masterServices, (RegionInfo)parent, (Result)r));
        ProcedureTestingUtility.waitAllProcedures(this.masterServices.getMasterProcedureExecutor());
        Assert.assertTrue((boolean)fs.exists(parentdir));
        Assert.assertTrue((boolean)fs.delete(p, true));
        Assert.assertTrue((boolean)CatalogJanitor.cleanParent((MasterServices)this.masterServices, (RegionInfo)parent, (Result)r));
        ProcedureTestingUtility.waitAllProcedures(this.masterServices.getMasterProcedureExecutor());
        Assert.assertTrue((!fs.exists(parentdir) ? 1 : 0) != 0);
    }

    @Test
    public void testParentCleanedEvenIfDaughterGoneFirst() throws IOException, InterruptedException {
        this.parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst(this.name.getMethodName(), Bytes.toBytes((String)"eee"));
    }

    @Test
    public void testLastParentCleanedEvenIfDaughterGoneFirst() throws IOException, InterruptedException {
        this.parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst(this.name.getMethodName(), new byte[0]);
    }

    private TableDescriptor createTableDescriptorForCurrentMethod() {
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"cf")).build();
        return TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(columnFamilyDescriptor).build();
    }

    private void parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst(String rootDir, byte[] lastEndKey) throws IOException, InterruptedException {
        TableDescriptor td = this.createTableDescriptorForCurrentMethod();
        RegionInfo parent = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), lastEndKey);
        Thread.sleep(1001L);
        RegionInfo splita = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        Thread.sleep(1001L);
        RegionInfo splitaa = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"));
        RegionInfo splitab = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"));
        RegionInfo splitb = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), lastEndKey);
        Thread.sleep(1001L);
        RegionInfo splitba = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"));
        RegionInfo splitbb = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"ddd"), lastEndKey);
        TreeMap<RegionInfo, Result> regions = new TreeMap<RegionInfo, Result>((Comparator<RegionInfo>)new CatalogJanitor.SplitParentFirstComparator());
        regions.put(parent, this.createResult(parent, splita, splitb));
        regions.put(splitb, this.createResult(splitb, splitba, splitbb));
        regions.put(splita, this.createResult(splita, splitaa, splitab));
        int index = 0;
        for (Map.Entry e : regions.entrySet()) {
            if (index == 0) {
                Assert.assertTrue((boolean)((RegionInfo)e.getKey()).getEncodedName().equals(parent.getEncodedName()));
            } else if (index == 1) {
                Assert.assertTrue((boolean)((RegionInfo)e.getKey()).getEncodedName().equals(splita.getEncodedName()));
            } else if (index == 2) {
                Assert.assertTrue((boolean)((RegionInfo)e.getKey()).getEncodedName().equals(splitb.getEncodedName()));
            }
            ++index;
        }
        Path splitaRef = this.createReferences(this.masterServices, td, parent, splita, Bytes.toBytes((String)"ccc"), false);
        Assert.assertFalse((boolean)CatalogJanitor.cleanParent((MasterServices)this.masterServices, (RegionInfo)parent, (Result)((Result)regions.get(parent))));
        Assert.assertTrue((boolean)CatalogJanitor.cleanParent((MasterServices)this.masterServices, (RegionInfo)splitb, (Result)((Result)regions.get(splitb))));
        FileSystem fs = FileSystem.get((Configuration)HTU.getConfiguration());
        Assert.assertTrue((boolean)fs.delete(splitaRef, true));
        Path splitaaRef = this.createReferences(this.masterServices, td, splita, splitaa, Bytes.toBytes((String)"bbb"), false);
        Path splitabRef = this.createReferences(this.masterServices, td, splita, splitab, Bytes.toBytes((String)"bbb"), true);
        Assert.assertFalse((boolean)CatalogJanitor.cleanParent((MasterServices)this.masterServices, (RegionInfo)splita, (Result)((Result)regions.get(splita))));
        Assert.assertTrue((boolean)fs.delete(splitaaRef, true));
        Assert.assertTrue((boolean)fs.delete(splitabRef, true));
        Assert.assertTrue((boolean)CatalogJanitor.cleanParent((MasterServices)this.masterServices, (RegionInfo)splita, (Result)((Result)regions.get(splita))));
        Assert.assertTrue((boolean)CatalogJanitor.cleanParent((MasterServices)this.masterServices, (RegionInfo)parent, (Result)((Result)regions.get(parent))));
    }

    @Test
    public void testScanDoesNotCleanRegionsWithExistingParents() throws Exception {
        TableDescriptor td = this.createTableDescriptorForCurrentMethod();
        RegionInfo parent = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), HConstants.EMPTY_BYTE_ARRAY, true);
        Thread.sleep(1001L);
        RegionInfo splita = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"), true);
        Thread.sleep(1001L);
        RegionInfo splitaa = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"), false);
        RegionInfo splitab = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), false);
        RegionInfo splitb = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), HConstants.EMPTY_BYTE_ARRAY);
        Thread.sleep(1001L);
        TreeMap<RegionInfo, Result> splitParents = new TreeMap<RegionInfo, Result>((Comparator<RegionInfo>)new CatalogJanitor.SplitParentFirstComparator());
        splitParents.put(parent, this.createResult(parent, splita, splitb));
        splita = RegionInfoBuilder.newBuilder((RegionInfo)splita).setOffline(true).build();
        splitParents.put(splita, this.createResult(splita, splitaa, splitab));
        TreeMap mergedRegions = new TreeMap();
        CatalogJanitor spy = (CatalogJanitor)Mockito.spy((Object)this.janitor);
        CatalogJanitorReport report = new CatalogJanitorReport();
        report.count = 10;
        report.mergedRegions.putAll(mergedRegions);
        report.splitParents.putAll(splitParents);
        ((CatalogJanitor)Mockito.doReturn((Object)report).when((Object)spy)).scanForReport();
        LOG.info("parent=" + parent.getShortNameToLog() + ", splita=" + splita.getShortNameToLog());
        Path splitaRef = this.createReferences(this.masterServices, td, parent, splita, Bytes.toBytes((String)"ccc"), false);
        LOG.info("Created reference " + splitaRef);
        int gcs = spy.scan();
        Assert.assertEquals((long)0L, (long)gcs);
        FileSystem fs = FileSystem.get((Configuration)HTU.getConfiguration());
        Assert.assertTrue((boolean)fs.delete(splitaRef, true));
        gcs = spy.scan();
        Assert.assertEquals((long)2L, (long)gcs);
    }

    @Test
    public void testSplitParentFirstComparator() {
        CatalogJanitor.SplitParentFirstComparator comp = new CatalogJanitor.SplitParentFirstComparator();
        TableDescriptor td = this.createTableDescriptorForCurrentMethod();
        RegionInfo rootRegion = this.createRegionInfo(td.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, true);
        RegionInfo firstRegion = this.createRegionInfo(td.getTableName(), HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"bbb"), true);
        RegionInfo lastRegion = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"bbb"), HConstants.EMPTY_END_ROW, true);
        Assert.assertTrue((comp.compare(rootRegion, rootRegion) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegion, firstRegion) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegion, lastRegion) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, firstRegion) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, lastRegion) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegion, lastRegion) < 0 ? 1 : 0) != 0);
        RegionInfo firstRegiona = this.createRegionInfo(td.getTableName(), HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"aaa"), true);
        RegionInfo firstRegionb = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"), true);
        RegionInfo lastRegiona = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ddd"), true);
        RegionInfo lastRegionb = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"ddd"), HConstants.EMPTY_END_ROW, true);
        Assert.assertTrue((comp.compare(firstRegiona, firstRegiona) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegionb, firstRegionb) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, firstRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, firstRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegion, firstRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegion, firstRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegiona, firstRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegiona, lastRegiona) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegionb, lastRegionb) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegion, lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegion, lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegiona, lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegiona, lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegiona, lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegionb, lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegionb, lastRegionb) < 0 ? 1 : 0) != 0);
        RegionInfo lastRegionaa = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), false);
        RegionInfo lastRegionab = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), false);
        Assert.assertTrue((comp.compare(lastRegiona, lastRegionaa) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegiona, lastRegionab) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegionaa, lastRegionab) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testArchiveOldRegion() throws Exception {
        TableDescriptor td = this.createTableDescriptorForCurrentMethod();
        RegionInfo parent = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
        RegionInfo splita = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        RegionInfo splitb = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
        Result parentMetaRow = this.createResult(parent, splita, splitb);
        FileSystem fs = FileSystem.get((Configuration)HTU.getConfiguration());
        Path rootdir = this.masterServices.getMasterFileSystem().getRootDir();
        CommonFSUtils.setRootDir((Configuration)fs.getConf(), (Path)rootdir);
        Path tabledir = CommonFSUtils.getTableDir((Path)rootdir, (TableName)td.getTableName());
        Path storedir = HRegionFileSystem.getStoreHomedir((Path)tabledir, (RegionInfo)parent, (byte[])td.getColumnFamilies()[0].getName());
        Path storeArchive = HFileArchiveUtil.getStoreArchivePath((Configuration)this.masterServices.getConfiguration(), (RegionInfo)parent, (Path)tabledir, (byte[])td.getColumnFamilies()[0].getName());
        LOG.debug("Table dir:" + tabledir);
        LOG.debug("Store dir:" + storedir);
        LOG.debug("Store archive dir:" + storeArchive);
        FileStatus[] mockFiles = this.addMockStoreFiles(2, this.masterServices, storedir);
        FileStatus[] storeFiles = fs.listStatus(storedir);
        int index = 0;
        for (FileStatus file : storeFiles) {
            LOG.debug("Have store file:" + file.getPath());
            Assert.assertEquals((String)"Got unexpected store file", (Object)mockFiles[index].getPath(), (Object)storeFiles[index].getPath());
            ++index;
        }
        Assert.assertTrue((boolean)CatalogJanitor.cleanParent((MasterServices)this.masterServices, (RegionInfo)parent, (Result)parentMetaRow));
        Path parentDir = new Path(tabledir, parent.getEncodedName());
        ProcedureTestingUtility.waitAllProcedures(this.masterServices.getMasterProcedureExecutor());
        Assert.assertTrue((!fs.exists(parentDir) ? 1 : 0) != 0);
        LOG.debug("Finished cleanup of parent region");
        FileStatus[] archivedStoreFiles = fs.listStatus(storeArchive);
        this.logFiles("archived files", storeFiles);
        this.logFiles("archived files", archivedStoreFiles);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs);
        CommonFSUtils.delete((FileSystem)fs, (Path)rootdir, (boolean)true);
    }

    private void logFiles(String description, FileStatus[] storeFiles) {
        LOG.debug("Current " + description + ": ");
        for (FileStatus file : storeFiles) {
            LOG.debug(Objects.toString(file.getPath()));
        }
    }

    @Test
    public void testDuplicateHFileResolution() throws Exception {
        TableDescriptor td = this.createTableDescriptorForCurrentMethod();
        RegionInfo parent = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
        RegionInfo splita = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        RegionInfo splitb = this.createRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
        Result r = this.createResult(parent, splita, splitb);
        FileSystem fs = FileSystem.get((Configuration)HTU.getConfiguration());
        Path rootdir = this.masterServices.getMasterFileSystem().getRootDir();
        CommonFSUtils.setRootDir((Configuration)fs.getConf(), (Path)rootdir);
        Path tabledir = CommonFSUtils.getTableDir((Path)rootdir, (TableName)parent.getTable());
        Path storedir = HRegionFileSystem.getStoreHomedir((Path)tabledir, (RegionInfo)parent, (byte[])td.getColumnFamilies()[0].getName());
        LOG.info("Old root:" + rootdir);
        LOG.info("Old table:" + tabledir);
        LOG.info("Old store:" + storedir);
        Path storeArchive = HFileArchiveUtil.getStoreArchivePath((Configuration)this.masterServices.getConfiguration(), (RegionInfo)parent, (Path)tabledir, (byte[])td.getColumnFamilies()[0].getName());
        LOG.info("Old archive:" + storeArchive);
        this.addMockStoreFiles(2, this.masterServices, storedir);
        FileStatus[] storeFiles = fs.listStatus(storedir);
        Assert.assertTrue((boolean)CatalogJanitor.cleanParent((MasterServices)this.masterServices, (RegionInfo)parent, (Result)r));
        Path parentDir = new Path(tabledir, parent.getEncodedName());
        ProcedureTestingUtility.waitAllProcedures(this.masterServices.getMasterProcedureExecutor());
        Assert.assertTrue((!fs.exists(parentDir) ? 1 : 0) != 0);
        FileStatus[] archivedStoreFiles = fs.listStatus(storeArchive);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs);
        this.addMockStoreFiles(2, this.masterServices, storedir);
        Assert.assertTrue((boolean)CatalogJanitor.cleanParent((MasterServices)this.masterServices, (RegionInfo)parent, (Result)r));
        ProcedureTestingUtility.waitAllProcedures(this.masterServices.getMasterProcedureExecutor());
        Assert.assertTrue((!fs.exists(parentDir) ? 1 : 0) != 0);
        archivedStoreFiles = fs.listStatus(storeArchive);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs, true);
    }

    @Test
    public void testAlreadyRunningStatus() throws Exception {
        int i;
        int numberOfThreads = 2;
        ArrayList gcValues = new ArrayList();
        Thread[] threads = new Thread[numberOfThreads];
        for (i = 0; i < numberOfThreads; ++i) {
            threads[i] = new Thread(() -> {
                try {
                    gcValues.add(this.janitor.scan());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        for (i = 0; i < numberOfThreads; ++i) {
            threads[i].start();
        }
        for (i = 0; i < numberOfThreads; ++i) {
            threads[i].join();
        }
        Assert.assertTrue((String)"One janitor.scan() call should have returned -1", (boolean)gcValues.contains(-1));
    }

    private FileStatus[] addMockStoreFiles(int count, MasterServices services, Path storedir) throws IOException {
        FileSystem fs = services.getMasterFileSystem().getFileSystem();
        fs.mkdirs(storedir);
        for (int i = 0; i < count; ++i) {
            Path storeFile = new Path(storedir, "_store" + i);
            FSDataOutputStream dos = fs.create(storeFile, true);
            dos.writeBytes("Some data: " + i);
            dos.close();
        }
        LOG.debug("Adding " + count + " store files to the storedir:" + storedir);
        FileStatus[] storeFiles = fs.listStatus(storedir);
        Assert.assertEquals((String)"Didn't have expected store files", (long)count, (long)storeFiles.length);
        return storeFiles;
    }

    private String setRootDirAndCleanIt(HBaseTestingUtil htu, String subdir) throws IOException {
        Path testdir = htu.getDataTestDir(subdir);
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        if (fs.exists(testdir)) {
            Assert.assertTrue((boolean)fs.delete(testdir, true));
        }
        CommonFSUtils.setRootDir((Configuration)htu.getConfiguration(), (Path)testdir);
        return CommonFSUtils.getRootDir((Configuration)htu.getConfiguration()).toString();
    }

    private Path createReferences(MasterServices services, TableDescriptor td, RegionInfo parent, RegionInfo daughter, byte[] midkey, boolean top) throws IOException {
        Path rootdir = services.getMasterFileSystem().getRootDir();
        Path tabledir = CommonFSUtils.getTableDir((Path)rootdir, (TableName)parent.getTable());
        Path storedir = HRegionFileSystem.getStoreHomedir((Path)tabledir, (RegionInfo)daughter, (byte[])td.getColumnFamilies()[0].getName());
        Reference ref = top ? Reference.createTopReference((byte[])midkey) : Reference.createBottomReference((byte[])midkey);
        long now = EnvironmentEdgeManager.currentTime();
        Path p = new Path(storedir, Long.toString(now) + "." + parent.getEncodedName());
        FileSystem fs = services.getMasterFileSystem().getFileSystem();
        ref.write(fs, p);
        return p;
    }

    private Result createResult(RegionInfo parent, RegionInfo a, RegionInfo b) throws IOException {
        return MetaMockingUtil.getMetaTableRowResult(parent, null, a, b);
    }
}

