/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManagerUtil;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestAssignmentManagerUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAssignmentManagerUtil.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static TableName TABLE_NAME = TableName.valueOf((String)"AM");
    private static MasterProcedureEnv ENV;
    private static AssignmentManager AM;
    private static int REGION_REPLICATION;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        UTIL.getAdmin().balancerSwitch(false, true);
        UTIL.createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"cf")).setRegionReplication(REGION_REPLICATION).build(), (byte[][])new byte[][]{Bytes.toBytes((int)0)});
        UTIL.waitTableAvailable(TABLE_NAME);
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        ENV = (MasterProcedureEnv)master.getMasterProcedureExecutor().getEnvironment();
        AM = master.getAssignmentManager();
    }

    @After
    public void tearDownAfterTest() throws IOException {
        for (RegionInfo region : UTIL.getAdmin().getRegions(TABLE_NAME)) {
            RegionStateNode regionNode = AM.getRegionStates().getRegionStateNode(region);
            Assert.assertFalse((boolean)regionNode.isLocked());
            TransitRegionStateProcedure proc = regionNode.getProcedure();
            if (proc == null) continue;
            regionNode.unsetProcedure(proc);
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private List<RegionInfo> getPrimaryRegions() throws IOException {
        return UTIL.getAdmin().getRegions(TABLE_NAME).stream().filter(r -> RegionReplicaUtil.isDefaultReplica((RegionInfo)r)).collect(Collectors.toList());
    }

    @Test
    public void testCreateUnassignProcedureForSplitFail() throws IOException {
        RegionInfo region = this.getPrimaryRegions().get(0);
        AM.getRegionStates().getRegionStateNode(region).setProcedure(TransitRegionStateProcedure.unassign((MasterProcedureEnv)ENV, (RegionInfo)region));
        try {
            AssignmentManagerUtil.createUnassignProceduresForSplitOrMerge((MasterProcedureEnv)ENV, Stream.of(region), (int)REGION_REPLICATION);
            Assert.fail((String)"Should fail as the region is in transition");
        }
        catch (HBaseIOException hBaseIOException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateUnassignProceduresForMergeFail() throws IOException {
        List<RegionInfo> regions = this.getPrimaryRegions();
        RegionInfo regionA = regions.get(0);
        RegionInfo regionB = regions.get(1);
        AM.getRegionStates().getRegionStateNode(regionB).setProcedure(TransitRegionStateProcedure.unassign((MasterProcedureEnv)ENV, (RegionInfo)regionB));
        try {
            AssignmentManagerUtil.createUnassignProceduresForSplitOrMerge((MasterProcedureEnv)ENV, Stream.of(regionA, regionB), (int)REGION_REPLICATION);
            Assert.fail((String)"Should fail as the region is in transition");
        }
        catch (HBaseIOException hBaseIOException) {
        }
        IntStream.range(0, REGION_REPLICATION).mapToObj(i -> RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)regionA, (int)i)).map(arg_0 -> ((RegionStates)AM.getRegionStates()).getRegionStateNode(arg_0)).forEachOrdered(rn -> Assert.assertFalse((String)("Should have unset the proc for " + rn), (boolean)rn.isInTransition()));
    }

    static {
        REGION_REPLICATION = 3;
    }
}

