/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.DummyRegionProcedure;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestServerCrashProcedureCarryingMetaStuck {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestServerCrashProcedureCarryingMetaStuck.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(3);
        UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        JVMClusterUtil.RegionServerThread rsThread = null;
        for (JVMClusterUtil.RegionServerThread t : UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            if (t.getRegionServer().getRegions(TableName.META_TABLE_NAME).isEmpty()) continue;
            rsThread = t;
            break;
        }
        HRegionServer rs = rsThread.getRegionServer();
        RegionInfo hri = ((HRegion)rs.getRegions(TableName.META_TABLE_NAME).get(0)).getRegionInfo();
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        ProcedureExecutor executor = master.getMasterProcedureExecutor();
        DummyRegionProcedure proc = new DummyRegionProcedure((MasterProcedureEnv)executor.getEnvironment(), hri);
        long procId = master.getMasterProcedureExecutor().submitProcedure((Procedure)proc);
        proc.waitUntilArrive();
        try (AsyncConnection conn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();){
            AsyncAdmin admin = conn.getAdmin();
            CompletableFuture future = admin.move(hri.getRegionName());
            rs.abort("For testing!");
            UTIL.waitFor(30000L, () -> executor.getProcedures().stream().filter(p -> p instanceof TransitRegionStateProcedure).map(p -> (TransitRegionStateProcedure)p).anyMatch(p -> Bytes.equals((byte[])hri.getRegionName(), (byte[])p.getRegion().getRegionName())));
            proc.resume();
            UTIL.waitFor(30000L, () -> executor.isFinished(procId));
            future.get(30L, TimeUnit.SECONDS);
        }
    }
}

