/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestRegionPlansWithThrottle {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionPlansWithThrottle.class);
    private static HMaster hMaster;
    private static final HBaseTestingUtil UTIL;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(StartTestingClusterOption.builder().numRegionServers(2).build());
        hMaster = UTIL.getMiniHBaseCluster().getMaster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testExecuteRegionPlansWithThrottling() throws Exception {
        Object q;
        TableName tableName = TableName.valueOf((String)"testExecuteRegionPlansWithThrottling");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])Bytes.toBytes((String)"cf"))).build();
        UTIL.getAdmin().createTable(tableDescriptor);
        Table table = UTIL.getConnection().getTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 100; ++i) {
            Put put = new Put(Bytes.toBytes((String)("row" + i)));
            q = Bytes.toBytes((String)"q1");
            byte[] v = Bytes.toBytes((String)("v" + i));
            put.addColumn(Bytes.toBytes((String)"cf"), (byte[])q, v);
            puts.add(put);
        }
        table.put(puts);
        UTIL.getAdmin().flush(tableName);
        UTIL.getAdmin().split(tableName, Bytes.toBytes((String)"v5"));
        ArrayList<RegionPlan> plans = new ArrayList<RegionPlan>();
        List regionInfos = UTIL.getAdmin().getRegions(tableName);
        q = regionInfos.iterator();
        while (q.hasNext()) {
            RegionInfo regionInfo = (RegionInfo)q.next();
            plans.add(new RegionPlan(regionInfo, UTIL.getHBaseCluster().getRegionServer(0).getServerName(), UTIL.getHBaseCluster().getRegionServer(1).getServerName()));
        }
        List successPlans = hMaster.executeRegionPlansWithThrottling(plans);
        Assert.assertEquals((long)regionInfos.size(), (long)successPlans.size());
    }

    static {
        UTIL = new HBaseTestingUtil();
    }
}

