/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.CatalogFamilyFormat;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.zookeeper.ZKMetadata;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMigrateAndMirrorMetaLocations {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMigrateAndMirrorMetaLocations.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(3);
        HBaseTestingUtil.setReplicas(UTIL.getAdmin(), TableName.META_TABLE_NAME, 2);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.shutdownMiniCluster();
    }

    private void assertLocationEquals(Result result, int replicaCount) throws Exception {
        RegionLocations locs = CatalogFamilyFormat.getRegionLocations((Result)result);
        Assert.assertEquals((long)replicaCount, (long)locs.size());
        for (int i = 0; i < replicaCount; ++i) {
            String znode = UTIL.getZooKeeperWatcher().getZNodePaths().getZNodeForReplica(i);
            byte[] data = ZKUtil.getData((ZKWatcher)UTIL.getZooKeeperWatcher(), (String)znode);
            data = ZKMetadata.removeMetaData((byte[])data);
            int prefixLen = ProtobufUtil.lengthOfPBMagic();
            ZooKeeperProtos.MetaRegionServer zkProto = (ZooKeeperProtos.MetaRegionServer)ZooKeeperProtos.MetaRegionServer.parser().parseFrom(data, prefixLen, data.length - prefixLen);
            ServerName sn = ProtobufUtil.toServerName((HBaseProtos.ServerName)zkProto.getServer());
            Assert.assertEquals((Object)locs.getRegionLocation(i).getServerName(), (Object)sn);
        }
        Assert.assertEquals((long)replicaCount, (long)UTIL.getZooKeeperWatcher().getMetaReplicaNodes().size());
    }

    private void checkMirrorLocation(int replicaCount) throws Exception {
        MasterRegion masterRegion = UTIL.getMiniHBaseCluster().getMaster().getMasterRegion();
        try (RegionScanner scanner = masterRegion.getRegionScanner(new Scan().addFamily(HConstants.CATALOG_FAMILY));){
            ArrayList cells = new ArrayList();
            boolean moreRows = scanner.next(cells);
            Assert.assertFalse((boolean)moreRows);
            Assert.assertFalse((boolean)cells.isEmpty());
            Result result = Result.create(cells);
            this.assertLocationEquals(result, replicaCount);
        }
    }

    private void waitUntilNoSCP() throws IOException {
        UTIL.waitFor(30000L, () -> UTIL.getMiniHBaseCluster().getMaster().getProcedures().stream().filter(p -> p instanceof ServerCrashProcedure).allMatch(Procedure::isSuccess));
    }

    @Test
    public void test() throws Exception {
        ArrayList cells;
        this.checkMirrorLocation(2);
        MasterRegion masterRegion = UTIL.getMiniHBaseCluster().getMaster().getMasterRegion();
        try (RegionScanner scanner = masterRegion.getRegionScanner(new Scan().addFamily(HConstants.CATALOG_FAMILY));){
            cells = new ArrayList();
            scanner.next(cells);
            Cell cell = (Cell)cells.get(0);
            masterRegion.update(r -> r.delete(new Delete(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength()).addFamily(HConstants.CATALOG_FAMILY)));
            masterRegion.flush(true);
        }
        UTIL.shutdownMiniHBaseCluster();
        UTIL.startMiniHBaseCluster(StartTestingClusterOption.builder().numRegionServers(3).build());
        masterRegion = UTIL.getMiniHBaseCluster().getMaster().getMasterRegion();
        scanner = masterRegion.getRegionScanner(new Scan().addFamily(HConstants.CATALOG_FAMILY));
        var3_3 = null;
        try {
            cells = new ArrayList();
            boolean moreRows = scanner.next(cells);
            Assert.assertFalse((boolean)moreRows);
            Assert.assertFalse((boolean)cells.isEmpty());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (scanner != null) {
                if (var3_3 != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    scanner.close();
                }
            }
        }
        UTIL.waitFor(30000L, () -> UTIL.getMiniHBaseCluster().getRegions(TableName.META_TABLE_NAME).size() == 2);
        this.waitUntilNoSCP();
        this.checkMirrorLocation(2);
        HBaseTestingUtil.setReplicas(UTIL.getAdmin(), TableName.META_TABLE_NAME, 3);
        this.checkMirrorLocation(3);
        byte[] replica2Data = ZKUtil.getData((ZKWatcher)UTIL.getZooKeeperWatcher(), (String)UTIL.getZooKeeperWatcher().getZNodePaths().getZNodeForReplica(2));
        HBaseTestingUtil.setReplicas(UTIL.getAdmin(), TableName.META_TABLE_NAME, 1);
        this.checkMirrorLocation(1);
        UTIL.shutdownMiniHBaseCluster();
        ZKUtil.createAndFailSilent((ZKWatcher)UTIL.getZooKeeperWatcher(), (String)UTIL.getZooKeeperWatcher().getZNodePaths().getZNodeForReplica(2), (byte[])replica2Data);
        UTIL.startMiniHBaseCluster(StartTestingClusterOption.builder().numRegionServers(3).build());
        Assert.assertEquals((long)1L, (long)UTIL.getZooKeeperWatcher().getMetaReplicaNodes().size());
        this.waitUntilNoSCP();
        this.checkMirrorLocation(1);
    }
}

