/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestMetaAssignmentWithStopMaster {
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaAssignmentWithStopMaster.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaAssignmentWithStopMaster.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static final long WAIT_TIMEOUT = 120000L;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        StartTestingClusterOption option = StartTestingClusterOption.builder().numMasters(2).numRegionServers(3).numDataNodes(3).build();
        UTIL.startMiniCluster(option);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testStopActiveMaster() throws Exception {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
             RegionLocator locator = conn.getRegionLocator(TableName.META_TABLE_NAME);){
            ServerName oldMetaServer = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getServerName();
            ServerName oldMaster = UTIL.getMiniHBaseCluster().getMaster().getServerName();
            UTIL.getMiniHBaseCluster().getMaster().stop("Stop master for test");
            long startTime = EnvironmentEdgeManager.currentTime();
            while (UTIL.getMiniHBaseCluster().getMaster() == null || UTIL.getMiniHBaseCluster().getMaster().getServerName().equals((Object)oldMaster)) {
                LOG.info("Wait the standby master become active");
                Thread.sleep(3000L);
                if (EnvironmentEdgeManager.currentTime() - startTime <= 120000L) continue;
                Assert.fail((String)"Wait too long for standby master become active");
            }
            startTime = EnvironmentEdgeManager.currentTime();
            while (!UTIL.getMiniHBaseCluster().getMaster().isInitialized()) {
                LOG.info("Wait the new active master to be initialized");
                Thread.sleep(3000L);
                if (EnvironmentEdgeManager.currentTime() - startTime <= 120000L) continue;
                Assert.fail((String)"Wait too long for the new active master to be initialized");
            }
            ServerName newMetaServer = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getServerName();
            Assert.assertTrue((String)("The new meta server " + newMetaServer + " should be same with the old meta server " + oldMetaServer), (boolean)newMetaServer.equals((Object)oldMetaServer));
        }
    }
}

