/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.assignment.MergeTableRegionsProcedure;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMergeTableRegionsWhileRSCrash {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMergeTableRegionsWhileRSCrash.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMergeTableRegionsWhileRSCrash.class);
    protected static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static Admin admin;
    private static byte[] CF;
    private static byte[] SPLITKEY;
    private static CountDownLatch mergeCommitArrive;
    private static Table TABLE;

    @BeforeClass
    public static void setupCluster() throws Exception {
        UTIL.startMiniCluster(1);
        admin = UTIL.getAdmin();
        byte[][] splitKeys = new byte[][]{SPLITKEY};
        TABLE = UTIL.createTable(TABLE_NAME, CF, (byte[][])splitKeys);
        UTIL.waitTableAvailable(TABLE_NAME);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Test
    public void test() throws Exception {
        for (int i = 0; i < 10; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Put put = new Put(row);
            put.addColumn(CF, CF, CF);
            TABLE.put(put);
        }
        MasterProcedureEnv env = (MasterProcedureEnv)UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment();
        ProcedureExecutor executor = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        List regionInfos = admin.getRegions(TABLE_NAME);
        MergeTableRegionsProcedure mergeTableRegionsProcedure = new MergeTableRegionsProcedure(env, new RegionInfo[]{(RegionInfo)regionInfos.get(0), (RegionInfo)regionInfos.get(1)}, false);
        executor.submitProcedure((Procedure)mergeTableRegionsProcedure);
        UTIL.waitFor(30000L, () -> executor.getProcedures().stream().filter(p -> p instanceof TransitRegionStateProcedure).map(p -> (TransitRegionStateProcedure)p).anyMatch(p -> TABLE_NAME.equals((Object)p.getTableName())));
        UTIL.getMiniHBaseCluster().killRegionServer(UTIL.getMiniHBaseCluster().getRegionServer(0).getServerName());
        UTIL.getMiniHBaseCluster().startRegionServer();
        UTIL.waitUntilNoRegionsInTransition();
        Scan scan = new Scan();
        ResultScanner results = TABLE.getScanner(scan);
        int count = 0;
        Result result = null;
        while ((result = results.next()) != null) {
            ++count;
        }
        Assert.assertEquals((String)"There should be 10 rows!", (long)10L, (long)count);
    }

    static {
        CF = Bytes.toBytes((String)"cf");
        SPLITKEY = Bytes.toBytes((String)"row5");
        mergeCommitArrive = new CountDownLatch(1);
    }
}

