/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.ipc.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.ipc.QosTestBase;
import org.apache.hadoop.hbase.master.MasterAnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, SmallTests.class})
public class TestMasterQosFunction
extends QosTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterQosFunction.class);
    private Configuration conf;
    private MasterRpcServices rpcServices;
    private MasterAnnotationReadingPriorityFunction qosFunction;

    @Before
    public void setUp() {
        this.conf = HBaseConfiguration.create();
        this.rpcServices = (MasterRpcServices)Mockito.mock(MasterRpcServices.class);
        Mockito.when((Object)this.rpcServices.getConfiguration()).thenReturn((Object)this.conf);
        this.qosFunction = new MasterAnnotationReadingPriorityFunction(this.rpcServices);
    }

    @Test
    public void testRegionInTransition() throws IOException {
        HBaseProtos.RegionInfo meta_ri = ProtobufUtil.toRegionInfo((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO);
        HBaseProtos.RegionInfo normal_ri = ProtobufUtil.toRegionInfo((RegionInfo)RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"test:table")).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"b")).build());
        RegionServerStatusProtos.RegionStateTransition metaTransition = RegionServerStatusProtos.RegionStateTransition.newBuilder().addRegionInfo(meta_ri).setTransitionCode(RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED).build();
        RegionServerStatusProtos.RegionStateTransition normalTransition = RegionServerStatusProtos.RegionStateTransition.newBuilder().addRegionInfo(normal_ri).setTransitionCode(RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED).build();
        RegionServerStatusProtos.ReportRegionStateTransitionRequest metaTransitionRequest = RegionServerStatusProtos.ReportRegionStateTransitionRequest.newBuilder().setServer(ProtobufUtil.toServerName((ServerName)ServerName.valueOf((String)"locahost:60020", (long)100L))).addTransition(normalTransition).addTransition(metaTransition).build();
        RegionServerStatusProtos.ReportRegionStateTransitionRequest normalTransitionRequest = RegionServerStatusProtos.ReportRegionStateTransitionRequest.newBuilder().setServer(ProtobufUtil.toServerName((ServerName)ServerName.valueOf((String)"locahost:60020", (long)100L))).addTransition(normalTransition).build();
        String reportFuncName = "ReportRegionStateTransition";
        this.checkMethod(this.conf, "ReportRegionStateTransition", 300, (AnnotationReadingPriorityFunction<?>)this.qosFunction, (Message)metaTransitionRequest);
        this.checkMethod(this.conf, "ReportRegionStateTransition", 200, (AnnotationReadingPriorityFunction<?>)this.qosFunction, (Message)normalTransitionRequest);
    }

    @Test
    public void testAnnotations() {
        this.checkMethod(this.conf, "GetLastFlushedSequenceId", 100, (AnnotationReadingPriorityFunction<?>)this.qosFunction);
    }
}

