/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.HBaseZKTestingUtil;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.cleaner.DirScanPool;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.master.region.MasterRegionFactory;
import org.apache.hadoop.hbase.master.region.MasterRegionParams;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.mockito.Mockito;

public abstract class MasterStateStoreTestBase {
    protected static HBaseZKTestingUtil UTIL = new HBaseZKTestingUtil();
    protected static MasterRegion REGION;
    protected static ChoreService CHORE_SERVICE;
    protected static DirScanPool HFILE_CLEANER_POOL;
    protected static DirScanPool LOG_CLEANER_POOL;
    protected static TableDescriptor TD;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setBoolean("hbase.hregion.memstore.mslab.enabled", false);
        conf.setBoolean("hbase.unsafe.stream.capability.enforce", false);
        CHORE_SERVICE = new ChoreService("TestMasterStateStore");
        HFILE_CLEANER_POOL = DirScanPool.getHFileCleanerScanPool((Configuration)conf);
        LOG_CLEANER_POOL = DirScanPool.getLogCleanerScanPool((Configuration)conf);
        Server server = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)server.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)server.getServerName()).thenReturn((Object)ServerName.valueOf((String)"localhost", (int)12345, (long)EnvironmentEdgeManager.currentTime()));
        Mockito.when((Object)server.getChoreService()).thenReturn((Object)CHORE_SERVICE);
        Path testDir = UTIL.getDataTestDir();
        CommonFSUtils.setRootDir((Configuration)conf, (Path)testDir);
        MasterRegionParams params = new MasterRegionParams();
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableDescriptor)TD).setValue("hbase.store.file-tracker.impl", conf.get("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.DEFAULT.name())).build();
        params.server(server).regionDirName("local").tableDescriptor(td).flushSize(0x8000000L).flushPerChanges(1000000L).flushIntervalMs(TimeUnit.MINUTES.toMillis(15L)).compactMin(4).maxWals(32).useHsync(false).ringBufferSlotCount(16).rollPeriodMs(TimeUnit.MINUTES.toMillis(15L)).archivedWalSuffix("$masterlocalwal$").archivedHFileSuffix("$-masterlocalhfile-$");
        REGION = MasterRegion.create((MasterRegionParams)params);
        UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        REGION.close(true);
        HFILE_CLEANER_POOL.shutdownNow();
        LOG_CLEANER_POOL.shutdownNow();
        CHORE_SERVICE.shutdown();
        UTIL.shutdownMiniZKCluster();
        UTIL.cleanupTestDir();
    }

    protected static void cleanup() throws IOException {
        try (ResultScanner scanner = REGION.getScanner(new Scan());){
            Result result;
            while ((result = scanner.next()) != null) {
                REGION.update(r -> r.delete(new Delete(result.getRow())));
            }
        }
    }

    static {
        TD = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"test:local")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])MasterRegionFactory.STATE_FAMILY)).build();
    }
}

