/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestRestartCluster {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestRestartCluster.class);
    protected HBaseTestingUtil UTIL = new HBaseTestingUtil();
    protected static final TableName[] TABLES = new TableName[]{TableName.valueOf((String)"restartTableOne"), TableName.valueOf((String)"restartTableTwo"), TableName.valueOf((String)"restartTableThree")};
    protected static final byte[] FAMILY = Bytes.toBytes((String)"family");

    protected abstract boolean splitWALCoordinatedByZk();

    @Before
    public void setUp() {
        boolean splitWALCoordinatedByZk = this.splitWALCoordinatedByZk();
        LOG.info("WAL splitting coordinated by zk {}", (Object)splitWALCoordinatedByZk);
        this.UTIL.getConfiguration().setBoolean("hbase.split.wal.zk.coordinated", splitWALCoordinatedByZk);
    }

    @After
    public void tearDown() throws Exception {
        this.UTIL.shutdownMiniCluster();
    }
}

