/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestOpenTableInCoprocessor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOpenTableInCoprocessor.class);
    private static final TableName otherTable = TableName.valueOf((String)"otherTable");
    private static final TableName primaryTable = TableName.valueOf((String)"primary");
    private static final byte[] family = new byte[]{102};
    private static boolean[] completed = new boolean[1];
    private static boolean[] completedWithPool = new boolean[1];
    private static HBaseTestingUtil UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void setupCluster() throws Exception {
        UTIL.startMiniCluster();
    }

    @After
    public void cleanupTestTable() throws Exception {
        UTIL.getAdmin().disableTable(primaryTable);
        UTIL.getAdmin().deleteTable(primaryTable);
        UTIL.getAdmin().disableTable(otherTable);
        UTIL.getAdmin().deleteTable(otherTable);
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCoprocessorCanCreateConnectionToRemoteTable() throws Throwable {
        this.runCoprocessorConnectionToRemoteTable(SendToOtherTableCoprocessor.class, completed);
    }

    @Test
    public void testCoprocessorCanCreateConnectionToRemoteTableWithCustomPool() throws Throwable {
        this.runCoprocessorConnectionToRemoteTable(CustomThreadPoolCoprocessor.class, completedWithPool);
    }

    private void runCoprocessorConnectionToRemoteTable(Class<?> clazz, boolean[] completeCheck) throws Throwable {
        assert (RegionObserver.class.isAssignableFrom(clazz));
        TableDescriptor primaryDescriptor = TableDescriptorBuilder.newBuilder((TableName)primaryTable).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).setCoprocessor(clazz.getName()).build();
        TableDescriptor otherDescriptor = TableDescriptorBuilder.newBuilder((TableName)otherTable).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
        Admin admin = UTIL.getAdmin();
        admin.createTable(primaryDescriptor);
        admin.createTable(otherDescriptor);
        Table table = UTIL.getConnection().getTable(TableName.valueOf((String)"primary"));
        Put p = new Put(new byte[]{97});
        p.addColumn(family, null, new byte[]{97});
        table.put(p);
        table.close();
        Table target = UTIL.getConnection().getTable(otherTable);
        Assert.assertTrue((String)"Didn't complete update to target table!", (boolean)completeCheck[0]);
        Assert.assertEquals((String)"Didn't find inserted row", (long)1L, (long)this.getKeyValueCount(target));
        target.close();
    }

    private int getKeyValueCount(Table table) throws IOException {
        Scan scan = new Scan();
        scan.readVersions(0x7FFFFFFE);
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            System.out.println((count += res.listCells().size()) + ") " + res);
        }
        results.close();
        return count;
    }

    public static class CustomThreadPoolCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        private ExecutorService getPool() {
            int maxThreads = 1;
            long keepAliveTime = 60L;
            ThreadPoolExecutor pool = new ThreadPoolExecutor(1, maxThreads, keepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("hbase-table-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
            pool.allowCoreThreadTimeOut(true);
            return pool;
        }

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            try (Table table = ((RegionCoprocessorEnvironment)e.getEnvironment()).getConnection().getTable(otherTable, this.getPool());){
                Put p = new Put(new byte[]{97});
                p.addColumn(family, null, new byte[]{97});
                try {
                    table.batch(Collections.singletonList(put), null);
                }
                catch (InterruptedException e1) {
                    throw new IOException(e1);
                }
                completedWithPool[0] = true;
            }
        }
    }

    public static class SendToOtherTableCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            try (Table table = ((RegionCoprocessorEnvironment)e.getEnvironment()).getConnection().getTable(otherTable);){
                table.put(put);
                completed[0] = true;
            }
        }
    }
}

