/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigBuilder;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, ClientTests.class})
public class TestReplicationAdminForSyncReplication {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationAdminForSyncReplication.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationAdminForSyncReplication.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static Admin hbaseAdmin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 1);
        TEST_UTIL.startMiniCluster();
        hbaseAdmin = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        hbaseAdmin.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testAddPeerWithSameTable() throws Exception {
        int i;
        TableName tableName = TableName.valueOf((String)"testAddPeerWithSameTable");
        TEST_UTIL.createTable(tableName, Bytes.toBytes((String)"family"));
        boolean[] success = new boolean[]{true, true, true, true, true, true};
        Thread[] threads = new Thread[5];
        for (i = 0; i < 5; ++i) {
            String peerId = "id" + i;
            String clusterKey = TEST_UTIL.getClusterKey() + "-test" + i;
            int index = i;
            threads[i] = new Thread(() -> {
                try {
                    hbaseAdmin.addReplicationPeer(peerId, this.buildSyncReplicationPeerConfig(clusterKey, tableName));
                }
                catch (IOException e) {
                    LOG.error("Failed to add replication peer " + peerId);
                    success[index] = false;
                }
            });
        }
        for (i = 0; i < 5; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 5; ++i) {
            threads[i].join();
        }
        int successCount = 0;
        for (int i2 = 0; i2 < 5; ++i2) {
            if (!success[i2]) continue;
            ++successCount;
        }
        Assert.assertEquals((String)"Only one peer can be added successfully", (long)1L, (long)successCount);
    }

    private ReplicationPeerConfig buildSyncReplicationPeerConfig(String clusterKey, TableName tableName) throws IOException {
        Path rootDir = TEST_UTIL.getDataTestDirOnTestFS("remoteWAL");
        ReplicationPeerConfigBuilder builder = ReplicationPeerConfig.newBuilder();
        builder.setClusterKey(clusterKey);
        builder.setRemoteWALDir(rootDir.makeQualified(TEST_UTIL.getTestFileSystem().getUri(), TEST_UTIL.getTestFileSystem().getWorkingDirectory()).toString());
        builder.setReplicateAllUserTables(false);
        HashMap tableCfs = new HashMap();
        tableCfs.put(tableName, new ArrayList());
        builder.setTableCFsMap(tableCfs);
        return builder.build();
    }
}

