/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionReplicaTestHelper;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.master.assignment.SplitTableRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DisableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, ClientTests.class})
public class TestSplitOrMergeStatus {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSplitOrMergeStatus.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(2);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testSplitSwitch() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table t = TEST_UTIL.createTable(tableName, FAMILY);
        TEST_UTIL.loadTable(t, FAMILY, false);
        RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(t.getName());
        int originalCount = locator.getAllRegionLocations().size();
        Admin admin = TEST_UTIL.getAdmin();
        this.initSwitchStatus(admin);
        Assert.assertTrue((boolean)admin.splitSwitch(false, false));
        try {
            admin.split(t.getName());
            Assert.fail((String)"Shouldn't get here");
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
        int count = admin.getRegions(tableName).size();
        Assert.assertTrue((originalCount == count ? 1 : 0) != 0);
        Assert.assertFalse((boolean)admin.splitSwitch(true, false));
        admin.split(t.getName());
        while ((count = admin.getRegions(tableName).size()) == originalCount) {
            Threads.sleep((long)1L);
        }
        count = admin.getRegions(tableName).size();
        Assert.assertTrue((originalCount < count ? 1 : 0) != 0);
        admin.close();
    }

    @Ignore
    @Test
    public void testMergeSwitch() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table t = TEST_UTIL.createTable(tableName, FAMILY);
        TEST_UTIL.loadTable(t, FAMILY, false);
        Admin admin = TEST_UTIL.getAdmin();
        int originalCount = admin.getRegions(tableName).size();
        this.initSwitchStatus(admin);
        admin.split(t.getName());
        int postSplitCount = -1;
        while ((postSplitCount = admin.getRegions(tableName).size()) == originalCount) {
            Threads.sleep((long)1L);
        }
        Assert.assertTrue((String)("originalCount=" + originalCount + ", newCount=" + postSplitCount), (originalCount != postSplitCount ? 1 : 0) != 0);
        boolean result = admin.mergeSwitch(false, false);
        Assert.assertTrue((boolean)result);
        List regions = admin.getRegions(t.getName());
        Assert.assertTrue((regions.size() > 1 ? 1 : 0) != 0);
        Future f = admin.mergeRegionsAsync(((RegionInfo)regions.get(0)).getEncodedNameAsBytes(), ((RegionInfo)regions.get(1)).getEncodedNameAsBytes(), true);
        try {
            f.get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"Should not get here.");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        int count = admin.getRegions(tableName).size();
        Assert.assertTrue((String)("newCount=" + postSplitCount + ", count=" + count), (postSplitCount == count ? 1 : 0) != 0);
        result = admin.mergeSwitch(true, false);
        regions = admin.getRegions(t.getName());
        Assert.assertFalse((boolean)result);
        f = admin.mergeRegionsAsync(((RegionInfo)regions.get(0)).getEncodedNameAsBytes(), ((RegionInfo)regions.get(1)).getEncodedNameAsBytes(), true);
        f.get(10L, TimeUnit.SECONDS);
        count = admin.getRegions(tableName).size();
        Assert.assertTrue((postSplitCount / 2 == count ? 1 : 0) != 0);
        admin.close();
    }

    @Test
    public void testMultiSwitches() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        Assert.assertTrue((boolean)admin.splitSwitch(false, false));
        Assert.assertTrue((boolean)admin.mergeSwitch(false, false));
        Assert.assertFalse((boolean)admin.isSplitEnabled());
        Assert.assertFalse((boolean)admin.isMergeEnabled());
        admin.close();
    }

    @Test
    public void testSplitRegionReplicaRitRecovery() throws Exception {
        int startRowNum = 11;
        int rowCount = 60;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        TEST_UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setRegionReplication(2).build());
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        ServerName serverName = RegionReplicaTestHelper.getRSCarryingReplica(TEST_UTIL, tableName, 1).get();
        List regions = TEST_UTIL.getAdmin().getRegions(tableName);
        this.insertData(tableName, startRowNum, rowCount);
        int splitRowNum = startRowNum + rowCount / 2;
        byte[] splitKey = Bytes.toBytes((String)("" + splitRowNum));
        long procId = procExec.submitProcedure((Procedure)new SplitTableRegionProcedure((MasterProcedureEnv)procExec.getEnvironment(), (RegionInfo)regions.get(0), splitKey));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        long procId1 = procExec.submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        long procId2 = procExec.submitProcedure((Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        AssignmentTestingUtil.killRs(TEST_UTIL, serverName);
        Threads.sleepWithoutInterrupt((long)5000L);
        boolean hasRegionsInTransition = TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().hasRegionsInTransition();
        Assert.assertEquals((Object)false, (Object)hasRegionsInTransition);
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    private void insertData(TableName tableName, int startRow, int rowCount) throws IOException {
        Table t = TEST_UTIL.getConnection().getTable(tableName);
        for (int i = 0; i < rowCount; ++i) {
            Put p = new Put(Bytes.toBytes((String)("" + (startRow + i))));
            p.addColumn(FAMILY, Bytes.toBytes((String)"q1"), Bytes.toBytes((int)i));
            t.put(p);
        }
    }

    private void initSwitchStatus(Admin admin) throws IOException {
        if (!admin.isSplitEnabled()) {
            admin.splitSwitch(true, false);
        }
        if (!admin.isMergeEnabled()) {
            admin.mergeSwitch(true, false);
        }
        Assert.assertTrue((boolean)admin.isSplitEnabled());
        Assert.assertTrue((boolean)admin.isMergeEnabled());
    }
}

