/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Optional;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.CloneSnapshotFromClientCloneLinksAfterDeleteTestBase;
import org.apache.hadoop.hbase.client.CloneSnapshotFromClientTestBase;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.snapshot.MobSnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class, ClientTests.class})
public class TestMobCloneSnapshotFromClientCloneLinksAfterDelete
extends CloneSnapshotFromClientCloneLinksAfterDeleteTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobCloneSnapshotFromClientCloneLinksAfterDelete.class);
    private static boolean delayFlush = false;

    protected static void setupConfiguration() {
        CloneSnapshotFromClientTestBase.setupConfiguration();
        TEST_UTIL.getConfiguration().setLong("hbase.master.hfilecleaner.ttl", 0L);
        TEST_UTIL.getConfiguration().setInt("hbase.mob.file.cache.size", 0);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestMobCloneSnapshotFromClientCloneLinksAfterDelete.setupConfiguration();
        TEST_UTIL.startMiniCluster(3);
    }

    @Override
    protected void createTable() throws IOException, InterruptedException {
        MobSnapshotTestingUtils.createMobTable(TEST_UTIL, this.tableName, SnapshotTestingUtils.getSplitKeys(), this.getNumReplicas(), StoreFileTrackerFactory.Trackers.DEFAULT.name(), DelayFlushCoprocessor.class.getName(), (byte[][])new byte[][]{this.FAMILY});
    }

    @Override
    protected int numRowsToLoad() {
        return 20;
    }

    @Override
    protected int countRows(Table table) throws IOException {
        return MobSnapshotTestingUtils.countMobRows(table, new byte[0][]);
    }

    @Override
    @Test
    public void testCloneLinksAfterDelete() throws IOException, InterruptedException {
        delayFlush = true;
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 20, (byte[][])new byte[][]{this.FAMILY});
        long tid = EnvironmentEdgeManager.currentTime();
        String snapshotName3 = "snaptb3-" + tid;
        TableName clonedTableName3 = TableName.valueOf((String)(this.name.getMethodName() + EnvironmentEdgeManager.currentTime()));
        this.admin.snapshot(snapshotName3, this.tableName);
        delayFlush = false;
        int snapshot3Rows = -1;
        try (Table table = TEST_UTIL.getConnection().getTable(this.tableName);){
            snapshot3Rows = HBaseTestingUtil.countRows(table);
        }
        this.admin.cloneSnapshot(snapshotName3, clonedTableName3);
        this.admin.deleteSnapshot(snapshotName3);
        super.testCloneLinksAfterDelete();
        this.verifyRowCount(TEST_UTIL, clonedTableName3, snapshot3Rows);
        this.admin.disableTable(clonedTableName3);
        this.admin.deleteTable(clonedTableName3);
    }

    public static class DelayFlushCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e, FlushLifeCycleTracker tracker) throws IOException {
            if (delayFlush) {
                try {
                    if (Bytes.compareTo((byte[])((RegionCoprocessorEnvironment)e.getEnvironment()).getRegionInfo().getStartKey(), (byte[])HConstants.EMPTY_START_ROW) != 0) {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e1) {
                    throw new InterruptedIOException(e1.getMessage());
                }
            }
        }
    }
}

