/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestGetScanPartialResult {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestGetScanPartialResult.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final TableName TABLE = TableName.valueOf((String)"table");
    private static final byte[] CF = new byte[]{99, 102};
    private static final byte[] ROW = new byte[]{114, 111, 119};
    private static final int VALUE_SIZE = 10000;
    private static final int NUM_COLUMNS = 300;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.createTable(TABLE, CF);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static byte[] makeLargeValue(int size) {
        byte[] v = new byte[size];
        for (int i = 0; i < size; ++i) {
            v[i] = 0;
        }
        return v;
    }

    @Test
    public void test() throws IOException {
        try (Table t = TEST_UTIL.getConnection().getTable(TABLE);){
            byte[] val = TestGetScanPartialResult.makeLargeValue(10000);
            Put p = new Put(ROW);
            for (int i = 0; i < 300; ++i) {
                p.addColumn(CF, Bytes.toBytes((String)Integer.toString(i)), val);
            }
            t.put(p);
            Scan scan = new Scan();
            scan.withStartRow(ROW);
            scan.withStopRow(ROW, true);
            scan.setAllowPartialResults(true);
            scan.setMaxResultSize(0x200000L);
            scan.readVersions(1);
            ResultScanner scanner = t.getScanner(scan);
            int nResults = 0;
            int nCells = 0;
            Result result = scanner.next();
            while (result != null) {
                ++nResults;
                nCells += result.listCells().size();
                result = scanner.next();
            }
            Assert.assertEquals((long)300L, (long)nCells);
            Assert.assertTrue((nResults < 5 ? 1 : 0) != 0);
        }
    }
}

