/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.io.netty.util.ResourceLeakDetector;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestConnection {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestConnection.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestConnection.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final byte[] FAM_NAM = Bytes.toBytes((String)"f");
    private static final byte[] ROW = Bytes.toBytes((String)"bbb");
    private static final int RPC_RETRY = 5;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
        TEST_UTIL.getConfiguration().setBoolean("hbase.status.published", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.metahandler.count", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 5);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.handler.count", 3);
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws IOException {
        TEST_UTIL.getAdmin().balancerSwitch(true, true);
    }

    @Test
    public void testAdminFactory() throws IOException {
        Connection con1 = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
        Admin admin = con1.getAdmin();
        Assert.assertTrue((admin.getConnection() == con1 ? 1 : 0) != 0);
        Assert.assertTrue((admin.getConfiguration() == TEST_UTIL.getConfiguration() ? 1 : 0) != 0);
        con1.close();
    }

    @Test
    public void testConnectionCloseAllowsInterrupt() throws Exception {
        this.testConnectionClose(true);
    }

    @Test
    public void testConnectionNotAllowsInterrupt() throws Exception {
        this.testConnectionClose(false);
    }

    private void testConnectionClose(boolean allowsInterrupt) throws Exception {
        ServerName sn;
        TableName tableName = TableName.valueOf((String)("HCM-testConnectionClose" + allowsInterrupt));
        TEST_UTIL.createTable(tableName, FAM_NAM).close();
        TEST_UTIL.getAdmin().balancerSwitch(false, true);
        Configuration c2 = new Configuration(TEST_UTIL.getConfiguration());
        c2.set("hbase.client.instance.id", String.valueOf(-1));
        c2.setInt("hbase.client.retries.number", 100);
        c2.setInt("hbase.client.pause", 1);
        c2.setInt("hbase.ipc.client.failed.servers.expiry", 0);
        c2.setBoolean("hbase.ipc.client.specificThreadForWriting", allowsInterrupt);
        c2.setInt("hbase.client.meta.operation.timeout", 10000);
        c2.setInt("hbase.client.operation.timeout", 10000);
        c2.setInt("hbase.rpc.timeout", 5000);
        Connection connection = ConnectionFactory.createConnection((Configuration)c2);
        final Table table = connection.getTable(tableName);
        Put put = new Put(ROW);
        put.addColumn(FAM_NAM, ROW, ROW);
        table.put(put);
        final AtomicInteger step = new AtomicInteger(0);
        final AtomicReference<Object> failed = new AtomicReference<Object>(null);
        Thread t = new Thread("testConnectionCloseThread"){

            @Override
            public void run() {
                int done = 0;
                try {
                    step.set(1);
                    while (step.get() == 1) {
                        Get get = new Get(ROW);
                        table.get(get);
                        if (++done % 100 == 0) {
                            LOG.info("done=" + done);
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (Throwable t) {
                    failed.set(t);
                    LOG.error(t.toString(), t);
                }
                step.set(3);
            }
        };
        t.start();
        TEST_UTIL.waitFor(20000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return step.get() == 1;
            }
        });
        try (RegionLocator rl = connection.getRegionLocator(tableName);){
            sn = rl.getRegionLocation(ROW).getServerName();
        }
        RpcClient rpcClient = ((AsyncConnectionImpl)connection.toAsyncConnection()).rpcClient;
        LOG.info("Going to cancel connections. connection=" + connection.toString() + ", sn=" + sn);
        for (int i = 0; i < 500; ++i) {
            rpcClient.cancelConnections(sn);
            Thread.sleep(50L);
        }
        step.compareAndSet(1, 2);
        TEST_UTIL.waitFor(40000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return step.get() == 3;
            }
        });
        table.close();
        connection.close();
        Assert.assertTrue((String)("Unexpected exception is " + failed.get()), (failed.get() == null ? 1 : 0) != 0);
    }

    @Test
    public void testConnectionIdle() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, FAM_NAM).close();
        int idleTime = 20000;
        boolean previousBalance = TEST_UTIL.getAdmin().balancerSwitch(false, true);
        Configuration c2 = new Configuration(TEST_UTIL.getConfiguration());
        c2.set("hbase.client.instance.id", String.valueOf(-1));
        c2.setInt("hbase.client.retries.number", 1);
        c2.setInt("hbase.ipc.client.connection.minIdleTimeBeforeClose", idleTime);
        Connection connection = ConnectionFactory.createConnection((Configuration)c2);
        Table table = connection.getTable(tableName);
        Put put = new Put(ROW);
        put.addColumn(FAM_NAM, ROW, ROW);
        table.put(put);
        ManualEnvironmentEdge mee = new ManualEnvironmentEdge();
        mee.setValue(EnvironmentEdgeManager.currentTime());
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)mee);
        LOG.info("first get");
        table.get(new Get(ROW));
        LOG.info("first get - changing the time & sleeping");
        mee.incValue((long)(idleTime + 1000));
        Thread.sleep(1500L);
        LOG.info("second get - connection has been marked idle in the middle");
        table.get(new Get(ROW));
        mee.incValue((long)(idleTime + 1000));
        LOG.info("third get - connection is idle, but the reader doesn't know yet");
        table.get(new Get(ROW));
        LOG.info("we're done - time will change back");
        table.close();
        connection.close();
        EnvironmentEdgeManager.reset();
        TEST_UTIL.getAdmin().balancerSwitch(previousBalance, true);
    }

    @Test
    public void testClosing() throws Exception {
        Configuration configuration = new Configuration(TEST_UTIL.getConfiguration());
        configuration.set("hbase.client.instance.id", String.valueOf(ThreadLocalRandom.current().nextInt()));
        Connection c1 = ConnectionFactory.createConnection((Configuration)configuration);
        Connection c2 = ConnectionFactory.createConnection((Configuration)configuration);
        Assert.assertTrue((c1 != c2 ? 1 : 0) != 0);
        c1.close();
        Assert.assertTrue((boolean)c1.isClosed());
        Assert.assertFalse((boolean)c2.isClosed());
        c2.close();
        Assert.assertTrue((boolean)c2.isClosed());
    }

    @Test
    public void testCreateConnection() throws Exception {
        Connection c2;
        Configuration configuration = TEST_UTIL.getConfiguration();
        Connection c1 = ConnectionFactory.createConnection((Configuration)configuration);
        Assert.assertTrue((c1 != (c2 = ConnectionFactory.createConnection((Configuration)configuration)) ? 1 : 0) != 0);
        Assert.assertTrue((c1.getConfiguration() == c2.getConfiguration() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocateRegionsWithRegionReplicas() throws IOException {
        int regionReplication = 3;
        byte[] family = Bytes.toBytes((String)"cf");
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(regionReplication).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        TEST_UTIL.getAdmin().createTable(builder.build());
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             RegionLocator locator = conn.getRegionLocator(tableName);){
            List locations = locator.getAllRegionLocations();
            Assert.assertEquals((long)regionReplication, (long)locations.size());
            Set expectedReplicaIds = IntStream.range(0, regionReplication).boxed().collect(Collectors.toSet());
            for (HRegionLocation location : locations) {
                Assert.assertTrue((boolean)expectedReplicaIds.remove(location.getRegion().getReplicaId()));
            }
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=DoNotRetryIOException.class)
    public void testClosedConnection() throws ServiceException, Throwable {
        byte[] family = Bytes.toBytes((String)"cf");
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName).setCoprocessor(MultiRowMutationEndpoint.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        TEST_UTIL.getAdmin().createTable(builder.build());
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             Table table = conn.getTable(tableName);){
            table.get(new Get(Bytes.toBytes((int)0)));
        }
        Batch.Call callable = service -> {
            throw new RuntimeException("Should not arrive here");
        };
        conn.getTable(tableName).coprocessorService(MultiRowMutationProtos.MultiRowMutationService.class, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, callable);
    }

    @Test
    public void testCancelConnectionMemoryLeak() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, FAM_NAM).close();
        TEST_UTIL.getAdmin().balancerSwitch(false, true);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             Table table = connection.getTable(tableName);){
            table.get(new Get(Bytes.toBytes((String)"1")));
            ServerName sn = TEST_UTIL.getRSForFirstRegionInTable(tableName).getServerName();
            RpcClient rpcClient = ((AsyncConnectionImpl)connection.toAsyncConnection()).rpcClient;
            rpcClient.cancelConnections(sn);
            Thread.sleep(1000L);
            System.gc();
            Thread.sleep(1000L);
        }
    }
}

