/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ServerType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncTableGetMultiThreaded {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableGetMultiThreaded.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestAsyncTableGetMultiThreaded.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"cq");
    private static final int COUNT = 1000;
    private static AsyncConnection CONN;
    private static AsyncTable<?> TABLE;
    private static byte[][] SPLIT_KEYS;

    @BeforeClass
    public static void setUp() throws Exception {
        TestAsyncTableGetMultiThreaded.setUp(MemoryCompactionPolicy.NONE);
    }

    protected static void setUp(MemoryCompactionPolicy memoryCompaction) throws Exception {
        TEST_UTIL.getConfiguration().setLong("hbase.client.meta.operation.timeout", 60000L);
        TEST_UTIL.getConfiguration().setInt("hbase.server.allocator.max.buffer.count", 100);
        TEST_UTIL.getConfiguration().set("hbase.hregion.compacting.memstore.type", String.valueOf(memoryCompaction));
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.balancer.decision.buffer.enabled", true);
        TEST_UTIL.startMiniCluster(3);
        SPLIT_KEYS = new byte[8][];
        for (int i2 = 111; i2 < 999; i2 += 111) {
            TestAsyncTableGetMultiThreaded.SPLIT_KEYS[i2 / 111 - 1] = Bytes.toBytes((String)String.format("%03d", i2));
        }
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        TABLE = CONN.getTableBuilder(TABLE_NAME).setReadRpcTimeout(1L, TimeUnit.SECONDS).setMaxRetries(1000).build();
        TABLE.putAll(IntStream.range(0, 1000).mapToObj(i -> new Put(Bytes.toBytes((String)String.format("%03d", i))).addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)i))).collect(Collectors.toList())).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    private void run(AtomicBoolean stop) throws InterruptedException, ExecutionException {
        while (!stop.get()) {
            for (int i = 0; i < 1000; ++i) {
                Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])((Result)TABLE.get(new Get(Bytes.toBytes((String)String.format("%03d", i)))).get()).getValue(FAMILY, QUALIFIER)));
            }
            Thread.sleep(10L);
        }
    }

    @Test
    public void test() throws Exception {
        LOG.info("====== Test started ======");
        int numThreads = 7;
        AtomicBoolean stop = new AtomicBoolean(false);
        ExecutorService executor = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setNameFormat("TestAsyncGet-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
        ArrayList futures = new ArrayList();
        IntStream.range(0, numThreads).forEach(i -> futures.add(executor.submit(() -> {
            this.run(stop);
            return null;
        })));
        LOG.info("====== Scheduled {} read threads ======", (Object)numThreads);
        Collections.shuffle(Arrays.asList(SPLIT_KEYS), ThreadLocalRandom.current());
        Admin admin = TEST_UTIL.getAdmin();
        for (byte[] splitPoint : SPLIT_KEYS) {
            final int oldRegionCount = admin.getRegions(TABLE_NAME).size();
            LOG.info("====== Splitting at {} ======, region count before splitting is {}", (Object)Bytes.toStringBinary((byte[])splitPoint), (Object)oldRegionCount);
            admin.split(TABLE_NAME, splitPoint);
            TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return TEST_UTIL.getMiniHBaseCluster().getRegions(TABLE_NAME).size() > oldRegionCount;
                }

                public String explainFailure() throws Exception {
                    return "Split has not finished yet";
                }
            });
            List<HRegion> regions = TEST_UTIL.getMiniHBaseCluster().getRegions(TABLE_NAME);
            LOG.info("====== Split at {} ======, region count after splitting is {}", (Object)Bytes.toStringBinary((byte[])splitPoint), (Object)regions.size());
            for (HRegion region : regions) {
                LOG.info("====== Compact {} ======", (Object)region.getRegionInfo());
                region.compact(true);
            }
            for (HRegion region : regions) {
                LOG.info("====== Waiting for compaction on {} ======", (Object)region.getRegionInfo());
                RetryCounter retrier = new RetryCounter(30, 1L, TimeUnit.SECONDS);
                while (true) {
                    try {
                        if (admin.getCompactionStateForRegion(region.getRegionInfo().getRegionName()) == CompactionState.NONE) {
                            break;
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to query");
                    }
                    if (!retrier.shouldRetry()) {
                        throw new IOException("Can not finish compaction in time after attempt " + retrier.getAttemptTimes() + " times");
                    }
                    retrier.sleepUntilNextRetry();
                }
                LOG.info("====== Compaction on {} finished, close and archive compacted files ======", (Object)region.getRegionInfo());
                ((HStore)region.getStores().get(0)).closeAndArchiveCompactedFiles();
                LOG.info("====== Close and archive compacted files on {} done ======", (Object)region.getRegionInfo());
            }
            Thread.sleep(5000L);
            LOG.info("====== Balancing cluster ======");
            admin.balance(BalanceRequest.newBuilder().setIgnoreRegionsInTransition(true).build());
            LOG.info("====== Balance cluster done ======");
            Thread.sleep(5000L);
            ServerName metaServer = TEST_UTIL.getHBaseCluster().getServerHoldingMeta();
            ServerName newMetaServer = TEST_UTIL.getHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer().getServerName()).filter(s -> !s.equals((Object)metaServer)).findAny().get();
            LOG.info("====== Moving meta from {} to {} ======", (Object)metaServer, (Object)newMetaServer);
            admin.move(RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), newMetaServer);
            LOG.info("====== Move meta done ======");
            Thread.sleep(5000L);
        }
        List balancerDecisionRecords = admin.getLogEntries(null, "BALANCER_DECISION", ServerType.MASTER, 2, null);
        Assert.assertEquals((long)balancerDecisionRecords.size(), (long)2L);
        LOG.info("====== Read test finished, shutdown thread pool ======");
        stop.set(true);
        executor.shutdown();
        for (int i2 = 0; i2 < numThreads; ++i2) {
            LOG.info("====== Waiting for {} threads to finish, remaining {} ======", (Object)numThreads, (Object)(numThreads - i2));
            ((Future)futures.get(i2)).get();
        }
        LOG.info("====== Test test finished ======");
    }
}

