/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigBuilder;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncReplicationAdminApiWithClusters
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncReplicationAdminApiWithClusters.class);
    private static final String ID_SECOND = "2";
    private static HBaseTestingUtil TEST_UTIL2;
    private static Configuration conf2;
    private static AsyncAdmin admin2;
    private static AsyncConnection connection;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 60000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.operation.timeout", 120000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.client.start.log.errors.counter", 0);
        TEST_UTIL.startMiniCluster();
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        conf2 = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        conf2.set("zookeeper.znode.parent", "/2");
        TEST_UTIL2 = new HBaseTestingUtil(conf2);
        TEST_UTIL2.startMiniCluster();
        connection = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL2.getConfiguration()).get();
        admin2 = connection.getAdmin();
        ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(TEST_UTIL2.getClusterKey()).build();
        ASYNC_CONN.getAdmin().addReplicationPeer(ID_SECOND, rpc).join();
    }

    @AfterClass
    public static void clearUp() throws IOException {
        connection.close();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        Pattern pattern = Pattern.compile(this.tableName.getNameAsString() + ".*");
        this.cleanupTables(this.admin, pattern);
        this.cleanupTables(admin2, pattern);
    }

    private void cleanupTables(AsyncAdmin admin, Pattern pattern) {
        ((CompletableFuture)admin.listTableNames(pattern, false).whenCompleteAsync((tables, err) -> {
            if (tables != null) {
                tables.forEach(table -> {
                    try {
                        admin.disableTable(table).join();
                    }
                    catch (Exception e) {
                        LOG.debug("Table: " + this.tableName + " already disabled, so just deleting it.");
                    }
                    admin.deleteTable(table).join();
                });
            }
        }, (Executor)ForkJoinPool.commonPool())).join();
    }

    private void createTableWithDefaultConf(AsyncAdmin admin, TableName tableName) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
        admin.createTable(builder.build()).join();
    }

    @Test
    public void testEnableAndDisableTableReplication() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        this.admin.enableTableReplication(this.tableName).join();
        TableDescriptor tableDesc = (TableDescriptor)this.admin.getDescriptor(this.tableName).get();
        for (ColumnFamilyDescriptor fam : tableDesc.getColumnFamilies()) {
            Assert.assertEquals((long)1L, (long)fam.getScope());
        }
        this.admin.disableTableReplication(this.tableName).join();
        tableDesc = (TableDescriptor)this.admin.getDescriptor(this.tableName).get();
        for (ColumnFamilyDescriptor fam : tableDesc.getColumnFamilies()) {
            Assert.assertEquals((long)0L, (long)fam.getScope());
        }
    }

    @Test
    public void testEnableReplicationWhenSlaveClusterDoesntHaveTable() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        Assert.assertFalse((boolean)((Boolean)admin2.tableExists(this.tableName).get()));
        this.admin.enableTableReplication(this.tableName).join();
        Assert.assertTrue((boolean)((Boolean)admin2.tableExists(this.tableName).get()));
    }

    @Test
    public void testEnableReplicationWhenTableDescriptorIsNotSameInClusters() throws Exception {
        this.createTableWithDefaultConf(this.admin, this.tableName);
        this.createTableWithDefaultConf(admin2, this.tableName);
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)((TableDescriptor)this.admin.getDescriptor(this.tableName).get()));
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"newFamily")).build());
        admin2.disableTable(this.tableName).join();
        admin2.modifyTable(builder.build()).join();
        admin2.enableTable(this.tableName).join();
        try {
            this.admin.enableTableReplication(this.tableName).join();
            Assert.fail((String)"Exception should be thrown if table descriptors in the clusters are not same.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.admin.disableTable(this.tableName).join();
        this.admin.modifyTable(builder.build()).join();
        this.admin.enableTable(this.tableName).join();
        this.admin.enableTableReplication(this.tableName).join();
        TableDescriptor tableDesc = (TableDescriptor)this.admin.getDescriptor(this.tableName).get();
        for (ColumnFamilyDescriptor fam : tableDesc.getColumnFamilies()) {
            Assert.assertEquals((long)1L, (long)fam.getScope());
        }
    }

    @Test
    public void testDisableReplicationForNonExistingTable() throws Exception {
        try {
            this.admin.disableTableReplication(this.tableName).join();
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TableNotFoundException));
        }
    }

    @Test
    public void testEnableReplicationForNonExistingTable() throws Exception {
        try {
            this.admin.enableTableReplication(this.tableName).join();
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TableNotFoundException));
        }
    }

    @Test
    public void testDisableReplicationWhenTableNameAsNull() throws Exception {
        try {
            this.admin.disableTableReplication(null).join();
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testEnableReplicationWhenTableNameAsNull() throws Exception {
        try {
            this.admin.enableTableReplication(null).join();
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableReplicationForExplicitSetTableCfs() throws Exception {
        TableName tableName2 = TableName.valueOf((String)(this.tableName.getNameAsString() + ID_SECOND));
        this.createTableWithDefaultConf(this.tableName);
        this.createTableWithDefaultConf(tableName2);
        Assert.assertFalse((String)"Table should not exists in the peer cluster", (boolean)((Boolean)admin2.tableExists(this.tableName).get()));
        Assert.assertFalse((String)"Table should not exists in the peer cluster", (boolean)((Boolean)admin2.tableExists(tableName2).get()));
        HashMap<TableName, Object> tableCfs = new HashMap<TableName, Object>();
        tableCfs.put(this.tableName, null);
        ReplicationPeerConfigBuilder rpcBuilder = ReplicationPeerConfig.newBuilder((ReplicationPeerConfig)((ReplicationPeerConfig)this.admin.getReplicationPeerConfig(ID_SECOND).get())).setReplicateAllUserTables(false).setTableCFsMap(tableCfs);
        try {
            this.admin.updateReplicationPeerConfig(ID_SECOND, rpcBuilder.build()).join();
            this.admin.enableTableReplication(tableName2).join();
            Assert.assertFalse((String)"Table should not be created if user has set table cfs explicitly for the peer and this is not part of that collection", (boolean)((Boolean)admin2.tableExists(tableName2).get()));
            tableCfs.put(tableName2, null);
            rpcBuilder.setTableCFsMap(tableCfs);
            this.admin.updateReplicationPeerConfig(ID_SECOND, rpcBuilder.build()).join();
            this.admin.enableTableReplication(tableName2).join();
            Assert.assertTrue((String)"Table should be created if user has explicitly added table into table cfs collection", (boolean)((Boolean)admin2.tableExists(tableName2).get()));
        }
        finally {
            rpcBuilder.setTableCFsMap(null).setReplicateAllUserTables(true).build();
            this.admin.updateReplicationPeerConfig(ID_SECOND, rpcBuilder.build()).join();
        }
    }
}

