/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncBufferedMutator;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncClientPauseForRpcThrottling {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncClientPauseForRpcThrottling.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static TableName TABLE_NAME = TableName.valueOf((String)"RpcThrottling");
    private static byte[] FAMILY = Bytes.toBytes((String)"Family");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"Qualifier");
    private static AsyncConnection CONN;
    private static final AtomicBoolean THROTTLE;
    private static final AtomicInteger FORCE_RETRIES;
    private static final long WAIT_INTERVAL_NANOS;
    private static final int RETRY_COUNT = 3;
    private static final int MAX_MULTIPLIER_EXPECTATION = 2;

    @BeforeClass
    public static void setUp() throws Exception {
        Assert.assertTrue((String)"The MAX_MULTIPLIER_EXPECTATION must be less than HConstants.RETRY_BACKOFF[RETRY_COUNT] in order for our tests to adequately verify that we aren't multiplying throttled pauses based on the retry count.", (2 < HConstants.RETRY_BACKOFF[3] ? 1 : 0) != 0);
        UTIL.getConfiguration().setLong("hbase.client.retries.number", 1L);
        UTIL.startMiniCluster(1);
        UTIL.getMiniHBaseCluster().getConfiguration().setClass("hbase.regionserver.impl", ThrottlingRegionServerForTest.class, HRegionServer.class);
        HRegionServer regionServer = UTIL.getMiniHBaseCluster().startRegionServer().getRegionServer();
        try (Table table = UTIL.createTable(TABLE_NAME, FAMILY);){
            UTIL.waitTableAvailable(TABLE_NAME);
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)i)));
            }
        }
        UTIL.getAdmin().move(((RegionInfo)UTIL.getAdmin().getRegions(TABLE_NAME).get(0)).getEncodedNameAsBytes(), regionServer.getServerName());
        Configuration conf = new Configuration(UTIL.getConfiguration());
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)conf).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.getAdmin().disableTable(TABLE_NAME);
        UTIL.getAdmin().deleteTable(TABLE_NAME);
        Closeables.close((Closeable)CONN, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    private void assertTime(Callable<Void> callable, long time, boolean isGreater) throws Exception {
        long costNs = this.getCostNs(callable);
        if (isGreater) {
            Assert.assertTrue((costNs > time ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((costNs <= time ? 1 : 0) != 0);
        }
    }

    private void assertTimeBetween(Callable<Void> callable, long minNs, long maxNs) throws Exception {
        long costNs = this.getCostNs(callable);
        Assert.assertTrue((costNs > minNs ? 1 : 0) != 0);
        Assert.assertTrue((costNs < maxNs ? 1 : 0) != 0);
    }

    private long getCostNs(Callable<Void> callable) throws Exception {
        long startNs = System.nanoTime();
        callable.call();
        return System.nanoTime() - startNs;
    }

    @Test
    public void itWaitsForThrottledGet() throws Exception {
        boolean isThrottled = true;
        THROTTLE.set(isThrottled);
        AsyncTable table = CONN.getTable(TABLE_NAME);
        this.assertTime(() -> {
            table.get(new Get(Bytes.toBytes((int)0))).get();
            return null;
        }, WAIT_INTERVAL_NANOS, isThrottled);
    }

    @Test
    public void itDoesNotWaitForUnthrottledGet() throws Exception {
        boolean isThrottled = false;
        THROTTLE.set(isThrottled);
        AsyncTable table = CONN.getTable(TABLE_NAME);
        this.assertTime(() -> {
            table.get(new Get(Bytes.toBytes((int)0))).get();
            return null;
        }, WAIT_INTERVAL_NANOS, isThrottled);
    }

    @Test
    public void itDoesNotWaitForThrottledGetExceedingTimeout() throws Exception {
        AsyncTable table = CONN.getTableBuilder(TABLE_NAME).setOperationTimeout(1L, TimeUnit.MILLISECONDS).build();
        boolean isThrottled = true;
        THROTTLE.set(isThrottled);
        this.assertTime(() -> {
            Assert.assertThrows(ExecutionException.class, () -> {
                Result cfr_ignored_0 = (Result)table.get(new Get(Bytes.toBytes((int)0))).get();
            });
            return null;
        }, WAIT_INTERVAL_NANOS, false);
    }

    @Test
    public void itDoesNotMultiplyThrottledGetWait() throws Exception {
        THROTTLE.set(true);
        FORCE_RETRIES.set(3);
        AsyncTable table = CONN.getTableBuilder(TABLE_NAME).setOperationTimeout(1L, TimeUnit.MINUTES).setMaxRetries(4).setRetryPause(1L, TimeUnit.NANOSECONDS).build();
        this.assertTimeBetween(() -> {
            table.get(new Get(Bytes.toBytes((int)0))).get();
            return null;
        }, WAIT_INTERVAL_NANOS, 2L * WAIT_INTERVAL_NANOS);
    }

    @Test
    public void itWaitsForThrottledBatch() throws Exception {
        boolean isThrottled = true;
        THROTTLE.set(isThrottled);
        this.assertTime(() -> {
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            try (AsyncBufferedMutator mutator = CONN.getBufferedMutator(TABLE_NAME);){
                for (int i = 100; i < 110; ++i) {
                    futures.add(mutator.mutate((Mutation)new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)i))));
                }
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
        }, WAIT_INTERVAL_NANOS, isThrottled);
    }

    @Test
    public void itDoesNotWaitForUnthrottledBatch() throws Exception {
        boolean isThrottled = false;
        THROTTLE.set(isThrottled);
        this.assertTime(() -> {
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            try (AsyncBufferedMutator mutator = CONN.getBufferedMutator(TABLE_NAME);){
                for (int i = 100; i < 110; ++i) {
                    futures.add(mutator.mutate((Mutation)new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)i))));
                }
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
        }, WAIT_INTERVAL_NANOS, isThrottled);
    }

    @Test
    public void itDoesNotWaitForThrottledBatchExceedingTimeout() throws Exception {
        boolean isThrottled = true;
        THROTTLE.set(isThrottled);
        this.assertTime(() -> {
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            try (AsyncBufferedMutator mutator = CONN.getBufferedMutatorBuilder(TABLE_NAME).setOperationTimeout(1L, TimeUnit.MILLISECONDS).build();){
                for (int i = 100; i < 110; ++i) {
                    futures.add(mutator.mutate((Mutation)new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)i))));
                }
            }
            Assert.assertThrows(ExecutionException.class, () -> CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get());
            return null;
        }, WAIT_INTERVAL_NANOS, false);
    }

    @Test
    public void itDoesNotMultiplyThrottledBatchWait() throws Exception {
        THROTTLE.set(true);
        FORCE_RETRIES.set(3);
        this.assertTimeBetween(() -> {
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            try (AsyncBufferedMutator mutator = CONN.getBufferedMutatorBuilder(TABLE_NAME).setOperationTimeout(1L, TimeUnit.MINUTES).setMaxRetries(4).setRetryPause(1L, TimeUnit.NANOSECONDS).build();){
                for (int i = 100; i < 110; ++i) {
                    futures.add(mutator.mutate((Mutation)new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)i))));
                }
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
            return null;
        }, WAIT_INTERVAL_NANOS, 2L * WAIT_INTERVAL_NANOS);
    }

    @Test
    public void itWaitsForThrottledScan() throws Exception {
        boolean isThrottled = true;
        THROTTLE.set(isThrottled);
        this.assertTime(() -> {
            try (ResultScanner scanner = CONN.getTable(TABLE_NAME).getScanner(new Scan().setCaching(80));){
                for (int i = 0; i < 100; ++i) {
                    Result result = scanner.next();
                    Assert.assertArrayEquals((byte[])Bytes.toBytes((int)i), (byte[])result.getValue(FAMILY, QUALIFIER));
                }
            }
            return null;
        }, WAIT_INTERVAL_NANOS, isThrottled);
    }

    @Test
    public void itDoesNotWaitForUnthrottledScan() throws Exception {
        boolean isThrottled = false;
        THROTTLE.set(isThrottled);
        this.assertTime(() -> {
            try (ResultScanner scanner = CONN.getTable(TABLE_NAME).getScanner(new Scan().setCaching(80));){
                for (int i = 0; i < 100; ++i) {
                    Result result = scanner.next();
                    Assert.assertArrayEquals((byte[])Bytes.toBytes((int)i), (byte[])result.getValue(FAMILY, QUALIFIER));
                }
            }
            return null;
        }, WAIT_INTERVAL_NANOS, isThrottled);
    }

    @Test
    public void itDoesNotWaitForThrottledScanExceedingTimeout() throws Exception {
        AsyncTable table = CONN.getTableBuilder(TABLE_NAME).setScanTimeout(1L, TimeUnit.MILLISECONDS).build();
        boolean isThrottled = true;
        THROTTLE.set(isThrottled);
        this.assertTime(() -> {
            try (ResultScanner scanner = table.getScanner(new Scan().setCaching(80));){
                for (int i = 0; i < 100; ++i) {
                    Assert.assertThrows(RetriesExhaustedException.class, () -> ((ResultScanner)scanner).next());
                }
            }
            return null;
        }, WAIT_INTERVAL_NANOS, false);
    }

    @Test
    public void itDoesNotMultiplyThrottledScanWait() throws Exception {
        THROTTLE.set(true);
        FORCE_RETRIES.set(3);
        AsyncTable table = CONN.getTableBuilder(TABLE_NAME).setOperationTimeout(1L, TimeUnit.MINUTES).setMaxRetries(4).setRetryPause(1L, TimeUnit.NANOSECONDS).build();
        this.assertTimeBetween(() -> {
            try (ResultScanner scanner = table.getScanner(new Scan().setCaching(80));){
                for (int i = 0; i < 100; ++i) {
                    Result result = scanner.next();
                    Assert.assertArrayEquals((byte[])Bytes.toBytes((int)i), (byte[])result.getValue(FAMILY, QUALIFIER));
                }
            }
            return null;
        }, WAIT_INTERVAL_NANOS, 2L * WAIT_INTERVAL_NANOS);
    }

    static {
        THROTTLE = new AtomicBoolean(false);
        FORCE_RETRIES = new AtomicInteger(0);
        WAIT_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(1L);
    }

    public static final class ThrottlingRegionServerForTest
    extends HRegionServer {
        public ThrottlingRegionServerForTest(Configuration conf) throws IOException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new ThrottlingRSRpcServicesForTest(this);
        }
    }

    public static final class ThrottlingRSRpcServicesForTest
    extends RSRpcServices {
        public ThrottlingRSRpcServicesForTest(HRegionServer rs) throws IOException {
            super(rs);
        }

        public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
            this.maybeForceRetry();
            this.maybeThrottle();
            return super.get(controller, request);
        }

        public ClientProtos.MultiResponse multi(RpcController rpcc, ClientProtos.MultiRequest request) throws ServiceException {
            this.maybeForceRetry();
            this.maybeThrottle();
            return super.multi(rpcc, request);
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            this.maybeForceRetry();
            this.maybeThrottle();
            return super.scan(controller, request);
        }

        private void maybeForceRetry() throws ServiceException {
            if (FORCE_RETRIES.get() > 0) {
                FORCE_RETRIES.addAndGet(-1);
                throw new ServiceException((Throwable)new RegionTooBusyException("Retry"));
            }
        }

        private void maybeThrottle() throws ServiceException {
            if (THROTTLE.get()) {
                THROTTLE.set(false);
                throw new ServiceException((Throwable)new RpcThrottlingException("number of requests exceeded - wait " + TimeUnit.NANOSECONDS.toMillis(WAIT_INTERVAL_NANOS) + "ms"));
            }
        }
    }
}

