/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.ZKConnectionRegistry;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.NonRepeatedEnvironmentEdge;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
@RunWith(value=Parameterized.class)
class FromClientSideBase {
    private static final Logger LOG = LoggerFactory.getLogger(FromClientSideBase.class);
    static HBaseTestingUtil TEST_UTIL;
    static byte[] ROW;
    static byte[] FAMILY;
    static final byte[] INVALID_FAMILY;
    static byte[] QUALIFIER;
    static byte[] VALUE;
    static int SLAVES;

    FromClientSideBase() {
    }

    protected static boolean isSameParameterizedCluster(Class<?> registryImpl, int numHedgedReqs) {
        if (TEST_UTIL == null) {
            return false;
        }
        Configuration conf = TEST_UTIL.getConfiguration();
        Class confClass = conf.getClass("hbase.client.registry.impl", ZKConnectionRegistry.class);
        int hedgedReqConfig = conf.getInt("hbase.client.master_registry.hedged.fanout", 2);
        return confClass.getName().equals(registryImpl.getName()) && numHedgedReqs == hedgedReqConfig;
    }

    protected static final void initialize(Class<? extends ConnectionRegistry> registryImpl, int numHedgedReqs, Class<?> ... cps) throws Exception {
        if (FromClientSideBase.isSameParameterizedCluster(registryImpl, numHedgedReqs)) {
            return;
        }
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)new NonRepeatedEnvironmentEdge());
        if (TEST_UTIL != null) {
            TEST_UTIL.shutdownMiniCluster();
        }
        TEST_UTIL = new HBaseTestingUtil();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", (String[])Arrays.stream(cps).map(Class::getName).toArray(String[]::new));
        conf.setBoolean("hbase.table.sanity.checks", true);
        conf.setClass("hbase.client.registry.impl", registryImpl, ConnectionRegistry.class);
        Preconditions.checkArgument((numHedgedReqs > 0 ? 1 : 0) != 0);
        conf.setInt("hbase.client.master_registry.hedged.fanout", numHedgedReqs);
        StartTestingClusterOption.Builder builder = StartTestingClusterOption.builder();
        builder.numMasters(numHedgedReqs > 1 ? 3 : 1).numRegionServers(SLAVES);
        TEST_UTIL.startMiniCluster(builder.build());
    }

    protected static void afterClass() throws Exception {
        if (TEST_UTIL != null) {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    protected void deleteColumns(Table ht, String value, String keyPrefix) throws IOException {
        ResultScanner scanner = this.buildScanner(keyPrefix, value, ht);
        Iterator it = scanner.iterator();
        int count = 0;
        while (it.hasNext()) {
            Result result = (Result)it.next();
            Delete delete = new Delete(result.getRow());
            delete.addColumn(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"));
            ht.delete(delete);
            ++count;
        }
        Assert.assertEquals((String)"Did not perform correct number of deletes", (long)3L, (long)count);
    }

    protected int getNumberOfRows(String keyPrefix, String value, Table ht) throws Exception {
        ResultScanner resultScanner = this.buildScanner(keyPrefix, value, ht);
        Iterator scanner = resultScanner.iterator();
        int numberOfResults = 0;
        while (scanner.hasNext()) {
            Result result = (Result)scanner.next();
            System.out.println("Got back key: " + Bytes.toString((byte[])result.getRow()));
            for (Cell kv : result.rawCells()) {
                System.out.println("kv=" + kv.toString() + ", " + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)));
            }
            ++numberOfResults;
        }
        return numberOfResults;
    }

    protected ResultScanner buildScanner(String keyPrefix, String value, Table ht) throws IOException {
        FilterList allFilters = new FilterList(new Filter[0]);
        allFilters.addFilter((Filter)new PrefixFilter(Bytes.toBytes((String)keyPrefix)));
        SingleColumnValueFilter filter = new SingleColumnValueFilter(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"), CompareOperator.EQUAL, Bytes.toBytes((String)value));
        filter.setFilterIfMissing(true);
        allFilters.addFilter((Filter)filter);
        Scan scan = new Scan();
        scan.addFamily(Bytes.toBytes((String)"trans-blob"));
        scan.addFamily(Bytes.toBytes((String)"trans-type"));
        scan.addFamily(Bytes.toBytes((String)"trans-date"));
        scan.addFamily(Bytes.toBytes((String)"trans-tags"));
        scan.addFamily(Bytes.toBytes((String)"trans-group"));
        scan.setFilter((Filter)allFilters);
        return ht.getScanner(scan);
    }

    protected void putRows(Table ht, int numRows, String value, String key) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            String row = key + "_" + HBaseCommonTestingUtil.getRandomUUID().toString();
            System.out.println(String.format("Saving row: %s, with value %s", row, value));
            Put put = new Put(Bytes.toBytes((String)row));
            put.setDurability(Durability.SKIP_WAL);
            put.addColumn(Bytes.toBytes((String)"trans-blob"), null, Bytes.toBytes((String)"value for blob"));
            put.addColumn(Bytes.toBytes((String)"trans-type"), null, Bytes.toBytes((String)"statement"));
            put.addColumn(Bytes.toBytes((String)"trans-date"), null, Bytes.toBytes((String)"20090921010101999"));
            put.addColumn(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"), Bytes.toBytes((String)value));
            put.addColumn(Bytes.toBytes((String)"trans-group"), null, Bytes.toBytes((String)"adhocTransactionGroupId"));
            ht.put(put);
        }
    }

    protected void assertRowCount(Table t, int expected) throws IOException {
        Assert.assertEquals((long)expected, (long)HBaseTestingUtil.countRows(t, new Scan()));
    }

    protected Scan createScanWithRowFilter(byte[] key) {
        return this.createScanWithRowFilter(key, null, CompareOperator.LESS);
    }

    protected Scan createScanWithRowFilter(byte[] key, byte[] startRow, CompareOperator op) {
        Assert.assertTrue((key != null && key.length > 0 && Bytes.BYTES_COMPARATOR.compare(key, new byte[]{97, 97, 97}) >= 0 ? 1 : 0) != 0);
        LOG.info("Key=" + Bytes.toString((byte[])key));
        Scan s = startRow == null ? new Scan() : new Scan().withStartRow(startRow);
        RowFilter f = new RowFilter(op, (ByteArrayComparable)new BinaryComparator(key));
        f = new WhileMatchFilter((Filter)f);
        s.setFilter((Filter)f);
        return s;
    }

    protected List<HRegionLocation> splitTable(Table t) throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        admin.split(t.getName());
        admin.close();
        List<HRegionLocation> regions = this.waitOnSplit(t);
        Assert.assertTrue((regions.size() > 1 ? 1 : 0) != 0);
        return regions;
    }

    private List<HRegionLocation> waitOnSplit(Table t) throws IOException {
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(t.getName());){
            List regions = locator.getAllRegionLocations();
            int originalCount = regions.size();
            for (int i = 0; i < TEST_UTIL.getConfiguration().getInt("hbase.test.retries", 30); ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                regions = locator.getAllRegionLocations();
                if (regions.size() > originalCount) break;
            }
            List list = regions;
            return list;
        }
    }

    protected Result getSingleScanResult(Table ht, Scan scan) throws IOException {
        ResultScanner scanner = ht.getScanner(scan);
        Result result = scanner.next();
        scanner.close();
        return result;
    }

    byte[][] makeNAscii(byte[] base, int n) {
        if (n > 256) {
            return this.makeNBig(base, n);
        }
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byte[] tail = Bytes.toBytes((String)Integer.toString(i));
            ret[i] = Bytes.add((byte[])base, (byte[])tail);
        }
        return ret;
    }

    protected byte[][] makeN(byte[] base, int n) {
        if (n > 256) {
            return this.makeNBig(base, n);
        }
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add((byte[])base, (byte[])new byte[]{(byte)i});
        }
        return ret;
    }

    protected byte[][] makeNBig(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int byteA = i % 256;
            int byteB = i >> 8;
            ret[i] = Bytes.add((byte[])base, (byte[])new byte[]{(byte)byteB, (byte)byteA});
        }
        return ret;
    }

    protected long[] makeStamps(int n) {
        long[] stamps = new long[n];
        for (int i = 0; i < n; ++i) {
            stamps[i] = (long)i + 1L;
        }
        return stamps;
    }

    protected static boolean equals(byte[] left, byte[] right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right.length == 0) {
            return true;
        }
        if (right == null && left.length == 0) {
            return true;
        }
        return Bytes.equals((byte[])left, (byte[])right);
    }

    protected void assertKey(Cell key, byte[] row, byte[] family, byte[] qualifier, byte[] value) {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])CellUtil.cloneRow((Cell)key)) + "]"), (boolean)FromClientSideBase.equals(row, CellUtil.cloneRow((Cell)key)));
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)key)) + "]"), (boolean)FromClientSideBase.equals(family, CellUtil.cloneFamily((Cell)key)));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)key)) + "]"), (boolean)FromClientSideBase.equals(qualifier, CellUtil.cloneQualifier((Cell)key)));
        Assert.assertTrue((String)("Expected value [" + Bytes.toString((byte[])value) + "] Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)key)) + "]"), (boolean)FromClientSideBase.equals(value, CellUtil.cloneValue((Cell)key)));
    }

    static void assertIncrementKey(Cell key, byte[] row, byte[] family, byte[] qualifier, long value) {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])CellUtil.cloneRow((Cell)key)) + "]"), (boolean)FromClientSideBase.equals(row, CellUtil.cloneRow((Cell)key)));
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)key)) + "]"), (boolean)FromClientSideBase.equals(family, CellUtil.cloneFamily((Cell)key)));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)key)) + "]"), (boolean)FromClientSideBase.equals(qualifier, CellUtil.cloneQualifier((Cell)key)));
        Assert.assertEquals((String)("Expected value [" + value + "] Got value [" + Bytes.toLong((byte[])CellUtil.cloneValue((Cell)key)) + "]"), (long)Bytes.toLong((byte[])CellUtil.cloneValue((Cell)key)), (long)value);
    }

    protected void assertNumKeys(Result result, int n) throws Exception {
        Assert.assertEquals((String)("Expected " + n + " keys but got " + result.size()), (long)result.size(), (long)n);
    }

    protected void assertNResult(Result result, byte[] row, byte[][] families, byte[][] qualifiers, byte[][] values, int[][] idxs) {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)FromClientSideBase.equals(row, result.getRow()));
        Assert.assertEquals((String)("Expected " + idxs.length + " keys but result contains " + result.size()), (long)result.size(), (long)idxs.length);
        Cell[] keys = result.rawCells();
        for (int i = 0; i < keys.length; ++i) {
            byte[] family = families[idxs[i][0]];
            byte[] qualifier = qualifiers[idxs[i][1]];
            byte[] value = values[idxs[i][2]];
            Cell key = keys[i];
            byte[] famb = CellUtil.cloneFamily((Cell)key);
            byte[] qualb = CellUtil.cloneQualifier((Cell)key);
            byte[] valb = CellUtil.cloneValue((Cell)key);
            Assert.assertTrue((String)("(" + i + ") Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])famb) + "]"), (boolean)FromClientSideBase.equals(family, famb));
            Assert.assertTrue((String)("(" + i + ") Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])qualb) + "]"), (boolean)FromClientSideBase.equals(qualifier, qualb));
            Assert.assertTrue((String)("(" + i + ") Expected value [" + Bytes.toString((byte[])value) + "] Got value [" + Bytes.toString((byte[])valb) + "]"), (boolean)FromClientSideBase.equals(value, valb));
        }
    }

    protected void assertNResult(Result result, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)FromClientSideBase.equals(row, result.getRow()));
        int expectedResults = end - start + 1;
        Assert.assertEquals((long)expectedResults, (long)result.size());
        Cell[] keys = result.rawCells();
        for (int i = 0; i < keys.length; ++i) {
            byte[] value = values[end - i];
            long ts = stamps[end - i];
            Cell key = keys[i];
            Assert.assertTrue((String)("(" + i + ") Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)key)) + "]"), (boolean)CellUtil.matchingFamily((Cell)key, (byte[])family));
            Assert.assertTrue((String)("(" + i + ") Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)key)) + "]"), (boolean)CellUtil.matchingQualifier((Cell)key, (byte[])qualifier));
            Assert.assertEquals((String)("Expected ts [" + ts + "] Got ts [" + key.getTimestamp() + "]"), (long)ts, (long)key.getTimestamp());
            Assert.assertTrue((String)("(" + i + ") Expected value [" + Bytes.toString((byte[])value) + "] Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)key)) + "]"), (boolean)CellUtil.matchingValue((Cell)key, (byte[])value));
        }
    }

    protected void assertDoubleResult(Result result, byte[] row, byte[] familyA, byte[] qualifierA, byte[] valueA, byte[] familyB, byte[] qualifierB, byte[] valueB) {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)FromClientSideBase.equals(row, result.getRow()));
        Assert.assertEquals((String)("Expected two keys but result contains " + result.size()), (long)2L, (long)result.size());
        Cell[] kv = result.rawCells();
        Cell kvA = kv[0];
        Assert.assertTrue((String)("(A) Expected family [" + Bytes.toString((byte[])familyA) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kvA)) + "]"), (boolean)FromClientSideBase.equals(familyA, CellUtil.cloneFamily((Cell)kvA)));
        Assert.assertTrue((String)("(A) Expected qualifier [" + Bytes.toString((byte[])qualifierA) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kvA)) + "]"), (boolean)FromClientSideBase.equals(qualifierA, CellUtil.cloneQualifier((Cell)kvA)));
        Assert.assertTrue((String)("(A) Expected value [" + Bytes.toString((byte[])valueA) + "] Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kvA)) + "]"), (boolean)FromClientSideBase.equals(valueA, CellUtil.cloneValue((Cell)kvA)));
        Cell kvB = kv[1];
        Assert.assertTrue((String)("(B) Expected family [" + Bytes.toString((byte[])familyB) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kvB)) + "]"), (boolean)FromClientSideBase.equals(familyB, CellUtil.cloneFamily((Cell)kvB)));
        Assert.assertTrue((String)("(B) Expected qualifier [" + Bytes.toString((byte[])qualifierB) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kvB)) + "]"), (boolean)FromClientSideBase.equals(qualifierB, CellUtil.cloneQualifier((Cell)kvB)));
        Assert.assertTrue((String)("(B) Expected value [" + Bytes.toString((byte[])valueB) + "] Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kvB)) + "]"), (boolean)FromClientSideBase.equals(valueB, CellUtil.cloneValue((Cell)kvB)));
    }

    protected void assertSingleResult(Result result, byte[] row, byte[] family, byte[] qualifier, byte[] value) {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)FromClientSideBase.equals(row, result.getRow()));
        Assert.assertEquals((String)("Expected a single key but result contains " + result.size()), (long)1L, (long)result.size());
        Cell kv = result.rawCells()[0];
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kv)) + "]"), (boolean)FromClientSideBase.equals(family, CellUtil.cloneFamily((Cell)kv)));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv)) + "]"), (boolean)FromClientSideBase.equals(qualifier, CellUtil.cloneQualifier((Cell)kv)));
        Assert.assertTrue((String)("Expected value [" + Bytes.toString((byte[])value) + "] Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)) + "]"), (boolean)FromClientSideBase.equals(value, CellUtil.cloneValue((Cell)kv)));
    }

    protected void assertSingleResult(Result result, byte[] row, byte[] family, byte[] qualifier, long value) {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)FromClientSideBase.equals(row, result.getRow()));
        Assert.assertEquals((String)("Expected a single key but result contains " + result.size()), (long)1L, (long)result.size());
        Cell kv = result.rawCells()[0];
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kv)) + "]"), (boolean)FromClientSideBase.equals(family, CellUtil.cloneFamily((Cell)kv)));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv)) + "]"), (boolean)FromClientSideBase.equals(qualifier, CellUtil.cloneQualifier((Cell)kv)));
        Assert.assertEquals((String)("Expected value [" + value + "] Got value [" + Bytes.toLong((byte[])CellUtil.cloneValue((Cell)kv)) + "]"), (long)value, (long)Bytes.toLong((byte[])CellUtil.cloneValue((Cell)kv)));
    }

    protected void assertSingleResult(Result result, byte[] row, byte[] family, byte[] qualifier, long ts, byte[] value) {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)FromClientSideBase.equals(row, result.getRow()));
        Assert.assertEquals((String)("Expected a single key but result contains " + result.size()), (long)1L, (long)result.size());
        Cell kv = result.rawCells()[0];
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kv)) + "]"), (boolean)FromClientSideBase.equals(family, CellUtil.cloneFamily((Cell)kv)));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv)) + "]"), (boolean)FromClientSideBase.equals(qualifier, CellUtil.cloneQualifier((Cell)kv)));
        Assert.assertEquals((String)("Expected ts [" + ts + "] Got ts [" + kv.getTimestamp() + "]"), (long)ts, (long)kv.getTimestamp());
        Assert.assertTrue((String)("Expected value [" + Bytes.toString((byte[])value) + "] Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)) + "]"), (boolean)FromClientSideBase.equals(value, CellUtil.cloneValue((Cell)kv)));
    }

    protected void assertEmptyResult(Result result) throws Exception {
        Assert.assertTrue((String)("expected an empty result but result contains " + result.size() + " keys"), (boolean)result.isEmpty());
    }

    protected void assertNullResult(Result result) throws Exception {
        Assert.assertNull((String)"expected null result but received a non-null result", (Object)result);
    }

    protected void getVersionRangeAndVerifyGreaterThan(Table ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.readVersions(Integer.MAX_VALUE);
        get.setTimeRange(stamps[start + 1], Long.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, row, family, qualifier, stamps, values, start + 1, end);
    }

    protected void getVersionRangeAndVerify(Table ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.readVersions(Integer.MAX_VALUE);
        get.setTimeRange(stamps[start], stamps[end] + 1L);
        Result result = ht.get(get);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    protected void getAllVersionsAndVerify(Table ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.readVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    protected void scanVersionRangeAndVerifyGreaterThan(Table ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan().withStartRow(row);
        scan.addColumn(family, qualifier);
        scan.readVersions(Integer.MAX_VALUE);
        scan.setTimeRange(stamps[start + 1], Long.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start + 1, end);
    }

    protected void scanVersionRangeAndVerify(Table ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan().withStartRow(row);
        scan.addColumn(family, qualifier);
        scan.readVersions(Integer.MAX_VALUE);
        scan.setTimeRange(stamps[start], stamps[end] + 1L);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    protected void scanAllVersionsAndVerify(Table ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan().withStartRow(row);
        scan.addColumn(family, qualifier);
        scan.readVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    protected void getVersionAndVerify(Table ht, byte[] row, byte[] family, byte[] qualifier, long stamp, byte[] value) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setTimestamp(stamp);
        get.readVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertSingleResult(result, row, family, qualifier, stamp, value);
    }

    protected void getVersionAndVerifyMissing(Table ht, byte[] row, byte[] family, byte[] qualifier, long stamp) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setTimestamp(stamp);
        get.readVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
    }

    protected void scanVersionAndVerify(Table ht, byte[] row, byte[] family, byte[] qualifier, long stamp, byte[] value) throws Exception {
        Scan scan = new Scan().withStartRow(row);
        scan.addColumn(family, qualifier);
        scan.setTimestamp(stamp);
        scan.readVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, qualifier, stamp, value);
    }

    protected void scanVersionAndVerifyMissing(Table ht, byte[] row, byte[] family, byte[] qualifier, long stamp) throws Exception {
        Scan scan = new Scan().withStartRow(row);
        scan.addColumn(family, qualifier);
        scan.setTimestamp(stamp);
        scan.readVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    protected void getTestNull(Table ht, byte[] row, byte[] family, byte[] value) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, null);
        Result result = ht.get(get);
        this.assertSingleResult(result, row, family, null, value);
        get = new Get(row);
        get.addColumn(family, HConstants.EMPTY_BYTE_ARRAY);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        get = new Get(row);
        get.addFamily(family);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        get = new Get(row);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
    }

    protected void getTestNull(Table ht, byte[] row, byte[] family, long value) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, null);
        Result result = ht.get(get);
        this.assertSingleResult(result, row, family, null, value);
        get = new Get(row);
        get.addColumn(family, HConstants.EMPTY_BYTE_ARRAY);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        get = new Get(row);
        get.addFamily(family);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        get = new Get(row);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
    }

    protected void scanTestNull(Table ht, byte[] row, byte[] family, byte[] value) throws Exception {
        this.scanTestNull(ht, row, family, value, false);
    }

    protected void scanTestNull(Table ht, byte[] row, byte[] family, byte[] value, boolean isReversedScan) throws Exception {
        Scan scan = new Scan();
        scan.setReversed(isReversedScan);
        scan.addColumn(family, null);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        scan = new Scan();
        scan.setReversed(isReversedScan);
        scan.addColumn(family, HConstants.EMPTY_BYTE_ARRAY);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        scan = new Scan();
        scan.setReversed(isReversedScan);
        scan.addFamily(family);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        scan = new Scan();
        scan.setReversed(isReversedScan);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
    }

    protected void singleRowGetTest(Table ht, byte[][] ROWS, byte[][] FAMILIES, byte[][] QUALIFIERS, byte[][] VALUES) throws Exception {
        Get get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[0]);
        Result result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[7]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[7], QUALIFIERS[7], VALUES[7]);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[4]);
        result = ht.get(get);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = ht.get(get);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[4]);
        get.addFamily(FAMILIES[7]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{4, 0, 0}, {4, 4, 4}, {7, 7, 7}});
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[2]);
        get.addFamily(FAMILIES[4]);
        get.addFamily(FAMILIES[6]);
        get.addFamily(FAMILIES[7]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[2], QUALIFIERS[2]);
        get.addColumn(FAMILIES[2], QUALIFIERS[4]);
        get.addColumn(FAMILIES[4], QUALIFIERS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[4]);
        get.addColumn(FAMILIES[6], QUALIFIERS[6]);
        get.addColumn(FAMILIES[6], QUALIFIERS[7]);
        get.addColumn(FAMILIES[7], QUALIFIERS[7]);
        get.addColumn(FAMILIES[7], QUALIFIERS[8]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        get = new Get(ROWS[0]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}, {9, 0, 0}});
        get = new Get(ROWS[1]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[3]);
        get.addColumn(FAMILIES[2], QUALIFIERS[3]);
        result = ht.get(get);
        this.assertEmptyResult(result);
    }

    protected void singleRowScanTest(Table ht, byte[][] ROWS, byte[][] FAMILIES, byte[][] QUALIFIERS, byte[][] VALUES) throws Exception {
        Scan scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0]);
        scan = new Scan();
        scan.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        scan = new Scan();
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[7], QUALIFIERS[7], VALUES[7]);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{4, 0, 0}, {4, 4, 4}, {7, 7, 7}});
        scan = new Scan();
        scan.addFamily(FAMILIES[2]);
        scan.addFamily(FAMILIES[4]);
        scan.addFamily(FAMILIES[6]);
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        scan = new Scan();
        scan.addColumn(FAMILIES[2], QUALIFIERS[2]);
        scan.addColumn(FAMILIES[2], QUALIFIERS[4]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        scan.addColumn(FAMILIES[6], QUALIFIERS[7]);
        scan.addColumn(FAMILIES[7], QUALIFIERS[7]);
        scan.addColumn(FAMILIES[7], QUALIFIERS[8]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}, {9, 0, 0}});
        scan = new Scan().withStartRow(ROWS[1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[3]);
        scan.addColumn(FAMILIES[2], QUALIFIERS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    protected void getVerifySingleColumn(Table ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX, byte[][] VALUES, int VALUEIDX) throws Exception {
        Get get = new Get(ROWS[ROWIDX]);
        Result result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[FAMILYIDX - 2]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        get.addFamily(FAMILIES[FAMILYIDX + 2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[0]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[1]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        get.addColumn(FAMILIES[FAMILYIDX + 1], QUALIFIERS[1]);
        get.addColumn(FAMILIES[FAMILYIDX - 2], QUALIFIERS[1]);
        get.addFamily(FAMILIES[FAMILYIDX - 1]);
        get.addFamily(FAMILIES[FAMILYIDX + 2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
    }

    protected void scanVerifySingleColumn(Table ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX, byte[][] VALUES, int VALUEIDX) throws Exception {
        Scan scan = new Scan();
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan().withStartRow(ROWS[ROWIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan().withStartRow(ROWS[ROWIDX]).withStopRow(ROWS[ROWIDX + 1], true);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan().withStartRow(HConstants.EMPTY_START_ROW).withStopRow(ROWS[ROWIDX + 1], true);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addFamily(FAMILIES[FAMILYIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addFamily(FAMILIES[FAMILYIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX - 1], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX]);
        scan.addFamily(FAMILIES[FAMILYIDX + 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
    }

    protected void getVerifySingleEmpty(Table ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX) throws Exception {
        Get get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[4]);
        get.addColumn(FAMILIES[4], QUALIFIERS[1]);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[4]);
        get.addColumn(FAMILIES[4], QUALIFIERS[2]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[3]);
        get.addColumn(FAMILIES[4], QUALIFIERS[2]);
        get.addFamily(FAMILIES[5]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[ROWIDX + 1]);
        result = ht.get(get);
        this.assertEmptyResult(result);
    }

    protected void scanVerifySingleEmpty(Table ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX) throws Exception {
        Scan scan = new Scan().withStartRow(ROWS[ROWIDX + 1]);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan().withStartRow(ROWS[ROWIDX + 1]).withStopRow(ROWS[ROWIDX + 2], true);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan().withStartRow(HConstants.EMPTY_START_ROW).withStopRow(ROWS[ROWIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addFamily(FAMILIES[FAMILYIDX - 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    static {
        ROW = Bytes.toBytes((String)"testRow");
        FAMILY = Bytes.toBytes((String)"testFamily");
        INVALID_FAMILY = Bytes.toBytes((String)"invalidTestFamily");
        QUALIFIER = Bytes.toBytes((String)"testQualifier");
        VALUE = Bytes.toBytes((String)"testValue");
        SLAVES = 1;
    }
}

