/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.CloneSnapshotFromClientTestBase;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Test;

public class CloneSnapshotFromClientNormalTestBase
extends CloneSnapshotFromClientTestBase {
    @Test
    public void testCloneSnapshot() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf((String)(this.getValidMethodName() + "-" + EnvironmentEdgeManager.currentTime()));
        this.testCloneSnapshot(clonedTableName, this.snapshotName0, this.snapshot0Rows);
        this.testCloneSnapshot(clonedTableName, this.snapshotName1, this.snapshot1Rows);
        this.testCloneSnapshot(clonedTableName, this.emptySnapshot, 0);
    }

    private void testCloneSnapshot(TableName tableName, String snapshotName, int snapshotRows) throws IOException, InterruptedException {
        this.admin.cloneSnapshot(snapshotName, tableName);
        this.verifyRowCount(TEST_UTIL, tableName, snapshotRows);
        this.verifyReplicasCameOnline(tableName);
        TEST_UTIL.deleteTable(tableName);
    }

    private void verifyReplicasCameOnline(TableName tableName) throws IOException {
        SnapshotTestingUtils.verifyReplicasCameOnline(tableName, this.admin, this.getNumReplicas());
    }

    @Test
    public void testCloneSnapshotCrossNamespace() throws IOException, InterruptedException {
        String nsName = this.getValidMethodName() + "_ns_" + EnvironmentEdgeManager.currentTime();
        this.admin.createNamespace(NamespaceDescriptor.create((String)nsName).build());
        TableName clonedTableName = TableName.valueOf((String)nsName, (String)(this.getValidMethodName() + "-" + EnvironmentEdgeManager.currentTime()));
        this.testCloneSnapshot(clonedTableName, this.snapshotName0, this.snapshot0Rows);
        this.testCloneSnapshot(clonedTableName, this.snapshotName1, this.snapshot1Rows);
        this.testCloneSnapshot(clonedTableName, this.emptySnapshot, 0);
    }
}

