/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractTestCITimeout;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestCIOperationTimeout
extends AbstractTestCITimeout {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestCIOperationTimeout.class);
    private TableName tableName;

    @Before
    public void setUp() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)this.tableName).setCoprocessor(AbstractTestCITimeout.SleepAndFailFirstTime.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAM_NAM)).build();
        TEST_UTIL.getAdmin().createTable(htd);
    }

    protected abstract void execute(Table var1) throws IOException;

    @Test
    public void testOperationTimeout() throws IOException {
        TableBuilder builder = TEST_UTIL.getConnection().getTableBuilder(this.tableName, null).setRpcTimeout(Integer.MAX_VALUE).setReadRpcTimeout(Integer.MAX_VALUE).setWriteRpcTimeout(Integer.MAX_VALUE);
        AbstractTestCITimeout.SleepAndFailFirstTime.ct.set(0L);
        try (Table table = builder.setOperationTimeout(120000).build();){
            this.execute(table);
        }
        AbstractTestCITimeout.SleepAndFailFirstTime.ct.set(0L);
        try {
            table = builder.setOperationTimeout(30000).build();
            var3_4 = null;
            try {
                AbstractTestCITimeout.SleepAndFailFirstTime.ct.set(0L);
                this.execute(table);
                Assert.fail((String)"We expect an exception here");
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (table != null) {
                    if (var3_4 != null) {
                        try {
                            table.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        table.close();
                    }
                }
            }
        }
        catch (SocketTimeoutException | RetriesExhaustedException e) {
            LOG.info("We received an exception, as expected ", e);
        }
    }
}

