/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestServerMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestServerMetrics.class);

    @Test
    public void testRegionLoadAggregation() {
        ServerMetrics metrics = ServerMetricsBuilder.toServerMetrics((ServerName)ServerName.valueOf((String)"localhost,1,1"), (ClusterStatusProtos.ServerLoad)this.createServerLoadProto());
        Assert.assertEquals((long)13L, (long)metrics.getRegionMetrics().values().stream().mapToInt(v -> v.getStoreCount()).sum());
        Assert.assertEquals((long)114L, (long)metrics.getRegionMetrics().values().stream().mapToInt(v -> v.getStoreFileCount()).sum());
        Assert.assertEquals((double)129.0, (double)metrics.getRegionMetrics().values().stream().mapToDouble(v -> v.getUncompressedStoreFileSize().get(Size.Unit.MEGABYTE)).sum(), (double)0.0);
        Assert.assertEquals((double)504.0, (double)metrics.getRegionMetrics().values().stream().mapToDouble(v -> v.getStoreFileRootLevelIndexSize().get(Size.Unit.KILOBYTE)).sum(), (double)0.0);
        Assert.assertEquals((double)820.0, (double)metrics.getRegionMetrics().values().stream().mapToDouble(v -> v.getStoreFileSize().get(Size.Unit.MEGABYTE)).sum(), (double)0.0);
        Assert.assertEquals((double)82.0, (double)metrics.getRegionMetrics().values().stream().mapToDouble(v -> v.getStoreFileIndexSize().get(Size.Unit.KILOBYTE)).sum(), (double)0.0);
        Assert.assertEquals((long)0xFFFFFFFEL, (long)metrics.getRegionMetrics().values().stream().mapToLong(v -> v.getReadRequestCount()).sum());
        Assert.assertEquals((long)100L, (long)metrics.getRegionMetrics().values().stream().mapToLong(v -> v.getCpRequestCount()).sum());
        Assert.assertEquals((long)300L, (long)metrics.getRegionMetrics().values().stream().mapToLong(v -> v.getFilteredReadRequestCount()).sum());
        Assert.assertEquals((long)2L, (long)metrics.getRegionMetrics().values().stream().mapToLong(v -> (long)v.getCurrentRegionCachedRatio()).count());
        Assert.assertEquals((double)150.0, (double)metrics.getRegionMetrics().values().stream().mapToDouble(v -> v.getRegionSizeMB().get(Size.Unit.MEGABYTE)).sum(), (double)0.0);
    }

    @Test
    public void testToString() {
        ServerMetrics metrics = ServerMetricsBuilder.toServerMetrics((ServerName)ServerName.valueOf((String)"localhost,1,1"), (ClusterStatusProtos.ServerLoad)this.createServerLoadProto());
        String slToString = metrics.toString();
        Assert.assertTrue((boolean)slToString.contains("numberOfStores=13"));
        Assert.assertTrue((boolean)slToString.contains("numberOfStorefiles=114"));
        Assert.assertTrue((boolean)slToString.contains("storefileUncompressedSizeMB=129"));
        Assert.assertTrue((boolean)slToString.contains("storefileSizeMB=820"));
        Assert.assertTrue((boolean)slToString.contains("rootIndexSizeKB=504"));
        Assert.assertTrue((boolean)slToString.contains("coprocessors=[]"));
        Assert.assertTrue((boolean)slToString.contains("filteredReadRequestsCount=300"));
    }

    @Test
    public void testRegionLoadWrapAroundAggregation() {
        ServerMetrics metrics = ServerMetricsBuilder.toServerMetrics((ServerName)ServerName.valueOf((String)"localhost,1,1"), (ClusterStatusProtos.ServerLoad)this.createServerLoadProto());
        long totalCount = 0xFFFFFFFEL;
        Assert.assertEquals((long)totalCount, (long)metrics.getRegionMetrics().values().stream().mapToLong(v -> v.getReadRequestCount()).sum());
        Assert.assertEquals((long)totalCount, (long)metrics.getRegionMetrics().values().stream().mapToLong(v -> v.getWriteRequestCount()).sum());
    }

    private ClusterStatusProtos.ServerLoad createServerLoadProto() {
        HBaseProtos.RegionSpecifier rSpecOne = HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME).setValue(ByteString.copyFromUtf8((String)"ASDFGQWERT")).build();
        HBaseProtos.RegionSpecifier rSpecTwo = HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME).setValue(ByteString.copyFromUtf8((String)"QWERTYUIOP")).build();
        ClusterStatusProtos.RegionLoad rlOne = ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(rSpecOne).setStores(10).setStorefiles(101).setStoreUncompressedSizeMB(106).setStorefileSizeMB(520).setFilteredReadRequestsCount(100L).setStorefileIndexSizeKB(42L).setRootIndexSizeKB(201).setReadRequestsCount(Integer.MAX_VALUE).setWriteRequestsCount(Integer.MAX_VALUE).setRegionSizeMB(100).setCurrentRegionCachedRatio(0.9f).build();
        ClusterStatusProtos.RegionLoad rlTwo = ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(rSpecTwo).setStores(3).setStorefiles(13).setStoreUncompressedSizeMB(23).setStorefileSizeMB(300).setFilteredReadRequestsCount(200L).setStorefileIndexSizeKB(40L).setRootIndexSizeKB(303).setReadRequestsCount(Integer.MAX_VALUE).setWriteRequestsCount(Integer.MAX_VALUE).setCpRequestsCount(100L).setRegionSizeMB(50).setCurrentRegionCachedRatio(1.0f).build();
        ClusterStatusProtos.ServerLoad sl = ClusterStatusProtos.ServerLoad.newBuilder().addRegionLoads(rlOne).addRegionLoads(rlTwo).build();
        return sl;
    }
}

