/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestRegionMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionMetrics.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionMetrics.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static Admin admin;
    private static final TableName TABLE_1;
    private static final TableName TABLE_2;
    private static final TableName TABLE_3;
    private static final TableName[] tables;
    private static final int MSG_INTERVAL = 500;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 500);
        UTIL.startMiniCluster(4);
        admin = UTIL.getAdmin();
        admin.balancerSwitch(false, true);
        byte[] FAMILY = Bytes.toBytes((String)"f");
        for (TableName tableName : tables) {
            Table table = UTIL.createMultiRegionTable(tableName, FAMILY, 16);
            UTIL.waitTableAvailable(tableName);
            UTIL.loadTable(table, FAMILY);
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        for (TableName table : tables) {
            UTIL.deleteTableIfAny(table);
        }
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRegionMetrics() throws Exception {
        for (ServerName serverName : admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
            List regions = admin.getRegions(serverName);
            List regionMetricsList = admin.getRegionMetrics(serverName);
            this.checkRegionsAndRegionMetrics(regions, regionMetricsList);
        }
        for (TableName table : new TableName[]{TABLE_1, TABLE_2, TABLE_3}) {
            List tableRegions = admin.getRegions(table);
            ArrayList<RegionMetrics> regionMetrics = new ArrayList<RegionMetrics>();
            for (ServerName serverName : admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
                regionMetrics.addAll(admin.getRegionMetrics(serverName, table));
            }
            this.checkRegionsAndRegionMetrics(tableRegions, regionMetrics);
        }
        TimeUnit.MILLISECONDS.sleep(1500L);
        for (Map.Entry entry : admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().entrySet()) {
            ServerName serverName = (ServerName)entry.getKey();
            ServerMetrics serverMetrics = (ServerMetrics)entry.getValue();
            List regionMetrics = admin.getRegionMetrics(serverName);
            LOG.debug("serverName=" + serverName + ", getRegionLoads=" + serverMetrics.getRegionMetrics().keySet().stream().map(r -> Bytes.toString((byte[])r)).collect(Collectors.toList()));
            LOG.debug("serverName=" + serverName + ", regionLoads=" + regionMetrics.stream().map(r -> Bytes.toString((byte[])r.getRegionName())).collect(Collectors.toList()));
            Assert.assertEquals((long)serverMetrics.getRegionMetrics().size(), (long)regionMetrics.size());
            this.checkMetricsValue(regionMetrics, serverMetrics);
        }
    }

    private void checkMetricsValue(List<RegionMetrics> regionMetrics, ServerMetrics serverMetrics) throws InvocationTargetException, IllegalAccessException {
        for (RegionMetrics fromRM : regionMetrics) {
            RegionMetrics fromSM = (RegionMetrics)serverMetrics.getRegionMetrics().get(fromRM.getRegionName());
            Class<RegionMetrics> clazz = RegionMetrics.class;
            for (Method method : clazz.getMethods()) {
                if (!method.getReturnType().equals(Size.class) && !method.getReturnType().equals(Integer.TYPE) && !method.getReturnType().equals(Long.TYPE) && !method.getReturnType().equals(Float.TYPE)) continue;
                Object valueRm = method.invoke((Object)fromRM, new Object[0]);
                Object valueSM = method.invoke((Object)fromSM, new Object[0]);
                Assert.assertEquals((String)("Return values of method " + method.getName() + " are different"), (Object)valueRm.toString(), (Object)valueSM.toString());
            }
        }
    }

    private void checkRegionsAndRegionMetrics(Collection<RegionInfo> regions, Collection<RegionMetrics> regionMetrics) {
        Assert.assertEquals((String)"No of regions and regionMetrics doesn't match", (long)regions.size(), (long)regionMetrics.size());
        TreeMap regionMetricsMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        for (RegionMetrics r : regionMetrics) {
            regionMetricsMap.put(r.getRegionName(), r);
        }
        for (RegionInfo info : regions) {
            Assert.assertTrue((String)("Region not in RegionMetricsMap region:" + info.getRegionNameAsString() + " regionMap: " + regionMetricsMap), (boolean)regionMetricsMap.containsKey(info.getRegionName()));
        }
    }

    static {
        TABLE_1 = TableName.valueOf((String)"table_1");
        TABLE_2 = TableName.valueOf((String)"table_2");
        TABLE_3 = TableName.valueOf((String)"table_3");
        tables = new TableName[]{TABLE_1, TABLE_2, TABLE_3};
    }
}

