/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseClusterInterface;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceExistException;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestNamespace {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNamespace.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestNamespace.class);
    private static HMaster master;
    protected static final int NUM_SLAVES_BASE = 4;
    private static HBaseTestingUtil TEST_UTIL;
    protected static Admin admin;
    protected static HBaseClusterInterface cluster;
    private String prefix = "TestNamespace";
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL = new HBaseTestingUtil();
        TEST_UTIL.startMiniCluster(4);
        admin = TEST_UTIL.getAdmin();
        cluster = TEST_UTIL.getHBaseCluster();
        master = ((SingleProcessHBaseCluster)cluster).getMaster();
        LOG.info("Done initializing cluster");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void beforeMethod() throws IOException {
        for (TableDescriptor desc : admin.listTableDescriptors(Pattern.compile(this.prefix + ".*"))) {
            admin.disableTable(desc.getTableName());
            admin.deleteTable(desc.getTableName());
        }
        for (NamespaceDescriptor ns : admin.listNamespaceDescriptors()) {
            if (!ns.getName().startsWith(this.prefix)) continue;
            admin.deleteNamespace(ns.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyReservedNS() throws IOException {
        NamespaceDescriptor ns = admin.getNamespaceDescriptor(NamespaceDescriptor.DEFAULT_NAMESPACE.getName());
        Assert.assertNotNull((Object)ns);
        Assert.assertEquals((Object)ns.getName(), (Object)NamespaceDescriptor.DEFAULT_NAMESPACE.getName());
        ns = admin.getNamespaceDescriptor(NamespaceDescriptor.SYSTEM_NAMESPACE.getName());
        Assert.assertNotNull((Object)ns);
        Assert.assertEquals((Object)ns.getName(), (Object)NamespaceDescriptor.SYSTEM_NAMESPACE.getName());
        Assert.assertEquals((long)2L, (long)admin.listNamespaces().length);
        Assert.assertEquals((long)2L, (long)admin.listNamespaceDescriptors().length);
        HashSet systemTables = Sets.newHashSet((Object[])new TableName[]{TableName.META_TABLE_NAME});
        List descs = admin.listTableDescriptorsByNamespace(Bytes.toBytes((String)NamespaceDescriptor.SYSTEM_NAMESPACE.getName()));
        Assert.assertEquals((long)systemTables.size(), (long)descs.size());
        for (TableDescriptor desc : descs) {
            Assert.assertTrue((boolean)systemTables.contains(desc.getTableName()));
        }
        Assert.assertEquals((long)0L, (long)admin.listTableDescriptors().size());
        boolean exceptionCaught = false;
        try {
            admin.createNamespace(NamespaceDescriptor.DEFAULT_NAMESPACE);
        }
        catch (IOException exp) {
            LOG.warn(exp.toString(), (Throwable)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
        exceptionCaught = false;
        try {
            admin.createNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE);
        }
        catch (IOException exp) {
            LOG.warn(exp.toString(), (Throwable)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteReservedNS() throws Exception {
        boolean exceptionCaught = false;
        try {
            admin.deleteNamespace(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR);
        }
        catch (IOException exp) {
            LOG.warn(exp.toString(), (Throwable)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
        try {
            admin.deleteNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR);
        }
        catch (IOException exp) {
            LOG.warn(exp.toString(), (Throwable)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    @Test
    public void createRemoveTest() throws Exception {
        String nsName = this.prefix + "_" + this.name.getMethodName();
        LOG.info(this.name.getMethodName());
        admin.createNamespace(NamespaceDescriptor.create((String)nsName).build());
        Assert.assertEquals((long)3L, (long)admin.listNamespaces().length);
        Assert.assertEquals((long)3L, (long)admin.listNamespaceDescriptors().length);
        admin.deleteNamespace(nsName);
        Assert.assertEquals((long)2L, (long)admin.listNamespaces().length);
        Assert.assertEquals((long)2L, (long)admin.listNamespaceDescriptors().length);
    }

    @Test
    public void createDoubleTest() throws IOException, InterruptedException {
        String nsName = this.prefix + "_" + this.name.getMethodName();
        LOG.info(this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName tableNameFoo = TableName.valueOf((String)(nsName + ":" + this.name.getMethodName()));
        admin.createNamespace(NamespaceDescriptor.create((String)nsName).build());
        TEST_UTIL.createTable(tableName, Bytes.toBytes((String)nsName));
        TEST_UTIL.createTable(tableNameFoo, Bytes.toBytes((String)nsName));
        Assert.assertEquals((long)2L, (long)admin.listTableDescriptors().size());
        Assert.assertNotNull((Object)admin.getDescriptor(tableName));
        Assert.assertNotNull((Object)admin.getDescriptor(tableNameFoo));
        admin.disableTable(tableName);
        admin.deleteTable(tableName);
        Assert.assertEquals((long)1L, (long)admin.listTableDescriptors().size());
    }

    @Test
    public void createTableTest() throws IOException, InterruptedException {
        String nsName = this.prefix + "_" + this.name.getMethodName();
        LOG.info(this.name.getMethodName());
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(nsName + ":" + this.name.getMethodName())));
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"my_cf")).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        TableDescriptor tableDescriptor = tableDescriptorBuilder.build();
        try {
            admin.createTable(tableDescriptor);
            Assert.fail((String)"Expected no namespace exists exception");
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
        admin.createNamespace(NamespaceDescriptor.create((String)nsName).build());
        admin.createTable(tableDescriptor);
        TEST_UTIL.waitTableAvailable(tableDescriptor.getTableName().getName(), 10000L);
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Assert.assertTrue((boolean)fs.exists(new Path(master.getMasterFileSystem().getRootDir(), new Path("data", new Path(nsName, tableDescriptor.getTableName().getQualifierAsString())))));
        Assert.assertEquals((long)1L, (long)admin.listTableDescriptors().size());
        try {
            admin.deleteNamespace(nsName);
            Assert.fail((String)"Expected non-empty namespace constraint exception");
        }
        catch (Exception ex) {
            LOG.info("Caught expected exception: " + ex);
        }
        Table table = TEST_UTIL.getConnection().getTable(tableDescriptor.getTableName());
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.addColumn(Bytes.toBytes((String)"my_cf"), Bytes.toBytes((String)"my_col"), Bytes.toBytes((String)"value1"));
        table.put(p);
        admin.flush(tableDescriptor.getTableName());
        Get g = new Get(Bytes.toBytes((String)"row1"));
        Assert.assertTrue((boolean)table.exists(g));
        TEST_UTIL.deleteTable(tableDescriptor.getTableName());
        admin.deleteNamespace(nsName);
    }

    @Test
    public void createTableInDefaultNamespace() throws Exception {
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName()));
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"cf1")).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        TableDescriptor tableDescriptor = tableDescriptorBuilder.build();
        admin.createTable(tableDescriptor);
        Assert.assertTrue((admin.listTableDescriptors().size() == 1 ? 1 : 0) != 0);
        admin.disableTable(tableDescriptor.getTableName());
        admin.deleteTable(tableDescriptor.getTableName());
    }

    @Test
    public void createTableInSystemNamespace() throws Exception {
        TableName tableName = TableName.valueOf((String)("hbase:" + this.name.getMethodName()));
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"cf1")).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        TableDescriptor tableDescriptor = tableDescriptorBuilder.build();
        admin.createTable(tableDescriptor);
        Assert.assertEquals((long)0L, (long)admin.listTableDescriptors().size());
        Assert.assertTrue((boolean)admin.tableExists(tableName));
        admin.disableTable(tableDescriptor.getTableName());
        admin.deleteTable(tableDescriptor.getTableName());
    }

    @Test
    public void testNamespaceOperations() throws IOException {
        admin.createNamespace(NamespaceDescriptor.create((String)(this.prefix + "ns1")).build());
        admin.createNamespace(NamespaceDescriptor.create((String)(this.prefix + "ns2")).build());
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.createNamespace(NamespaceDescriptor.create((String)(TestNamespace.this.prefix + "ns1")).build());
                return null;
            }
        }, NamespaceExistException.class);
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"non_existing_namespace", (String)TestNamespace.this.name.getMethodName()));
                ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"family1")).build();
                tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
                admin.createTable(tableDescriptorBuilder.build());
                return null;
            }
        }, NamespaceNotFoundException.class);
        admin.getNamespaceDescriptor(this.prefix + "ns1");
        TestNamespace.runWithExpectedException(new Callable<NamespaceDescriptor>(){

            @Override
            public NamespaceDescriptor call() throws Exception {
                return admin.getNamespaceDescriptor("non_existing_namespace");
            }
        }, NamespaceNotFoundException.class);
        admin.deleteNamespace(this.prefix + "ns2");
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.deleteNamespace("non_existing_namespace");
                return null;
            }
        }, NamespaceNotFoundException.class);
        NamespaceDescriptor ns1 = admin.getNamespaceDescriptor(this.prefix + "ns1");
        ns1.setConfiguration("foo", "bar");
        admin.modifyNamespace(ns1);
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.modifyNamespace(NamespaceDescriptor.create((String)"non_existing_namespace").build());
                return null;
            }
        }, NamespaceNotFoundException.class);
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(this.prefix + "ns1"), (String)this.name.getMethodName()));
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"family1")).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        admin.createTable(tableDescriptorBuilder.build());
        List htds = admin.listTableDescriptorsByNamespace(Bytes.toBytes((String)(this.prefix + "ns1")));
        Assert.assertNotNull((String)"Should have not returned null", (Object)htds);
        Assert.assertEquals((String)"Should have returned non-empty array", (long)1L, (long)htds.size());
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.listTableDescriptorsByNamespace(Bytes.toBytes((String)"non_existant_namespace"));
                return null;
            }
        }, NamespaceNotFoundException.class);
        TableName[] tableNames = admin.listTableNamesByNamespace(this.prefix + "ns1");
        Assert.assertNotNull((String)"Should have not returned null", (Object)tableNames);
        Assert.assertEquals((String)"Should have returned non-empty array", (long)1L, (long)tableNames.length);
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.listTableNamesByNamespace("non_existing_namespace");
                return null;
            }
        }, NamespaceNotFoundException.class);
    }

    private static <V, E> void runWithExpectedException(Callable<V> callable, Class<E> exceptionClass) {
        try {
            callable.call();
        }
        catch (Exception ex) {
            Assert.assertEquals(exceptionClass, ex.getClass());
            return;
        }
        Assert.fail((String)("Should have thrown exception " + exceptionClass));
    }
}

