/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestInfoServers {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestInfoServers.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestInfoServers.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setInt("hbase.master.info.port", 0);
        UTIL.getConfiguration().setInt("hbase.regionserver.info.port", 0);
        UTIL.getConfiguration().setBoolean("hbase.master.ui.readonly", true);
        UTIL.startMiniCluster();
        if (!UTIL.getHBaseCluster().waitForActiveAndReadyMaster(30000L)) {
            throw new RuntimeException("Active master not ready");
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testGetMasterInfoPort() throws Exception {
        try (Admin admin = UTIL.getAdmin();){
            Assert.assertEquals((long)UTIL.getHBaseCluster().getMaster().getInfoServer().getPort(), (long)admin.getMasterInfoPort());
        }
    }

    @Test
    public void testInfoServersRedirect() throws Exception {
        UTIL.getConnection().getTable(TableName.META_TABLE_NAME).close();
        int port = UTIL.getHBaseCluster().getMaster().getInfoServer().getPort();
        this.assertContainsContent(new URL("http://localhost:" + port + "/index.html"), "master-status");
        port = UTIL.getHBaseCluster().getRegionServerThreads().get(0).getRegionServer().getInfoServer().getPort();
        this.assertContainsContent(new URL("http://localhost:" + port + "/index.html"), "rs-status");
    }

    @Test
    public void testInfoServersStatusPages() throws Exception {
        int port = UTIL.getHBaseCluster().getMaster().getInfoServer().getPort();
        this.assertContainsContent(new URL("http://localhost:" + port + "/master-status"), "meta");
        port = UTIL.getHBaseCluster().getRegionServerThreads().get(0).getRegionServer().getInfoServer().getPort();
        this.assertContainsContent(new URL("http://localhost:" + port + "/rs-status"), "meta");
    }

    @Test
    public void testMasterServerReadOnly() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] cf = Bytes.toBytes((String)"d");
        UTIL.createTable(tableName, cf);
        UTIL.waitTableAvailable(tableName);
        HMaster master = UTIL.getHBaseCluster().getMaster();
        int port = master.getRegionServerInfoPort(master.getServerName());
        this.assertDoesNotContainContent(new URL("http://localhost:" + port + "/table.jsp?name=" + tableName + "&action=split&key="), "Table action request accepted");
        this.assertDoesNotContainContent(new URL("http://localhost:" + port + "/table.jsp?name=" + tableName), "Actions:");
    }

    private void assertContainsContent(URL u, String expected) throws IOException {
        LOG.info("Testing " + u.toString() + " has " + expected);
        String content = this.getUrlContent(u);
        Assert.assertTrue((String)("expected=" + expected + ", content=" + content), (boolean)content.contains(expected));
    }

    private void assertDoesNotContainContent(URL u, String expected) throws IOException {
        LOG.info("Testing " + u.toString() + " does not have " + expected);
        String content = this.getUrlContent(u);
        Assert.assertFalse((String)("Does Not Contain =" + expected + ", content=" + content), (boolean)content.contains(expected));
    }

    private String getUrlContent(URL u) throws IOException {
        URLConnection c = u.openConnection();
        c.setConnectTimeout(20000);
        c.setReadTimeout(20000);
        c.connect();
        try (InputStream in = c.getInputStream();){
            String string = IOUtils.toString((InputStream)in, (String)"UTF-8");
            return string;
        }
    }
}

