/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.util.Locale;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestIPv6NIOServerSocketChannel {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestIPv6NIOServerSocketChannel.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestIPv6NIOServerSocketChannel.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindServerSocket(InetAddress inetAddr) throws IOException {
        while (true) {
            int port = HBaseTestingUtil.randomFreePort();
            InetSocketAddress addr = new InetSocketAddress(inetAddr, port);
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket();
                serverSocket.bind(addr);
            }
            catch (BindException ex) {
                LOG.info("Failed on " + addr + ", inedAddr=" + inetAddr, (Throwable)ex);
                continue;
            }
            finally {
                if (serverSocket == null) continue;
                serverSocket.close();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindNIOServerSocket(InetAddress inetAddr) throws IOException {
        while (true) {
            int port = HBaseTestingUtil.randomFreePort();
            InetSocketAddress addr = new InetSocketAddress(inetAddr, port);
            ServerSocketChannel channel = null;
            ServerSocket serverSocket = null;
            try {
                channel = ServerSocketChannel.open();
                serverSocket = channel.socket();
                serverSocket.bind(addr);
                break;
            }
            catch (BindException bindException) {}
            continue;
            finally {
                if (serverSocket != null) {
                    serverSocket.close();
                }
                if (channel == null) continue;
                channel.close();
                continue;
            }
            break;
        }
    }

    @Test
    public void testServerSocket() throws IOException {
        byte[] addr = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        InetAddress inetAddr = InetAddress.getByAddress(addr);
        try {
            this.bindServerSocket(inetAddr);
            this.bindNIOServerSocket(inetAddr);
        }
        catch (SocketException ex) {
            Assert.assertFalse((boolean)(ex instanceof BindException));
            Assert.assertTrue((boolean)ex.getMessage().toLowerCase(Locale.ROOT).contains("protocol family"));
            LOG.info("Received expected exception:", (Throwable)ex);
            this.ensurePreferIPv4();
        }
    }

    public void ensurePreferIPv4() throws IOException {
        InetAddress[] addrs;
        for (InetAddress addr : addrs = InetAddress.getAllByName("localhost")) {
            LOG.info("resolved localhost as:" + addr);
            Assert.assertEquals((long)4L, (long)addr.getAddress().length);
        }
    }

    @Test
    public void testServerSocketFromLocalhostResolution() throws IOException {
        InetAddress[] addrs;
        for (InetAddress addr : addrs = new InetAddress[]{InetAddress.getLocalHost()}) {
            LOG.info("Resolved localhost as: " + addr);
            this.bindServerSocket(addr);
            this.bindNIOServerSocket(addr);
        }
    }

    public static void main(String[] args) throws Exception {
        TestIPv6NIOServerSocketChannel test = new TestIPv6NIOServerSocketChannel();
        test.testServerSocket();
        test.testServerSocketFromLocalhostResolution();
    }
}

