/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestHBaseOnOtherDfsCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseOnOtherDfsCluster.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testOveralyOnOtherCluster() throws Exception {
        HBaseTestingUtil util1 = new HBaseTestingUtil();
        MiniDFSCluster dfs = util1.startMiniDFSCluster(1);
        HBaseTestingUtil util2 = new HBaseTestingUtil();
        util2.setDFSCluster(dfs, false);
        util2.startMiniCluster();
        DistributedFileSystem fs = dfs.getFileSystem();
        DistributedFileSystem targetFs = util2.getDFSCluster().getFileSystem();
        this.assertFsSameUri((FileSystem)fs, (FileSystem)targetFs);
        fs = FileSystem.get((Configuration)util1.getConfiguration());
        targetFs = FileSystem.get((Configuration)util2.getConfiguration());
        this.assertFsSameUri((FileSystem)fs, (FileSystem)targetFs);
        Path randomFile = new Path("/" + util1.getRandomUUID());
        Assert.assertTrue((boolean)targetFs.createNewFile(randomFile));
        Assert.assertTrue((boolean)fs.exists(randomFile));
        byte[] family = Bytes.toBytes((String)"testfamily");
        TableName tablename = TableName.valueOf((String)this.name.getMethodName());
        Table table = util2.createTable(tablename, family);
        Put p = new Put(new byte[]{1, 2, 3});
        p.addColumn(family, null, new byte[]{1});
        table.put(p);
        util2.shutdownMiniCluster();
        util1.shutdownMiniDFSCluster();
    }

    private void assertFsSameUri(FileSystem sourceFs, FileSystem targetFs) {
        Path source = new Path(sourceFs.getUri());
        Path target = new Path(targetFs.getUri());
        Assert.assertEquals((Object)source, (Object)target);
    }
}

