/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MiscTests.class, MediumTests.class})
public class TestColumnFamilyDescriptorDefaultVersions {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestColumnFamilyDescriptorDefaultVersions.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static TableName TABLE_NAME = null;
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf0");

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @Before
    public void setup() {
        TABLE_NAME = TableName.valueOf((String)this.name.getMethodName());
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCreateTableWithDefault() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
        admin.createTable(tableDescriptor);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyHColumnDescriptor(1, TABLE_NAME, new byte[][]{FAMILY});
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    @Test
    public void testCreateTableWithDefaultFromConf() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        TEST_UTIL.getConfiguration().setInt("hbase.column.max.version", 3);
        TEST_UTIL.startMiniCluster(1);
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setMaxVersions(TEST_UTIL.getConfiguration().getInt("hbase.column.max.version", 1)).build()).build();
        admin.createTable(tableDescriptor);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyHColumnDescriptor(3, TABLE_NAME, new byte[][]{FAMILY});
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    @Test
    public void testCreateTableWithSetVersion() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        TEST_UTIL.getConfiguration().setInt("hbase.column.max.version", 3);
        TEST_UTIL.startMiniCluster(1);
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setMaxVersions(5).build()).build();
        admin.createTable(tableDescriptor);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyHColumnDescriptor(5, TABLE_NAME, new byte[][]{FAMILY});
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    @Test
    public void testHColumnDescriptorCachedMaxVersions() throws Exception {
        ColumnFamilyDescriptor familyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setMaxVersions(5).build();
        Assert.assertEquals((long)5L, (long)familyDescriptor.getMaxVersions());
        familyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)familyDescriptor).setValue(Bytes.toBytes((String)"VERSIONS"), Bytes.toBytes((String)"8")).build();
        Assert.assertEquals((long)8L, (long)familyDescriptor.getMaxVersions());
    }

    private void verifyHColumnDescriptor(int expected, TableName tableName, byte[] ... families) throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor htd = admin.getDescriptor(tableName);
        ColumnFamilyDescriptor[] hcds = htd.getColumnFamilies();
        this.verifyColumnFamilyDescriptor(expected, hcds, tableName, families);
        MasterFileSystem mfs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path tableDir = CommonFSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)tableName);
        TableDescriptor td = FSTableDescriptors.getTableDescriptorFromFs((FileSystem)mfs.getFileSystem(), (Path)tableDir);
        hcds = td.getColumnFamilies();
        this.verifyColumnFamilyDescriptor(expected, hcds, tableName, families);
    }

    private void verifyColumnFamilyDescriptor(int expected, ColumnFamilyDescriptor[] hcds, TableName tableName, byte[] ... families) {
        for (ColumnFamilyDescriptor hcd : hcds) {
            Assert.assertEquals((long)expected, (long)hcd.getMaxVersions());
        }
    }
}

