/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.errorprone.annotations.RestrictedApi;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.metrics.impl.FastLongHistogram;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionReplicationLagEvaluation
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(RegionReplicationLagEvaluation.class);
    public static final String TABLE_NAME = "TestLagTable";
    public static final String FAMILY_NAME = "info";
    public static final String QUALIFIER_NAME = "qual";
    public static final int VALUE_LENGTH = 256;
    public static final int ROW_LENGTH = 16;
    private static final Options OPTIONS = new Options().addOption("t", "table", true, "Table name").addOption("rlen", "rlength", true, "The length of row key").addOption("vlen", "vlength", true, "The length of value").addRequiredOption("r", "rows", true, "Number of rows to test");
    private FastLongHistogram histogram = new FastLongHistogram();

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    FastLongHistogram getHistogram() {
        return this.histogram;
    }

    public int run(String[] args) throws Exception {
        int rows;
        int vlen;
        int rlen;
        TableName tableName;
        try {
            CommandLine cli = new DefaultParser().parse(OPTIONS, args);
            tableName = TableName.valueOf((String)cli.getOptionValue("t", TABLE_NAME));
            rlen = Integer.parseInt(cli.getOptionValue("rlen", String.valueOf(16)));
            vlen = Integer.parseInt(cli.getOptionValue("vlen", String.valueOf(256)));
            rows = Integer.parseInt(cli.getOptionValue("r"));
        }
        catch (Exception e) {
            LOG.warn("Error parsing command line options", (Throwable)e);
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), OPTIONS);
            return -1;
        }
        this.exec(tableName, rlen, vlen, rows);
        return 0;
    }

    private void createTable(Admin admin, TableName tableName) throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)FAMILY_NAME)).setRegionReplication(2).build();
        admin.createTable(td);
    }

    private void checkLag(Table table, int rlen, int vlen, int rows) throws IOException {
        byte[] family = Bytes.toBytes((String)FAMILY_NAME);
        byte[] qualifier = Bytes.toBytes((String)QUALIFIER_NAME);
        LOG.info("Test replication lag on table {} with {} rows", (Object)table.getName(), (Object)rows);
        for (int i = 0; i < rows; ++i) {
            Result result;
            byte[] gotValue;
            byte[] row = new byte[rlen];
            Bytes.random((byte[])row);
            byte[] value = new byte[vlen];
            Bytes.random((byte[])value);
            table.put(new Put(row).addColumn(family, qualifier, value));
            Get get = new Get(row).setConsistency(Consistency.TIMELINE).setReplicaId(1);
            long startNs = System.nanoTime();
            int retry = 0;
            while (!Arrays.equals(value, gotValue = (result = table.get(get)).getValue(family, qualifier))) {
                long pauseTimeMs = Math.min(ConnectionUtils.getPauseTime((long)1L, (int)retry), 1000L);
                Threads.sleepWithoutInterrupt((long)pauseTimeMs);
                ++retry;
            }
            long lagMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            this.histogram.add(lagMs, 1L);
        }
        LOG.info("Test finished, min lag {} ms, max lag {} ms, mean lag {} ms", new Object[]{this.histogram.getMin(), this.histogram.getMax(), this.histogram.getMean()});
        long[] q = this.histogram.getQuantiles(FastLongHistogram.DEFAULT_QUANTILES);
        for (int i = 0; i < q.length; ++i) {
            LOG.info("{}% lag: {} ms", (Object)(FastLongHistogram.DEFAULT_QUANTILES[i] * 100.0), (Object)q[i]);
        }
    }

    private void exec(TableName tableName, int rlen, int vlen, int rows) throws IOException {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.getConf());){
            try (Admin admin = conn.getAdmin();){
                if (!admin.tableExists(tableName)) {
                    this.createTable(admin, tableName);
                }
            }
            var8_10 = null;
            try (Table table = conn.getTable(tableName);){
                this.checkLag(table, rlen, vlen, rows);
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new RegionReplicationLagEvaluation(), (String[])args);
        System.exit(res);
    }
}

