/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AcidGuaranteesTestTool;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AcidGuaranteesTestBase {
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private AcidGuaranteesTestTool tool = new AcidGuaranteesTestTool();

    protected abstract MemoryCompactionPolicy getMemoryCompactionPolicy();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.hregion.memstore.flush.size", String.valueOf(131072));
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        conf.setInt("hfile.format.version", 3);
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        MemoryCompactionPolicy policy = this.getMemoryCompactionPolicy();
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)AcidGuaranteesTestTool.TABLE_NAME).setValue("hbase.hregion.compacting.memstore.type", policy.name());
        if (policy == MemoryCompactionPolicy.EAGER) {
            builder.setValue("hbase.hregion.memstore.mslab.enabled", "false");
            builder.setValue("hbase.memstore.inmemoryflush.threshold.factor", "0.9");
        }
        Stream.of(AcidGuaranteesTestTool.FAMILIES).map(ColumnFamilyDescriptorBuilder::of).forEachOrdered(arg_0 -> ((TableDescriptorBuilder)builder).setColumnFamily(arg_0));
        UTIL.getAdmin().createTable(builder.build());
        this.tool.setConf(UTIL.getConfiguration());
    }

    @After
    public void tearDown() throws Exception {
        UTIL.deleteTable(AcidGuaranteesTestTool.TABLE_NAME);
    }

    private void runTestAtomicity(long millisToRun, int numWriters, int numGetters, int numScanners, int numUniqueRows) throws Exception {
        this.runTestAtomicity(millisToRun, numWriters, numGetters, numScanners, numUniqueRows, false);
    }

    private void runTestAtomicity(long millisToRun, int numWriters, int numGetters, int numScanners, int numUniqueRows, boolean useMob) throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new String[]{"-millis", String.valueOf(millisToRun), "-numWriters", String.valueOf(numWriters), "-numGetters", String.valueOf(numGetters), "-numScanners", String.valueOf(numScanners), "-numUniqueRows", String.valueOf(numUniqueRows), "-crazyFlush"});
        if (useMob) {
            args.add("-useMob");
        }
        this.tool.run(args.toArray(new String[0]));
    }

    @Test
    public void testGetAtomicity() throws Exception {
        this.runTestAtomicity(20000L, 5, 5, 0, 3);
    }

    @Test
    public void testScanAtomicity() throws Exception {
        this.runTestAtomicity(20000L, 5, 0, 5, 3);
    }

    @Test
    public void testMixedAtomicity() throws Exception {
        this.runTestAtomicity(20000L, 5, 2, 2, 3);
    }

    @Test
    public void testMobGetAtomicity() throws Exception {
        this.runTestAtomicity(20000L, 5, 5, 0, 3, true);
    }

    @Test
    public void testMobScanAtomicity() throws Exception {
        this.runTestAtomicity(20000L, 5, 0, 5, 3, true);
    }

    @Test
    public void testMobMixedAtomicity() throws Exception {
        this.runTestAtomicity(20000L, 5, 2, 2, 3, true);
    }
}

