/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.tool.BulkLoadHFilesTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface BulkLoadHFiles {
    public static final String RETRY_ON_IO_EXCEPTION = "hbase.bulkload.retries.retryOnIOException";
    public static final String MAX_FILES_PER_REGION_PER_FAMILY = "hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily";
    public static final String ASSIGN_SEQ_IDS = "hbase.mapreduce.bulkload.assign.sequenceNumbers";
    public static final String CREATE_TABLE_CONF_KEY = "create.table";
    public static final String IGNORE_UNMATCHED_CF_CONF_KEY = "ignore.unmatched.families";
    public static final String ALWAYS_COPY_FILES = "always.copy.files";

    public Map<LoadQueueItem, ByteBuffer> bulkLoad(TableName var1, Map<byte[], List<Path>> var2) throws TableNotFoundException, IOException;

    public void disableReplication();

    public boolean isReplicationDisabled();

    public Map<LoadQueueItem, ByteBuffer> bulkLoad(TableName var1, Path var2) throws TableNotFoundException, IOException;

    public static BulkLoadHFiles create(Configuration conf) {
        return new BulkLoadHFilesTool(conf);
    }

    @InterfaceAudience.Public
    public static class LoadQueueItem {
        private final byte[] family;
        private final Path hfilePath;

        public LoadQueueItem(byte[] family, Path hfilePath) {
            this.family = family;
            this.hfilePath = hfilePath;
        }

        public String toString() {
            return "family:" + Bytes.toString((byte[])this.family) + " path:" + this.hfilePath.toString();
        }

        public byte[] getFamily() {
            return this.family;
        }

        public Path getFilePath() {
            return this.hfilePath;
        }
    }
}

