/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceLogQueue;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryBatch;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryFilterRetryableException;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryStream;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class ReplicationSourceWALReader
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSourceWALReader.class);
    private final ReplicationSourceLogQueue logQueue;
    private final FileSystem fs;
    private final Configuration conf;
    private final WALEntryFilter filter;
    private final ReplicationSource source;
    @InterfaceAudience.Private
    final BlockingQueue<WALEntryBatch> entryBatchQueue;
    private final long replicationBatchSizeCapacity;
    private final int replicationBatchCountCapacity;
    private long currentPosition;
    private final long sleepForRetries;
    private final int maxRetriesMultiplier;
    private boolean isReaderRunning = true;
    private final String walGroupId;

    public ReplicationSourceWALReader(FileSystem fs, Configuration conf, ReplicationSourceLogQueue logQueue, long startPosition, WALEntryFilter filter, ReplicationSource source, String walGroupId) {
        this.logQueue = logQueue;
        this.currentPosition = startPosition;
        this.fs = fs;
        this.conf = conf;
        this.filter = filter;
        this.source = source;
        this.replicationBatchSizeCapacity = this.conf.getLong("replication.source.size.capacity", 0x4000000L);
        this.replicationBatchCountCapacity = this.conf.getInt("replication.source.nb.capacity", 25000);
        int batchCount = conf.getInt("replication.source.nb.batches", 1);
        this.sleepForRetries = this.conf.getLong("replication.source.sleepforretries", 1000L);
        this.maxRetriesMultiplier = this.conf.getInt("replication.source.maxretriesmultiplier", 300);
        this.entryBatchQueue = new LinkedBlockingQueue<WALEntryBatch>(batchCount);
        this.walGroupId = walGroupId;
        LOG.info("peerClusterZnode=" + source.getQueueId() + ", ReplicationSourceWALReaderThread : " + source.getPeerId() + " inited, replicationBatchSizeCapacity=" + this.replicationBatchSizeCapacity + ", replicationBatchCountCapacity=" + this.replicationBatchCountCapacity + ", replicationBatchQueueCapacity=" + batchCount);
    }

    private void replicationDone() throws InterruptedException {
        LOG.debug("Stopping the replication source wal reader");
        this.setReaderRunning(false);
        this.entryBatchQueue.put(WALEntryBatch.NO_MORE_DATA);
    }

    protected final int sleep(int sleepMultiplier) {
        if (sleepMultiplier < this.maxRetriesMultiplier) {
            ++sleepMultiplier;
        }
        Threads.sleep((long)(this.sleepForRetries * (long)sleepMultiplier));
        return sleepMultiplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        sleepMultiplier = 1;
        while (this.isReaderRunning()) {
            try {
                entryStream = new WALEntryStream(this.logQueue, this.fs, this.conf, this.currentPosition, this.source.getWALFileLengthProvider(), this.source.getSourceMetrics(), this.walGroupId);
                var3_5 = null;
lbl6:
                // 2 sources

                try {
                    while (this.isReaderRunning()) {
                        if (!this.source.isPeerEnabled()) {
                            Threads.sleep((long)this.sleepForRetries);
                            continue;
                        }
                        if (!this.checkBufferQuota()) continue;
                        currentPath = entryStream.getCurrentPath();
                        hasNext = entryStream.hasNext();
                        if (hasNext == WALEntryStream.HasNext.NO) {
                            this.replicationDone();
                            return;
                        }
                        if (currentPath != null && ReplicationSourceWALReader.switched(entryStream, currentPath)) {
                            this.entryBatchQueue.put(WALEntryBatch.endOfFile(currentPath));
                            continue;
                        }
                        if (hasNext == WALEntryStream.HasNext.RETRY) {
                            sleepMultiplier = this.sleep(sleepMultiplier);
                            continue;
                        }
                        if (hasNext == WALEntryStream.HasNext.RETRY_IMMEDIATELY) continue;
                        batch = this.createBatch(entryStream);
                        successAddToQueue = false;
                        try {
                            this.readWALEntries(entryStream, batch);
                            this.currentPosition = entryStream.getPosition();
                            ReplicationSourceWALReader.LOG.debug("Read {} WAL entries eligible for replication", (Object)batch.getNbEntries());
                            this.entryBatchQueue.put(batch);
                            successAddToQueue = true;
                            sleepMultiplier = 1;
                        }
                        finally {
                            if (successAddToQueue) ** GOTO lbl6
                            this.getSourceManager().releaseWALEntryBatchBufferQuota(batch);
                        }
                    }
                }
                catch (Throwable var4_8) {
                    var3_5 = var4_8;
                    throw var4_8;
                }
                finally {
                    if (entryStream == null) continue;
                    if (var3_5 != null) {
                        try {
                            entryStream.close();
                        }
                        catch (Throwable var6_11) {
                            var3_5.addSuppressed(var6_11);
                        }
                        continue;
                    }
                    entryStream.close();
                }
            }
            catch (WALEntryFilterRetryableException e) {
                ReplicationSourceWALReader.LOG.warn("Failed to filter WAL entries and the filter let us retry later", (Throwable)e);
                sleepMultiplier = this.sleep(sleepMultiplier);
            }
            catch (InterruptedException e) {
                ReplicationSourceWALReader.LOG.warn("Interrupted while sleeping between WAL reads or adding WAL batch to ship queue", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    protected final boolean addEntryToBatch(WALEntryBatch batch, WAL.Entry entry) {
        WALEdit edit = entry.getEdit();
        if (edit == null || edit.isEmpty()) {
            LOG.trace("Edit null or empty for entry {} ", (Object)entry);
            return false;
        }
        LOG.trace("updating TimeStampOfLastAttempted to {}, from entry {}, for source queue: {}", new Object[]{entry.getKey().getWriteTime(), entry.getKey(), this.source.getQueueId()});
        this.updateReplicationMarkerEdit(entry, batch.getLastWalPosition());
        long entrySize = this.getEntrySizeIncludeBulkLoad(entry);
        batch.addEntry(entry, entrySize);
        this.updateBatchStats(batch, entry, entrySize);
        boolean totalBufferTooLarge = this.getSourceManager().acquireWALEntryBufferQuota(batch, entry);
        return totalBufferTooLarge || batch.getHeapSize() >= this.replicationBatchSizeCapacity || batch.getNbEntries() >= this.replicationBatchCountCapacity;
    }

    protected static final boolean switched(WALEntryStream entryStream, Path path) {
        Path newPath = entryStream.getCurrentPath();
        return newPath == null || !path.getName().equals(newPath.getName());
    }

    protected void readWALEntries(WALEntryStream entryStream, WALEntryBatch batch) throws InterruptedException {
        WALEntryStream.HasNext hasNext;
        Path currentPath = entryStream.getCurrentPath();
        do {
            WAL.Entry entry = entryStream.next();
            batch.setLastWalPosition(entryStream.getPosition());
            entry = this.filterEntry(entry);
            if (entry != null && this.addEntryToBatch(batch, entry)) break;
            hasNext = entryStream.hasNext();
            if (!ReplicationSourceWALReader.switched(entryStream, currentPath)) continue;
            batch.setEndOfFile(true);
            break;
        } while (hasNext == WALEntryStream.HasNext.YES);
    }

    public Path getCurrentPath() {
        WALEntryBatch batchQueueHead = (WALEntryBatch)this.entryBatchQueue.peek();
        if (batchQueueHead != null) {
            return batchQueueHead.getLastWalPath();
        }
        return this.logQueue.getQueue(this.walGroupId).peek();
    }

    private boolean checkBufferQuota() {
        if (!this.getSourceManager().checkBufferQuota(this.source.getPeerId())) {
            Threads.sleep((long)this.sleepForRetries);
            return false;
        }
        return true;
    }

    private WALEntryBatch createBatch(WALEntryStream entryStream) {
        return new WALEntryBatch(this.replicationBatchCountCapacity, entryStream.getCurrentPath());
    }

    protected final WAL.Entry filterEntry(WAL.Entry entry) {
        if (entry != null && WALEdit.isReplicationMarkerEdit(entry.getEdit())) {
            return entry;
        }
        WAL.Entry filtered = this.filter.filter(entry);
        if (entry != null && (filtered == null || filtered.getEdit().size() == 0)) {
            LOG.trace("Filtered entry for replication: {}", (Object)entry);
            this.source.getSourceMetrics().incrLogEditsFiltered();
        }
        return filtered;
    }

    public WALEntryBatch take() throws InterruptedException {
        return this.entryBatchQueue.take();
    }

    public WALEntryBatch poll(long timeout) throws InterruptedException {
        return this.entryBatchQueue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    private long getEntrySizeIncludeBulkLoad(WAL.Entry entry) {
        WALEdit edit = entry.getEdit();
        return WALEntryBatch.getEntrySizeExcludeBulkLoad(entry) + (long)this.sizeOfStoreFilesIncludeBulkLoad(edit);
    }

    private void updateBatchStats(WALEntryBatch batch, WAL.Entry entry, long entrySize) {
        WALEdit edit = entry.getEdit();
        batch.incrementHeapSize(entrySize);
        Pair<Integer, Integer> nbRowsAndHFiles = this.countDistinctRowKeysAndHFiles(edit);
        batch.incrementNbRowKeys((Integer)nbRowsAndHFiles.getFirst());
        batch.incrementNbHFiles((Integer)nbRowsAndHFiles.getSecond());
    }

    private Pair<Integer, Integer> countDistinctRowKeysAndHFiles(WALEdit edit) {
        ArrayList<Cell> cells = edit.getCells();
        int distinctRowKeys = 1;
        int totalHFileEntries = 0;
        Cell lastCell = (Cell)cells.get(0);
        int totalCells = edit.size();
        for (int i = 0; i < totalCells; ++i) {
            if (CellUtil.matchingQualifier((Cell)((Cell)cells.get(i)), (byte[])WALEdit.BULK_LOAD)) {
                try {
                    WALProtos.BulkLoadDescriptor bld = WALEdit.getBulkLoadDescriptor((Cell)cells.get(i));
                    List stores = bld.getStoresList();
                    int totalStores = stores.size();
                    for (int j = 0; j < totalStores; ++j) {
                        totalHFileEntries += ((WALProtos.StoreDescriptor)stores.get(j)).getStoreFileList().size();
                    }
                }
                catch (IOException e) {
                    LOG.error("Failed to deserialize bulk load entry from wal edit. Then its hfiles count will not be added into metric.", (Throwable)e);
                }
            }
            if (!CellUtil.matchingRows((Cell)((Cell)cells.get(i)), (Cell)lastCell)) {
                ++distinctRowKeys;
            }
            lastCell = (Cell)cells.get(i);
        }
        Pair result = new Pair((Object)distinctRowKeys, (Object)totalHFileEntries);
        return result;
    }

    private int sizeOfStoreFilesIncludeBulkLoad(WALEdit edit) {
        ArrayList<Cell> cells = edit.getCells();
        int totalStoreFilesSize = 0;
        int totalCells = edit.size();
        for (int i = 0; i < totalCells; ++i) {
            if (!CellUtil.matchingQualifier((Cell)((Cell)cells.get(i)), (byte[])WALEdit.BULK_LOAD)) continue;
            try {
                WALProtos.BulkLoadDescriptor bld = WALEdit.getBulkLoadDescriptor((Cell)cells.get(i));
                List stores = bld.getStoresList();
                int totalStores = stores.size();
                for (int j = 0; j < totalStores; ++j) {
                    totalStoreFilesSize = (int)((long)totalStoreFilesSize + ((WALProtos.StoreDescriptor)stores.get(j)).getStoreFileSizeBytes());
                }
                continue;
            }
            catch (IOException e) {
                LOG.error("Failed to deserialize bulk load entry from wal edit. Size of HFiles part of cell will not be considered in replication request size calculation.", (Throwable)e);
            }
        }
        return totalStoreFilesSize;
    }

    private void updateReplicationMarkerEdit(WAL.Entry entry, long offset) {
        WALEdit edit = entry.getEdit();
        if (!WALEdit.isReplicationMarkerEdit(edit)) {
            return;
        }
        ArrayList<Cell> cells = edit.getCells();
        Preconditions.checkArgument((cells.size() == 1 ? 1 : 0) != 0, (Object)"ReplicationMarker should have only 1 cell");
        Cell cell = (Cell)cells.get(0);
        WALProtos.ReplicationMarkerDescriptor.Builder builder = WALProtos.ReplicationMarkerDescriptor.newBuilder();
        builder.setRegionServerName(this.source.getServer().getServerName().getHostname());
        builder.setWalName(this.getCurrentPath().getName());
        builder.setOffset(offset);
        WALProtos.ReplicationMarkerDescriptor descriptor = builder.build();
        KeyValue kv = new KeyValue(CellUtil.cloneRow((Cell)cell), CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell), cell.getTimestamp(), descriptor.toByteArray());
        ArrayList<Cell> newCells = new ArrayList<Cell>();
        newCells.add((Cell)kv);
        edit.setCells(newCells);
    }

    public boolean isReaderRunning() {
        return this.isReaderRunning && !this.isInterrupted();
    }

    public void setReaderRunning(boolean readerRunning) {
        this.isReaderRunning = readerRunning;
    }

    private ReplicationSourceManager getSourceManager() {
        return this.source.getSourceManager();
    }
}

